//=============================================================================
//
// file :               Tango_ds.h
//
// description :        Main include for Tango device server  
//
// project :            TANGO
//
// author(s) :          A.Gotz + E.Taurel
//
// $Revision: 1.3 $
//
// $Log: tango_ds.h,v $
// Revision 1.3  2000/04/13 10:40:42  taurel
// Added attribute support
//
// Revision 1.2  2000/02/04 11:00:16  taurel
// Just update revision number
//
// Revision 1.1.1.1  2000/02/04 10:58:29  taurel
// Imported sources
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//=============================================================================

#ifndef _TANGO_DS_H
#define _TANGO_DS_H

//
// Insert typeinfo file as the first include file (needed for Hp-UX aCC as the
// first include file)

#include <typeinfo>

//
// Include CORBA files
//

#include <OB/CORBA.h>

//
// Include stream header files
//

#ifdef WIN32
	#include <iostream>
	#include <sstream>
	#include <fstream>
#else
	#include <iostream.h>
	#include <strstream.h>
	#include <fstream.h>
#endif

//
// Special case for the assert function.
// The assert call needs the assert.h include file. For Windows and VC5, when
// compiling in mode Release, VC defines NDEBUG. In the assert.h file, if
// the NDEBUG variable is defined, this replace the assert call by nothing !!
//

#ifdef WIN32
	#ifdef NDEBUG
		#undef NDEBUG
		#include <assert.h>
		#define NDEBUG
	#else
		#include <assert.h>
	#endif
#else
	#include <assert.h>
#endif

//
// Include some stdc++ library headers
//

#include <string>
#include <vector>

//
// Include IDL generated files
//

#include <tango.h>

//
// Include Tango utility files
//

#include <tango_const.h>
#include <tango_config.h>
#include <tango_utils.h>

//
// Include Tango files in order to simplfy device server developer include
// file list
//

#include <device.h>
#include <command.h>
#include <dserver.h>

	
#endif /* TANGO_DS_H */
