import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * webIORServlet. Stores a stringified IOR and sends a static HTML page.
 */
public class webIORServlet extends HttpServlet 
{
	static java.io.PrintWriter cout =
	         new java.io.PrintWriter(System.out, true);
	static String httpdBase;

public void init(ServletConfig config) throws ServletException
{
   super.init(config);
	//Get the base directory for the serving httpd
	httpdBase = config.getInitParameter("HttpdBase");
	if( httpdBase == null )
		throw new UnavailableException(this,
		                               "The \"HttpdBase\" property must be set!");
}

public void doGet ( HttpServletRequest  request,
						 HttpServletResponse response) 
		 throws ServletException, IOException             
{
    // Set the MIME type for the information being sent to the browser.
    // In this case, we are going to send back HTML
    response.setContentType( "text/html" );

	 //Get the stringified IOR
	 String IOR = request.getParameter("IORS");
	 //Get the gateway's host
	 String gtwHost = request.getParameter("GTWH");

	 //Write the IOR to a file.
	 String fname = 
	    new String(httpdBase+"/ior/gtw/"+gtwHost);
	 java.io.PrintWriter fout = 
	   new java.io.PrintWriter(new java.io.FileOutputStream(fname));
	 fout.println( IOR );
	 fout.close();

    // Get a reference to the output stream. 
    // Anything written to this stream is sent directly to the browser
    // (The browser sees this as its input).
    ServletOutputStream out = response.getOutputStream();
    // The following println statements create an HTML page.
    // Notice that the <html></html>, <head></head>, and <body></body>
    // tags are all properly formed HTML syntax.
    out.println( "<html>" );
    out.println( "<head><title>"+fname+"</title></head>" );
    out.println( "<body>" );
    out.println( IOR );
    out.println( "</body>" );
    out.println( "</html>" );
    out.close();
}
}
