
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class OregonMaxeAdd extends HttpServlet 
{

	static ORB orb;
	Device dbase;

	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		try
        	{
			Properties props = System.getProperties();
			props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
			props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
			System.setProperties(props);
			String[] args = new String[1];
			args[0] = new String("nada");
//            		orb = ORB.init(this, new java.util.Properties());
            		orb = ORB.init(args, props);
			org.omg.CORBA.Object obj = ((com.ooc.CORBA.ORB)orb).string_to_object("iiop://dumela:10000/database");
			dbase = Tango.DeviceHelper.narrow(obj);

		}
		catch(SystemException ex)
       		{
    			System.out.println("init(): ORB failed !");
			ex.printStackTrace();
		}
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
		try
		{
			String server = req.getParameter("instance");
			String device = req.getParameter("device");
			String nb_axes = req.getParameter("nb_axes");
			int n_axes = Integer.parseInt(nb_axes);
			String descriptor = req.getParameter("descriptor");
			String events = req.getParameter("events");
			String axis = req.getParameter("axis");
			String channel = req.getParameter("channel");
			int n_channel = Integer.parseInt(channel);
			String velocity = req.getParameter("velocity");
			String firststeprate = req.getParameter("firststeprate");
			String acceleration = req.getParameter("acceleration");
			String backlash = req.getParameter("backlash");
			String[] device_properties = new String[11+n_axes*3];
			device_properties[0] = device;
			device_properties[1] = String.valueOf(3+n_axes);
			device_properties[2] = new String("nb_axes");
			device_properties[3] = String.valueOf(1);
			device_properties[4] = nb_axes;
			device_properties[5] = new String("descriptor");
			device_properties[6] = String.valueOf(1);
			device_properties[7] = descriptor;
			device_properties[8] = new String("events");
			device_properties[9] = String.valueOf(1);
			device_properties[10] = events;
			int n_channel_tmp = n_channel;
			for (int i=0; i < n_axes; i++)
			{
				device_properties[10+i*3+1] = new String("axe") + String.valueOf(i+1);
				device_properties[10+i*3+2] = String.valueOf(1);
				device_properties[10+i*3+3] = axis + "/" + String.valueOf(n_channel_tmp);
				n_channel_tmp++;
			}
			Any send = orb.create_any();
			DevVarStringArrayHelper.insert(send,device_properties);
			Any received = dbase.command_inout(new String("DbPutDeviceProperty"),send);
			res.setContentType("text/html");
			PrintWriter out = res.getWriter();
			out.println("<HTML>");
			out.println("<HEAD><TITLE>TANGO OregonMaxe Wizard  - Add Device</TITLE></HEAD>");
			out.println("<BODY text=\"#000000\" bgcolor=\"#FFFFFF\" link=\"#0000EF\" vlink=\"#51188E\" alink=\"#FF0000\">");
			out.println("<CENTER><H1>OregonMaxe Wizard - Add Device</H1></CENTER>");
			out.println("<P>");
			out.println("<FONT SIZE=+2>");
			out.println("The OregonMaxe Device Wizard has added the following properties for the device <I>" + device + "</I>  of class <I>OregonMaxe</I> served by the device server <I>OregonMaxe/" + server + "</I>  to the TANGO database :");
			out.println("<P>");
			out.println("device <I>"+device+"</I> no. of properties <I>4</I><BR><BR>");
			for (int i=2; i<(11+n_axes*3); i+=3)
			{
				out.println("<I>"+device_properties[i]+"</I> = <I>"+device_properties[i+2]+"</I><BR>");
			}
//
// add proerpties for n axes
//
			String[] axis_properties = new String[17];
			for (int i = 0; i< n_axes; i++)
			{
				axis_properties[0] = axis + "/" + String.valueOf(n_channel);
				axis_properties[1] = String.valueOf(5);
				axis_properties[2] = new String("channel");
				axis_properties[3] = String.valueOf(1);
				axis_properties[4] = String.valueOf(n_channel); n_channel++;
				axis_properties[5] = new String("velocity");
				axis_properties[6] = String.valueOf(1);
				axis_properties[7] = velocity;
				axis_properties[8] = new String("firststeprate");
				axis_properties[9] = String.valueOf(1);
				axis_properties[10] = firststeprate;
				axis_properties[11] = new String("acceleration");
				axis_properties[12] = String.valueOf(1);
				axis_properties[13] = acceleration;
				axis_properties[14] = new String("backlash");
				axis_properties[15] = String.valueOf(1);
				axis_properties[16] = backlash;
				DevVarStringArrayHelper.insert(send,axis_properties);
				received = dbase.command_inout(new String("DbPutDeviceProperty"),send);
	
				out.println("<P>");
				out.println("axis <I>"+axis_properties[0]+"</I> no. of properties <I>5</I><BR><BR>");
				for (int j=2; j<17; j+=3)
				{
					out.println("<I>"+axis_properties[j]+"</I> = <I>"+axis_properties[j+2]+"</I><BR>");
				}
			}
			out.println("</FONT>");
			out.println("</BODY>");
			out.println("</HTML>");
		}
		catch(SystemException ex)
       		{
    			System.out.println("init(): ORB failed !");
//			ex.printStackTrace();
		}
		catch(DevFailed ex)
       		{
			System.out.println("init(): command_inout() failed !");
			ex.printStackTrace();
		}
	}
}
