
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbGetClassAttribute extends HttpServlet 
{

 static ORB orb;
 Device dbase;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Get Class Attributes";
 static String servlet_name = "DbGetClassAttribute";

 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }


 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();

   //
   // Get from HTML page user values given in the input forms
   //
   String class_name = req.getParameter("class");
   String dbase_host = req.getParameter("dbase_host");
   String dbase_port = req.getParameter("dbase_port");


   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;


   //
   // Get Class attribute names
   //
   Any received;
   Any send = null;
   String[] class_get = null;
   String[] attribute_names = null;

   try
   {
    send = orb.create_any();
    class_get = new String[2];
    class_get[0] = class_name;
    class_get[1] = "*";
    DevVarStringArrayHelper.insert(send,class_get);
    received = dbase.command_inout(new String("DbGetClassAttributeList"),send);
    attribute_names = DevVarStringArrayHelper.extract(received);
   }
   catch(DevFailed ex)
   {
    getServletContext().log(servlet_name + 
	": DbGetClassAttributeList failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();
    message.addElement("The command <I>DbGetClassAttributeList</I> failed.");
    message.addElement(ex.errors[0].reason);
    message.addElement(ex.errors[0].origin);
    HtmlHelper.error(out, title, message);

    return;
   }


   //
   // Get Class attribute properties and values
   //
   String[] attribute_values = null;
   try
   {
    class_get = new String[attribute_names.length + 1];
    class_get[0] = class_name;
    for(int i=0;i<attribute_names.length;i++)
     class_get[i+1] = attribute_names[i];
    DevVarStringArrayHelper.insert(send,class_get);
    received = dbase.command_inout(
	new String("DbGetClassAttributeProperty"),send);
    attribute_values = DevVarStringArrayHelper.extract(received);
   }
   catch(DevFailed ex)
   {
    getServletContext().log(servlet_name + 
	": DbGetClassAttributeProperty failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();
    message.addElement(
	"The command <I>DbGetClassAttributeProperty</I> failed.");
    message.addElement(ex.errors[0].reason);
    message.addElement(ex.errors[0].origin);
    HtmlHelper.error(out, title, message);
 
    return;
   }


   //
   // Generate servlet output (i.e. HTML page send back to httpd client)
   //
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);


   out.println("<P>");
   out.println("The class <I>"+ class_name + "</I> has the following ");
   out.println("attributes stored in the database  :");
   out.println("<P>");

   out.println("<TABLE BORDER CELLPADDING=\"5\">");

   out.println("<TR>");
   out.println("<TH>Name</TH>");
   out.println("<TH>Properties</TH>");
   out.println("<TH>Values</TH>");
   out.println("</TR>");

   for (int i=2; i<attribute_values.length;)
   {
    int j;
    int nb_properties = Integer.parseInt(attribute_values[i+1]);

    out.println("<TR>");
    out.println("<TD ROWSPAN=" + nb_properties +
	"><I>"+attribute_values[i]+"</I></TD>");
    for(j=0; j<Integer.parseInt(attribute_values[i+1]);j++)
    {
     out.println("<TD><I>"+attribute_values[i+2+(j*2)]+"</I></TD>");
     out.println("<TD><I>"+attribute_values[i+2+(j*2)+1]+"</I></TD>");
     out.println("</TR>");

     out.println("<TR>");
    }
    i=i+2+(j*2);
    out.println("</TR>");
   }
   out.println("</TABLE>");
   out.println("<P>");


   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
