/*****************************************************************************
 *
 */
import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.InetAddress;


/****************************************************************************
 *
 */
public class DbGet extends HttpServlet 
			implements TangoConst
{
 DbHelper	dbase;
 PrintWriter	out;
 String		dbase_host = "tango";
 String		dbase_port = "10000";


 boolean        verbose_level = true; // default verbose level


 /**********************************
  *
  */
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }


 /**********************************
  *
  */
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  Tango.DevCmdInfo[] commands;
  int		nb_commands;
  int 		j;
  int 		i;


  //
  // Get the local machine name (for log purpose only).
  // NOTE: getRemoteHost() returns a null String!! Getting IP instead.
  //
  String client_addr = null;
  client_addr = req.getRemoteAddr();


  //
  // Log a minimum in log files
  //
  debug("doGet()  from: " + client_addr);



  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();



  // 
  // Get from HTML page user values given in the input forms
  //
  dbase_host = req.getParameter("dbase_host");
  debug("host: " + dbase_host);
  dbase_port = req.getParameter("dbase_port");
  debug("port: " + dbase_port);



  //
  // Get access the TANGO database device server
  //
  try
  {   
   dbase = new DbHelper(dbase_host, dbase_port); 
  }
  catch(SystemException e)
  {
   Vector message = new Vector();

   message.addElement("ORB failed connecting to database " +
	dbase_host + ":" + dbase_port);
 
   HtmlHelper.error(out, "Get Device Properties", message);
   return;
  }
  catch(DevFailed e)
  { 
   Vector message = new Vector();

   message.addElement("failed to import database " + 
	dbase_host + ":" + dbase_port);
   message.addElement("reason: " + e.errors[0].reason);
   message.addElement("origin: " + e.errors[0].origin);
 
   HtmlHelper.error(out, "Get Device Properties", message);
   return;
  }




   



  //
  // Generate servlet output (i.e. HTML page send back to httpd client)
  //
  HtmlHelper.head(out, "Browse Device Properties");

  out.println("<P>");


  //
  // Applet call with its hidden parameter
  //
  out.println("<APPLET CODEBASE=/ CODE=\"DbGetApplet.class\"" +
	"WIDTH=100% HEIGHT=600 " +
	"ARCHIVE=\"Tango.jar\">");

  out.println("<PARAM NAME=\"dbase_host\" VALUE=\"" +
	dbase_host +
	"\">");

  out.println("<PARAM NAME=\"dbase_port\" VALUE=\"" +
	dbase_port +
	"\">");

  out.println("</APPLET>");


  HtmlHelper.bottom(out);
 }


 /**********************************
  *
  */
 private void debug(String message)
 {
  if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log(
        "DbGet: " + message);
  }
 }


}
