
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbDelClassProperty extends HttpServlet 
{

 static ORB orb;
 Device dbase;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Delete Class Property";
 static String servlet_name = "DbDelClassProperty";



 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }

 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();

   //
   // Get from HTML page user values given in the input forms
   //
   String class_name = req.getParameter("class_name");
   String dbase_host = req.getParameter("dbase_host");
   String dbase_port = req.getParameter("dbase_port");
   String property_name = req.getParameter("property_name");

   getServletContext().log(servlet_name + ": class_name " + class_name);
   getServletContext().log(servlet_name + ": property " + property_name);


   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;




   //
   // Delete the class property from the TANGO database
   //
   Any send = orb.create_any();
   String[] del_class = new String[2];
   del_class[0] = class_name;
   del_class[1] = property_name;
   DevVarStringArrayHelper.insert(send, del_class);
   Any received = dbase.command_inout(
	new String("DbDeleteClassProperty"),send);
 


   //
   // Prepare HTML page to return
   //
   res.setContentType("text/html");
   PrintWriter out = res.getWriter();

   HtmlHelper.head(out, "Database Web Control Center<br>" + title);

   out.println("<P>");
   out.println("The property <B>" + property_name + "</B> ");
   out.println("of the class <B>" + class_name + "</B> ");
   out.println("has been successfully removed from the TANGO database");
   out.println("<P>");

   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbDeleteClassProperty failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbDeleteClassProperty</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
