
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbAddDeviceAttribute extends HttpServlet 
{
 static ORB orb;
 Device dbase;
 String	host  = null;
 String port  = null;
 String	attribute_name;
 Vector	list_param_name	= new Vector();
 Vector	list_param_val	= new Vector();
 String	param_name;
 PrintWriter out = null;

 static String title = "Add Device Attribute";
 static String servlet_name = "DbAddDeviceAttribute";



 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }

 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {

  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();


   // 
   // Get from HTML page user values given in the input forms
   //

   // First get the mandatory parameters (device, etc...)
   // TODO: throw an error if not present
   String device     = req.getParameter("device");
   String dbase_host = req.getParameter("dbase_host");
   String dbase_port = req.getParameter("dbase_port");
   String mode       = req.getParameter("mode");
   getServletContext().log(servlet_name + ": for " + device);

   // Remove any remaining properties from a previous call to this
   list_param_name.removeAllElements();
   list_param_val.removeAllElements();

  
   // Check if not using this servlet in a single property mode
   // in this case the property name is given from the user and not
   // hard coded in the HMTL page.
   if(mode != null)
   {
    attribute_name = req.getParameter("attribute_name");
    list_param_name.addElement(req.getParameter("property_name"));
    list_param_val.addElement(req.getParameter("property_value"));
   }
   else
   {
    String error_label = servlet_name + ": mode not implemented!";
    getServletContext().log(error_label);

    // Messages available on a separate HTML page
    Vector message = new Vector();
    message.addElement(error_label);
    HtmlHelper.error(out, title, message);

/*
    // Get the names of all parameters (i.e. input forms on HTML page)
    // including mandatory parameters (device, etc...)
    Enumeration 	enum_param  	= req.getParameterNames();


    // Get properties names and values 
    while(enum_param.hasMoreElements())
    {
     param_name = (String)enum_param.nextElement(); 
    
     // remove mandatory parameter names (device, etc...) 
     if(!param_name.toLowerCase().equals("device") &&
        !param_name.toLowerCase().equals("dbase_host") &&
        !param_name.toLowerCase().equals("dbase_port"))
     {
      list_param_name.addElement(param_name); 
      list_param_val.addElement(req.getParameter(param_name));
     }
    }
*/
   }


   // Get the number of properties for the device
   int	  nb_properties = list_param_name.size();



   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;



   //
   // Prepare arguments for adding attribute and its properties to the device
   //
   // Syntax of DbPutDeviceAttributeProperty() is:
   //   -device name 
   //	-the number of attributes
   //	-attribute name
   //	-the number of attribute properties
   //	-list of attribute properties
   // Each attribute property follow the same rule:
   //   -property name
   //   -property value
   // All arguments of  DbPutDeviceAttributeProperty() must be converted 
   // to string.
   //
   String[] device_properties = new String[nb_properties*2 + 4];
   int	i=0;
   device_properties[i++] = device;
   device_properties[i++] = "1"; // add a single attribute
   device_properties[i++] = attribute_name;
   device_properties[i++] = String.valueOf(nb_properties);

   for(int j=0;j<nb_properties;j++)
   {
    device_properties[i++] = (String)list_param_name.elementAt(j);
    device_properties[i++] = (String)list_param_val.elementAt(j);
   }




   //
   // Add the attribute to the device (i.e. proceed the 
   // command DbPutDeviceAttributeProperty() to DataBaseds TANGO server)
   //
   Any send = orb.create_any();
   DevVarStringArrayHelper.insert(send,device_properties);
   Any received = dbase.command_inout(
	new String("DbPutDeviceAttributeProperty"),send);


   //
   // Generate servlet output (i.e. HTML page send back to httpd client)
   //
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);

   out.println("<P>");
   out.println("The TANGO Wizard has added the following attribute");
   out.println("for the device <I>" + device + "</I> to the TANGO database :");

   out.println("<P>");
   int j = 0;
   out.println("device <I>"+device_properties[j++]+"</I> ");
   out.println("has <I>"+device_properties[j++]+"</I> attribute:<BR><BR>");

   out.println("<TABLE BORDER CELLPADDING=\"5\">");

   out.println("<TR>");
   out.println("<TH>Name</TH>");
   out.println("<TH>Property</TH>");
   out.println("<TH>Value</TH>");
   out.println("</TR>");

   out.println("<TR>");
   out.println("<TD ROWSPAN=" + nb_properties +
	"><I>"+device_properties[j++]+"</I></TD>");
   j++;
   for (; j<i; j+=2)
   {
    out.println("<TD><I>"+device_properties[j]+"</I></TD>");
    out.println("<TD><I>"+device_properties[j+1]+"</I></TD>");
    out.println("</TR>");
    out.println("<TR>");
   }
   out.println("</TABLE>");
   out.println("<P>");

   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + 
	": DbPutDeviceAttributeProperty failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(
	"The command <I>DbPutDeviceAttributeProperty</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
  }
 }

 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }

}
