
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbAddDevice extends HttpServlet 
{

 static ORB orb;
 Device dbase;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Add Device";
 static String servlet_name = "DbAddDevice";



 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }

 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();

   //
   // Get from HTML page user values given in the input forms
   //
   String server = req.getParameter("server");
   String device = req.getParameter("device");
   String device_class = req.getParameter("class");
   String dbase_host = req.getParameter("dbase_host");
   String dbase_port = req.getParameter("dbase_port");

   getServletContext().log(servlet_name + ": server " + server);
   getServletContext().log(servlet_name + ": device " + device);
   getServletContext().log(servlet_name + ": class  " + device_class);


   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;




   //
   // Add the device to the TANGO database
   //
   String[] server_device = new String[3];
   server_device[0] = server;
   server_device[1] = device;
   server_device[2] = device_class;
   Any send = orb.create_any();
   DevVarStringArrayHelper.insert(send,server_device);
   Any received = dbase.command_inout(new String("DbAddDevice"),send);
 


   //
   // Prepare HTML page to return
   //
   res.setContentType("text/html");
   PrintWriter out = res.getWriter();

   HtmlHelper.head(out, "Database Web Control Center<br>" + title);

   out.println("<P>");
   out.println("The following device <B>" + device + "</B> ");
   out.println("of class <B>" + device_class + "</B> served by the ");
   out.println("device server <B>" + server + "</B>  has been ");
   out.println("successfully added to the TANGO database");
   out.println("<P>");

   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbAddDevice failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbAddDevice</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
