/*****************************************************************************
 *
 * Structure of the JDEVMENU web based application:
 *
 * -the client choose the device name from an HTML form.
 * 
 * -the "submit" button of the form with run on the web server the servlet
 *  called "CmdGet".
 * 
 * -as output "CmdGet" will send back to the client an HTML page containing:
 *	-the list of the device commands (name, argin and argout types and 
 *	 descriptions)
 *	-for each command a form wich submit will run on the web server
 *	 the servlet "CmdExec" calling its "doPost()" method.
 *	-a display command history form which submit will run on the web server
 *	 the servlet "CmdHistDispatch" calling its "doGet()" method.
 * 
 * -when the client request a command history (i.e. form submit calling 
 *  "CmdHistDispatch:doGet()" method):
 *	-the HTML page of the servlet will be sent back to the client
 * 	 in a separate window (cf target field of the form).
 *	-the name of this window will be "cmd_hist_" followed by the
 *	 device name.
 * 	-if a window with this name already exist, its contains will be
 *	 erased from the new output of "CmdHistDispatch" (i.e. command
 *	 history cleared) exactly as when the "Reload" button of the client
 *	 browser is depressed.
 * 	-if the window does not exist it's created by the client browser.
 *	-the HTML page sent back will contain an applet which code can
 *	 be found in "htdocs/CmdHistApplet.java"
 *	-the structure of this applet is:
 *		-display a textarea field and then get in a never ending
 *		 loop until the client browser window is closed.
 *		-the loop consist in calling "CmdExec:doGet()" method
 *		 passing the device name. The return of this method
 *		 is a new command result which applet add to the textarea.
 *		-As the client applet can not know when there is a
 *		 a result, "CmdExec:doGet()" is blocked by the servlet. 
 *		-Note: the "CmdExec:doGet()" may return on a timeout because
 *		 the server is not answering. This case is detected by
 *		 the applet which immediatly recall "CmdExec:doGet()".
 *		-the servlet "CmdExec" decides to return the pending
 *		 "doGet()" its "doPost()" method is called. This method
 *		 is called when the client request a command execution (see
 *		 afterward). Inside the servlet threads the communication 
 *		 between "doPost()" and "doGet()" is done with pairs of
 *		 "Observable/Observer"objets.
 *		-the "Observable" object is called "source", there is one
 *		 per client (i.e. command history applet) and they are
 *		 stored internally by the servlet in a vector.
 *		-the first time the applet calls "CmdExec:doGet()" the source
 *		 is created in the vector.
 *		-when the client browser window is closed the applet
 *		 will call "CmdExec:doGet()" passing the device name
 *		 but preceeded by the string "finished". "CmdExec" will 
 *		 like this know that it no more has to notify command
 *		 results to this client. It will remove the corresponding
 *		 "source" objet from its internal list and return 
 *		 immediately the "doGet()" to the client.
 *
 * -when the client request a command executtion (i.e form submit calling
 *  "CmdExec:doPost()" method):
 *	-the command parameters are retrieved from the HTML page.
 *	-the command is requested to the device.
 *	-the client corresponding "source" object (i.e. "Observable" part
 *	 of the "Obervable/Observer" pairs) is notified with the command result.
 *	-this notification will wake up the "sink" (i.e. "Observer" part of
 *	 the pair) and therefore return the "CmdExec:doGet()" method (see
 *	 above).
 *	-as the return of "CmdExec:doPost()" must be an HTML page because
 *	 the client browser is expecting one, the HTML page sent back
 *	 contains a JavaScript command to tell the browser to go back to
 *	 its previous HTML page (i.e. the page containing the device command
 *	 list), exactly as when the "Back" button of the client
 *	 browser is depressed.
 *
 */
import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.InetAddress;


/****************************************************************************
 *
 */
public class CmdGet_old extends HttpServlet 
			implements TangoConst
{

 static 	ORB orb;
 Device		dbase;
 PrintWriter	out;




 /**
  *
  */
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
  try
  {
   Properties props = System.getProperties();
   props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
   props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
   System.setProperties(props);
   String[] args = new String[1];
   args[0] = new String("nada");
//   orb = ORB.init(this, new java.util.Properties());
   orb = ORB.init(args, props);
   org.omg.CORBA.Object obj = ((com.ooc.CORBA.ORB)orb).string_to_object("iiop://tango:10000/database");
   dbase = Tango.DeviceHelper.narrow(obj);
  }
  catch(SystemException ex)
  {
   System.out.println("init(): ORB failed !");
   ex.printStackTrace();
  }
 }


 /**
  *
  */
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  int j;
  int i;
  // Need to be defined outside the try() to be known by the catch()
  String device_name = new String("");


  //
  // Get the local machine name (send afterware to CmdExec servlet
  // for log purpose only).
  // NOTE: getRemoteHost() returns a null String!! Getting IP instead.
  //
  String client_addr = null;
  client_addr = req.getRemoteAddr();


  //
  // Log a minimum in log files
  //
  getServletContext().log("CmdGet_old: doGet()  from: " + client_addr);



  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();



   // 
   // Get from HTML page user values given in the input forms
   //

   // The device parameter is mandatory
   // TODO: throw an error if not present
   device_name = req.getParameter("device");
   System.out.println("DEBUG: device name: "+ device_name);



   //
   // Import the device wanted 
   //
 
   // Get from TANGO database the informations needed to connect to the device
   Any send = orb.create_any();
   DevStringHelper.insert(send,device_name);
   Any received = dbase.command_inout(new String("DbImportDevice"),send);

   // Extract the IOR from informations
   DevVarLongStringArray db_received;
   db_received = DevVarLongStringArrayHelper.extract(received);

   // Check if the device is defined in the database but not exported
   if(db_received.lvalue[0] == 0)
   {
    Vector message = new Vector();

    message.addElement("Unable to import device <I>" + device_name + "</I>");
    message.addElement("The device is defined in the TANGO database " +
        "but not currently exported.");
    message.addElement("Please check that the TANGO device server is running.");

    HtmlHelper.error(out, "Get Device Command", message);
   }

   // Import the TANGO device
   org.omg.CORBA.Object obj;
   obj = ((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
   Device device = Tango.DeviceHelper.narrow(obj);
  


   //
   // Get the command list for the device (i.e. proceed the 
   // command command_list_query() on the device itself)
   //
   Tango.DevCmdInfo[] dev_commands = device.command_list_query();
   System.out.println("DEBUG: nb of commands: "+ dev_commands.length);
   
   // Get the number of commands of this device
   int nb_commands = dev_commands.length;




   //
   // Add CORBA operations available on all devices
   //
   Tango.DevCmdInfo[] commands = new Tango.DevCmdInfo[nb_commands + 3];
   

   // Add the CORBA commands
   i=0;
   commands[i] = new Tango.DevCmdInfo();
   commands[i].cmd_name      = "BlackBox";
   commands[i].in_type       = Tango_DEV_LONG;
   commands[i].in_type_desc  = "Nb commands";
   commands[i].out_type      = Tango_DEVVAR_STRINGARRAY;
   commands[i].out_type_desc = "Last commands";
   i++;
   commands[i] = new Tango.DevCmdInfo();
   commands[i].cmd_name      = "Info";
   commands[i].in_type       = Tango_DEV_VOID;
   commands[i].in_type_desc  = "";
   commands[i].out_type      = Tango_DEV_STRING;
   commands[i].out_type_desc = "Device infos";
   i++;
   commands[i] = new Tango.DevCmdInfo();
   commands[i].cmd_name      = "Ping";
   commands[i].in_type       = Tango_DEV_VOID;
   commands[i].in_type_desc  = "";
   commands[i].out_type      = Tango_DEV_STRING;
   commands[i].out_type_desc = "Device alive";
   i++;

   // Copy the device specific commands
   for (j=0; j<nb_commands; j++)
    commands[j+i] = dev_commands[j];

   // Update the global number of commands available
   nb_commands = commands.length;


   //
   // Generate servlet output (i.e. HTML page send back to httpd client)
   //
   HtmlHelper.head(out, "Get Device Command");

   out.println("<P>");
   out.println("The TANGO Wizard has got the following commands");
   out.println("for the device <I>" + 
	device_name +
	"</I> from the device itself:");


   out.println("<P>");
   out.println("device <I>" + device_name + "</I> ");
   out.println("has <I>" + nb_commands + "</I> commands:<BR><BR>");

   out.println("<TABLE BORDER CELLPADDING=2 BGCOLOR=#CCFFFF>");

   out.println("<TR>");
   out.println("<TH ROWSPAN=2 COLSPAN=2>Command Name</TH>");
   out.println("<TH COLSPAN=3>Argin</TH>");
   out.println("<TH COLSPAN=2>Argout</TH>");
   out.println("</TR>");

   out.println("<TR>");
   out.println("<TH>type</TH>");
   out.println("<TH>description</TH>");
   out.println("<TH>value</TH>");
   out.println("<TH>type</TH>");
   out.println("<TH>description</TH>");
   out.println("</TR>");

   for (j=0; j<nb_commands; j++)
   {
    // Here start the table row
    out.println("<TR>");

    // FOR DEBUG THE CmdExec SERVLET WITH servletrunner:
    //out.println("<FORM METHOD=POST " +
    // 	"ACTION=\"http://amber1.esrf.fr:8080/servlet/CmdExec_old\">");

    // FOR NO DEBUG:
    out.println("<FORM METHOD=POST " +
    	"ACTION=\"/servlet/CmdExec_old\">");


    // Here are hidden informations passed to CmdExec servlet
    out.println("<INPUT TYPE=HIDDEN NAME=host VALUE=\"" +
        client_addr +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=cmd VALUE=\"" +
	commands[j].cmd_name +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=device VALUE=\"" +
	device_name +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=cmd_in VALUE=\"" +
	commands[j].in_type +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=cmd_in_desc VALUE=\"" +
	commands[j].in_type_desc +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=cmd_out VALUE=\"" +
	commands[j].out_type +
	"\">");
    out.println("<INPUT TYPE=HIDDEN NAME=cmd_out_desc VALUE=\"" +
	commands[j].out_type_desc +
	"\">");


    // Here start the table row filling
    out.println("<TD>");
    out.println("<INPUT TYPE=SUBMIT " +
	"VALUE=\"Execute\" " +
	"STYLE=\"background-color: #FF9000\">");
    out.println("</TD>");

    out.println("<TD><I>" + commands[j].cmd_name      + "</I></TD>");

    out.println("<TD><I>" + 
	Tango_CmdArgTypeName[commands[j].in_type] + 
	"</I></TD>");
    if(commands[j].in_type != 0)
    {
     out.println("<TD><I>" + commands[j].in_type_desc  + "</I></TD>");
     out.println("<TD><INPUT TYPE=TEXT NAME=argin SIZE=10></TD>");
    }
    else
     out.println("<TD COLSPAN=2>&nbsp;</TD>");


    out.println("<TD><I>" + 
	Tango_CmdArgTypeName[commands[j].out_type] + 
	"</I></TD>");
    if(commands[j].out_type != 0)
     out.println("<TD><I>" + commands[j].out_type_desc + "</I></TD>");
    else
     out.println("<TD>&nbsp;</TD>");


    out.println("</FORM>");
    out.println("</TR>");
   }
   out.println("</TABLE>");



   out.println(
	"<FORM METHOD=GET " +
	"ACTION=\"/servlet/CmdHistDispatch_old\" " +
	"TARGET=\"cmd_hist_" +
	device_name +
	"\">");
   out.println("<INPUT TYPE=HIDDEN NAME=device VALUE=\"" +
	device_name +
	"\">");
   out.println("<INPUT TYPE=SUBMIT " +
	"VALUE=\"Display commands history\" " +
	"STYLE=\"background-color: #FF9000\">");
   out.println("</FORM>");


   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   System.out.println("init(): ORB failed !");
//   ex.printStackTrace();

   // Messages available on a separate HTML page
   Vector message = new Vector();

   message.addElement("The device <I>" + device_name + "</I> failed.");
   message.addElement("ORB error, can not connect to device");

   HtmlHelper.error(out, "Get Device Command", message);
  }


  catch(DevFailed ex)
  {
   // Messages available only if the servlet is running with servletrunner
   System.out.println("doGet(): command_list_query() failed !");
   ex.printStackTrace();

   // Messages available on a separate HTML page
   Vector message = new Vector();

   message.addElement("The device <I>" + device_name + "</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);

   HtmlHelper.error(out, "Get Device Command", message);
  }
 }
}
