/*****************************************************************************
 *
 * Structure of the JDEVMENU web based application:
 *
 * -the client choose the device name from an HTML form.
 * 
 * -the "submit" button of the form with run on the web server the servlet
 *  called "CmdGet".
 * 
 * -as output "CmdGet" will send back to the client an HTML page containing:
 *	-the list of the device commands (name, argin and argout types and 
 *	 descriptions)
 *	-for each command a form wich submit will run on the web server
 *	 the servlet "CmdExec" calling its "doPost()" method.
 *	-a display command history form which submit will run on the web server
 *	 the servlet "CmdHistDispatch" calling its "doGet()" method.
 * 
 * -when the client request a command history (i.e. form submit calling 
 *  "CmdHistDispatch:doGet()" method):
 *	-the HTML page of the servlet will be sent back to the client
 * 	 in a separate window (cf target field of the form).
 *	-the name of this window will be "cmd_hist_" followed by the
 *	 device name.
 * 	-if a window with this name already exist, its contains will be
 *	 erased from the new output of "CmdHistDispatch" (i.e. command
 *	 history cleared) exactly as when the "Reload" button of the client
 *	 browser is depressed.
 * 	-if the window does not exist it's created by the client browser.
 *	-the HTML page sent back will contain an applet which code can
 *	 be found in "htdocs/CmdHistApplet.java"
 *	-the structure of this applet is:
 *		-display a textarea field and then get in a never ending
 *		 loop until the client browser window is closed.
 *		-the loop consist in calling "CmdExec:doGet()" method
 *		 passing the device name. The return of this method
 *		 is a new command result which applet add to the textarea.
 *		-As the client applet can not know when there is a
 *		 a result, "CmdExec:doGet()" is blocked by the servlet. 
 *		-Note: the "CmdExec:doGet()" may return on a timeout because
 *		 the server is not answering. This case is detected by
 *		 the applet which immediatly recall "CmdExec:doGet()".
 *		-the servlet "CmdExec" decides to return the pending
 *		 "doGet()" its "doPost()" method is called. This method
 *		 is called when the client request a command execution (see
 *		 afterward). Inside the servlet threads the communication 
 *		 between "doPost()" and "doGet()" is done with pairs of
 *		 "Observable/Observer"objets.
 *		-the "Observable" object is called "source", there is one
 *		 per client (i.e. command history applet) and they are
 *		 stored internally by the servlet in a vector.
 *		-the first time the applet calls "CmdExec:doGet()" the source
 *		 is created in the vector.
 *		-when the client browser window is closed the applet
 *		 will call "CmdExec:doGet()" passing the device name
 *		 but preceeded by the string "finished". "CmdExec" will 
 *		 like this know that it no more has to notify command
 *		 results to this client. It will remove the corresponding
 *		 "source" objet from its internal list and return 
 *		 immediately the "doGet()" to the client.
 *
 * -when the client request a command executtion (i.e form submit calling
 *  "CmdExec:doPost()" method):
 *	-the command parameters are retrieved from the HTML page.
 *	-the command is requested to the device.
 *	-the client corresponding "source" object (i.e. "Observable" part
 *	 of the "Obervable/Observer" pairs) is notified with the command result.
 *	-this notification will wake up the "sink" (i.e. "Observer" part of
 *	 the pair) and therefore return the "CmdExec:doGet()" method (see
 *	 above).
 *	-as the return of "CmdExec:doPost()" must be an HTML page because
 *	 the client browser is expecting one, the HTML page sent back
 *	 contains a JavaScript command to tell the browser to go back to
 *	 its previous HTML page (i.e. the page containing the device command
 *	 list), exactly as when the "Back" button of the client
 *	 browser is depressed.
 *
 */
import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.net.InetAddress;


/****************************************************************************
 *
 */
public class CmdGet extends HttpServlet 
			implements TangoConst
{
 DevHelper	device;
 PrintWriter	out;
 String		dbase_host = "amber1";
 String		dbase_port = "10000";


 boolean        verbose_level = true; // default verbose level


 /**********************************
  *
  */
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }


 /**********************************
  *
  */
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  String 	device_name = new String("");
  Tango.DevCmdInfo[] commands;
  int		nb_commands;
  int 		j;
  int 		i;


  //
  // Get the local machine name (send afterware to CmdExec servlet
  // for log purpose only).
  // NOTE: getRemoteHost() returns a null String!! Getting IP instead.
  //
  String client_addr = null;
  client_addr = req.getRemoteAddr();


  //
  // Log a minimum in log files
  //
  debug("doGet()  from: " + client_addr);



  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();



  // 
  // Get from HTML page user values given in the input forms
  //

  // The device parameter is mandatory
  // TODO: throw an error if not present
  device_name = req.getParameter("device");
  debug("device name: "+ device_name);

  dbase_host = req.getParameter("dbase_host");
  debug("host: " + dbase_host);
  dbase_port = req.getParameter("dbase_port");
  debug("port: " + dbase_port);



  //
  // Import the device wanted 
  //
  try
  {
   device = new DevHelper(device_name, dbase_host, dbase_port);
  }
  catch(Exception e)
  {
   Vector message = new Vector();

   message.addElement("Unable to import device <I>" + device_name + "</I>");
   message.addElement("Please check that the TANGO device server is running.");

   HtmlHelper.error(out, "Get Device Command", message);
   return;
  }




  //
  // Get the command list for the device
  //
  {
   // Get an array with the command list (including CORBA operations ping()
   // blackbox() etc) available for this device.
   commands = device.command_list_query();

   // Get the number of commands of this device
   nb_commands = commands.length;
  }
/*
  catch(DevFailed ex)
  {
   Vector message = new Vector();

   message.addElement("Unable to get command list from device <I>" + 
	device_name + "</I>");
   message.addElement("Please check that the TANGO device server is running.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);

   HtmlHelper.error(out, "Get Device Command", message);
   return;
  }
*/
   



  //
  // Generate servlet output (i.e. HTML page send back to httpd client)
  //
  HtmlHelper.head(out, "Get Device Command");

  out.println("<P>");
  out.println("The TANGO Wizard has got the following commands");
  out.println("for the device <I>" + 
	device_name +
	"</I> from the device itself:");


  out.println("<P>");
  out.println("device <I>" + device_name + "</I> ");
  out.println("has <I>" + nb_commands + "</I> commands:<BR><BR>");


  //
  // Applet call with its hidden parameter
  //
  out.println("<APPLET CODEBASE=/ CODE=\"CmdGetApplet.class\"" +
	"WIDTH=100% HEIGHT=430 " +
	"ARCHIVE=\"Tango.jar\">");

  out.println("<PARAM NAME=\"device\" VALUE=\"" +
	device_name +
	"\">");

  out.println("<PARAM NAME=\"dbase_host\" VALUE=\"" +
	dbase_host +
	"\">");

  out.println("<PARAM NAME=\"dbase_port\" VALUE=\"" +
	dbase_port +
	"\">");

  // Get a session id and give it to the applet for future identification
  // when talking to servlet CmdExec. The content has no meaning but
  // must be unique.
  String session_id = new java.rmi.server.UID().toString(); // guaranted unique
  out.println("<PARAM NAME=\"session_id\" VALUE=\"" +
	session_id +
	"\">");

  out.println("<PARAM NAME=\"nb_commands\" VALUE=\"" +
	nb_commands +
	"\">");

  for (j=0; j<nb_commands; j++)
  {
   String num = Integer.toString(j);

   out.println("<PARAM TYPE=HIDDEN NAME=\"cmd" +
	num +
	"\" VALUE=\"" +
	commands[j].cmd_name +
	"\">");

   out.println("<PARAM TYPE=HIDDEN NAME=\"cmd_in" +
	num +
	"\" VALUE=\"" +
	commands[j].in_type +
	"\">");

   out.println("<PARAM TYPE=HIDDEN NAME=\"cmd_in_desc" +
	num +
	"\" VALUE=\"" +
	commands[j].in_type_desc +
	"\">");

   out.println("<PARAM TYPE=HIDDEN NAME=\"cmd_out" +
	num +
	"\" VALUE=\"" +
	commands[j].out_type +
	"\">");

   out.println("<PARAM TYPE=HIDDEN NAME=\"cmd_out_desc" +
	num +
	"\" VALUE=\"" +
	commands[j].out_type_desc +
	"\">");

  }
  out.println("</APPLET>");


  HtmlHelper.bottom(out);
 }


 /**********************************
  *
  */
 private void debug(String message)
 {
  if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log(
        "CmdGet: " + message);
  }
 }


}
