/****************************************************************************
 *
 * Refers to servlets/CmdGet.java for explanations on this servlet.
 *
 */

import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;

// Needed for command result history
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Observable;
import java.lang.Object;




/****************************************************************************
 *
 */ 
public class CmdExec_old extends HttpServlet 
			implements TangoConst
{

 static ORB 	orb;
 Device 	dbase;
 PrintWriter 	out;

 Vector		clients = new Vector();




 /**
  *
  */ 
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
  try
  {
   Properties props = System.getProperties();
   props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
   props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
   System.setProperties(props);
   String[] args = new String[1];
   args[0] = new String("nada");
//   orb = ORB.init(this, new java.util.Properties());
   orb = ORB.init(args, props);
   org.omg.CORBA.Object obj = ((com.ooc.CORBA.ORB)orb).string_to_object("iiop://tango:10000/database");
   dbase = Tango.DeviceHelper.narrow(obj);
  }
  catch(SystemException ex)
  {
   debug("init(): ORB failed !");
   ex.printStackTrace();
  }
  

 }




 /**
  *
  */ 
 public void doPost(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  String client_host = null;
  long t_before;
  long t_after; 

  debug("doPost()");

  // Need to be defined outside the try() to be known by the catch()
  String device_name = new String("");

  // Needed fot timestamping and ellapsed time measures
  Date date             = new Date();




  try
  {
   // 
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();




   // 
   // Get from HTML page user values given in the input forms
   //
   client_host                  = req.getParameter("host");
   debug("client host name       : "+ client_host);
   device_name                  = req.getParameter("device");
   debug("device name            : "+ device_name);
   String command_name          = req.getParameter("cmd");
   int    command_in_type       = Integer.parseInt(req.getParameter("cmd_in"));
   String command_in_type_desc  = req.getParameter("cmd_in_desc");
   int    command_out_type      = Integer.parseInt(req.getParameter("cmd_out"));
   String command_out_type_desc = req.getParameter("cmd_out_desc");
   String argin_string          = req.getParameter("argin");
   String argout_string         = new String("");



   //
   // Log a minimum in log files
   //
   getServletContext().log("CmdExec_old: doPost() from: " + client_host);
   getServletContext().log("CmdExec_old: device       : " + device_name);
   getServletContext().log("CmdExec_old: command      : " + command_name);



   //
   // Import the device wanted 
   //
 
   // Get from TANGO database the informations needed to connect to the device
   Any send = orb.create_any();
   DevStringHelper.insert(send,device_name);
   Any received = dbase.command_inout(new String("DbImportDevice"),send);

   // Extract the IOR from informations
   DevVarLongStringArray db_received;
   db_received = DevVarLongStringArrayHelper.extract(received);

   // Check if the device is defined in the database but not exported
   if(db_received.lvalue[0] == 0)
   {
    Vector message = new Vector();

    message.addElement("Unable to import device <I>" + device_name + "</I>");
    message.addElement("The device is defined in the TANGO database " +
	"but not currently exported.");
    message.addElement("Please check that the TANGO device server is running.");

    HtmlHelper.error(out, "Execute Command", message);
   
    // End the servlet execution
    return;
   }

   // Import the TANGO device
   org.omg.CORBA.Object obj;
   obj = ((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
   Device device = Tango.DeviceHelper.narrow(obj);
  




   //
   // Execute the command on the device
   //

   // First convert the argin string to TANGO Any type according to command
   // specific argin type.
   Vector   argin_array = new Vector();
   if(HtmlHelper.string_to_any(
	argin_string, 
	send, 
	command_in_type, 
	argin_array) == -1)
   {
    // "string_to_any()" return error message in vector "argin_array"
    HtmlHelper.error(out, "Execute Command", argin_array);
   
    // End the servlet execution
    return;
   }


   // Execute the command
   if(command_name.equals("BlackBox"))
   {
    t_before = System.currentTimeMillis();
    String[] dummy = device.black_box(Integer.parseInt(argin_string));
    t_after  = System.currentTimeMillis();
 
    // Convert argout to string
    argout_string = "\n";
    for(int i=0; i<dummy.length; i++)
     argout_string += dummy[i] + "\n";
   }
   else if(command_name.equals("Info"))
   {
    t_before = System.currentTimeMillis();
    Tango.DevInfo dummy = device.info();
    t_after  = System.currentTimeMillis();
 
    // Convert argout to string
    argout_string = "\n";
    argout_string += "device class:   " + dummy.dev_class + "\n";
    argout_string += "server id:      " + dummy.server_id + "\n";
    argout_string += "server host:    " + dummy.server_host + "\n";
    argout_string += "server version: " + dummy.server_version + "\n";
    argout_string += "doc URL:        " + dummy.doc_url+ "\n";
   }
   else if(command_name.equals("Ping"))
   {
    try
    {
     t_before = System.currentTimeMillis();
     device.ping();
     t_after  = System.currentTimeMillis();
     argout_string = "Device ALIVE";
    }
    catch(DevFailed e)
    {
     argout_string = "Device NOT ALIVE";
     t_after = t_before = 0;
    }
   }
   else 
   {
    t_before = System.currentTimeMillis();
    received = device.command_inout(command_name, send);
    t_after  = System.currentTimeMillis();

    // Convert argout from TANGO Any type to string according to command
    // specific argout type.
    argout_string = HtmlHelper.any_to_string(received, command_out_type);
   }





   //
   // Generate servlet output (no HTML page send back to httpd client)
   //
   res.setStatus(HttpServletResponse.SC_NO_CONTENT);

   //
   // Get the source corresponding to the device displayed by the client
   // 
   CmdResultSource source    = null;
   Enumeration     enum      = clients.elements();
   boolean         not_found = true;
   debug("number of clients registered: " + 
	clients.size());
   while (enum.hasMoreElements())
   {
    source = (CmdResultSource)enum.nextElement();
    debug("looking at source.device_name: " + 
	source.device_name);
    if(source.device_name.equals(device_name))
    {
     debug("found source for: "+ device_name);
     not_found = false;


     //
     // Send command result  to listening clients (i.e. command history 
     // displayer applets)
     //
     SimpleDateFormat dateformat = 
	new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
     //dateformat.setTimeZone(TimeZone.getTimeZone("ECT"));
     dateformat.setTimeZone(TimeZone.getDefault());


     debug("source.sendResult()");

     String ret_client_string =
        dateformat.format(date) +
	"\n    " +
	"From host   : " + client_host +
	"\n    " +
	device_name + ": " + command_name +
	"\n    " +
	"Duration    : " + Long.toString(t_after-t_before) + " (ms)" +
	"\n    ";

     if(command_in_type != Tango_DEV_VOID)
     {

      String ret_dummy = new String("\n");
      for(int i=0; i < argin_array.size(); i++)
        ret_dummy += (String)argin_array.elementAt(i) + "\n";

      ret_client_string += "In  Argument(s): " + ret_dummy + "    ";
     }

     if(command_out_type != Tango_DEV_VOID)
      ret_client_string += "Out Argument(s): " + argout_string + "    ";

     source.sendResult(ret_client_string);

    }
   }
   if( not_found)
     debug("no source found for: "+ device_name);



  }
  catch(SystemException ex)
  {
   debug("init(): ORB failed !");
//   ex.printStackTrace();

   // Messages available on a separate HTML page
   Vector message = new Vector();

   message.addElement("The device <I>" + device_name + "</I> failed.");
   message.addElement(ex.getMessage());

   HtmlHelper.error(out, "Execute Command", message);

  }
  catch(DevFailed ex)
  {
   // Messages available only if the servlet is running with servletrunner
   debug("doGet(): command_list_query() failed !");
   ex.printStackTrace();

   // Messages available on a separate HTML page
   Vector message = new Vector();

   message.addElement("The device <I>" + device_name + "</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);

   HtmlHelper.error(out, "Execute Command", message);
  }
 }





 /**
  *
  */ 
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  String device_name = null;
  String client_host = null;

  debug("doGet()");
  getServletContext().log("CmdExec_old: doGet()");

  // 
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();



  //
  // Get arguements from client request.
  // In a way the device name is used to identify the client.
  //
  client_host                  = req.getParameter("host");
  debug("client host name       : "+ client_host);
  device_name                  = req.getParameter("device");
  debug("device name from client: "+ device_name);


  //
  // Log a minimum in log files
  //
  getServletContext().log("CmdExec_old: doGet()  from: " + client_host);
  getServletContext().log("CmdExec_old: device       : " + device_name);


  //
  // Check if the client is not telling us that is no more interresting
  // in receiving command results (posting from method stop() of an applet)
  //
  String applet_finished = new String("finished");
  boolean remove_client  = false;
  if(device_name.startsWith(applet_finished))
  {
   device_name = device_name.substring(applet_finished.length());
   debug("client no more interrested in device: " + device_name);
   remove_client = true;
  }


  //
  // Get the source corresponding to the device displayed by the client
  // 
  CmdResultSource source    = null;
  Enumeration     enum      = clients.elements();
  boolean         not_found = true;
  while (enum.hasMoreElements() && not_found)
  {
   source = (CmdResultSource)enum.nextElement();
   if(source.device_name.equals(device_name))
   {
    debug("found source for: " + device_name);
    getServletContext().log("CmdExec_old: found source ");
    if(source.client_host.equals(client_host))
    {
     debug("found source for: " + client_host);
     getServletContext().log("CmdExec_old: found source for client");
     not_found = false;
    }
    else
     debug("wrong client, cotinue searching");
   }
  }

 
  // 
  // If the client told us that he is no more interresting
  // in receiving command results then remove its corresponding source.
  //
  if(remove_client)
  {
   debug("removing source for: " + device_name);

   if(not_found)
    debug("oops not in the clients list !!");
   else
    clients.removeElement(source);

   return;
  }


  //
  // If no source is available, create a new one and add it to the list
  // 
  if(not_found)
  {
   debug("creating new source for: "+ device_name);
   getServletContext().log("CmdExec_old: creating new source");
   source = new CmdResultSource(client_host, device_name);
   clients.addElement(source);
  }


  //
  // Send to the client the next command result, getNextResult() is
  // blocking until a new result arrived.
  //
  out.println(getNextResult(source));

  debug("leaving doGet()");
  getServletContext().log("CmdExec_old: leaving doGet()");
 }
 


 /**
  *
  */ 
 public String getNextResult(CmdResultSource source)
 {
  return new CmdResultSink().getNextResult(source);
 }


 /**
  *
  */ 
 private void debug(String message)
 {
  // FOR DEBUG ONLY:
  System.out.println("CmdExec_old: " + message);
 }
}




/****************************************************************************
 *
 * This class acts as the source of command result Strings.
 * Clients interested in receiving these results can observe the
 * object instanciating this class.
 *
 */ 
class CmdResultSource extends Observable
{
 public String device_name = null;
 public String client_host = null;

 public CmdResultSource(String clt_host, String dev_name)
 {
  this.device_name = dev_name;
  this.client_host = clt_host;
 }

 public void sendResult(String result)
 {
  setChanged(); 		// update internal flag
  notifyObservers(result);	// notify that something has changed
 }
}




/****************************************************************************
 *
 * This class acts as a receiver of command result Strings from 
 * the source. It will block listening to the source until this
 * one notify it that the result is avaible.
 *
 */ 
class CmdResultSink implements Observer
{
 String result = null;


 /**
  * This method is called by the source when notifying that the
  * command results arrived.
  */ 
 synchronized public void update(Observable o, Object arg)
 {
  // Get the command result from the Observable object
  result = (String)arg;

  // Wake up our waiting thread
  notify();
 }


 /**
  * Blocking read of the next command result given by the source.
  */ 
 synchronized public String getNextResult(CmdResultSource src)
 {
  // Tell the source we want to be notify when the command result arrives
  src.addObserver(this);

  // Wait until our update() method receives a notification from source
  while(result == null)
   try { wait(); } catch(Exception ignored) { } 

  // Tell the source to stop telling us about new command results
  src.deleteObserver(this);

  // Before returning, clear result variable so that next call will wait
  // and not return immediately.
  String result_copy = result;
  result = null;

  // Return the command result
  return result_copy;
 }
}
