/****************************************************************************
 *
 * To use these classes, CLASSPATH include a path to this file location
 * (for instance, if this file is located in the same directory than
 *  the source file using these classes then CLASSPATH must contain "./"
 *
 */

import java.io.*;
import java.lang.*;
import java.util.Vector;
import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

/****************************************************************************
 *
 */
public final class HtmlHelper
	implements TangoConst
{


 /**
  *
  */
 public static void error(PrintWriter out, String my_title, Vector msg)
 {
  head(out, my_title);

  out.println("<P>");
  out.println("<H1>");
  out.println("<FONT COLOR=\"#FF0000\">Error</FONT>");
  out.println("</H1>");

  for(int i=0; i < msg.size(); i++)
  {
   out.println("<P>");
   out.println((String)msg.elementAt(i));
  }

  out.println("<P>");
  bottom(out);
 }





 /**
  *
  */
 public static void head(PrintWriter out, String my_title)
 {
  out.println("<HTML>");
  out.println("<HEAD>");
  out.println("<TITLE>");
  out.println("TANGO Wizard");
  out.println("</TITLE>");
  out.println("</HEAD>");

  out.println("<BODY text=\"#000000\" bgcolor=\"#FFFFFF\" link=\"#0000EF\">");
  out.println("<CENTER>");
  out.println("<H1>");
  out.println("<FONT COLOR=\"#3366FF\">");
  out.println(my_title);
  out.println("</H1>");
  out.println("</FONT>");
 }




 /**
  *
  */
 public static void bottom(PrintWriter out)
 {
  bottom(out, "perez@esrf.fr");
 }

 /**
  *
  */
 public static void bottom(PrintWriter out, String email_author)
 {
  out.println("<hr noshade width=\"100%\">");
  out.println("<table width=92% border=0>");
  out.println("<tr> <td width=50% align=left>");
  out.println("<A HREF=\"/Jive.html\"><font size=+3>JIVE home</font></a></td>");

  out.println("<td width=50% align=right>");
  out.println("<i><a href=\"mailto:" + 
	email_author + "\">" + 
	email_author + "</a>");
  out.println("<br>dynamically generated</i> </td> </tr> </table>");

  out.println("</CENTER>");
  out.println("</BODY>");
  out.println("</HTML>");
 }




   

 /**
  *
  * Extract from a string (typically coming from a string input field) the
  * specified type values and put them in a CORBA Any type. 
  *
  * The rules for decoding types from string (i.e. how the user must
  * enter the values in the string input field) are the same as the ones
  * of "xdevmenu" Unix application.
  *
  * Anyway they are explained here for each complicated type.
  *
  * The "argin_array" is the list of elements found after parsing the 
  * "argin_string". This is usefull for array types only as for other types
  * there is no parsing.
  *
  * Return:
  * 	 0 	On normal parsing and element type conversion.
  *	-1	If the type conversion of one element failed (this take
  *	   	place only for array types)
  *
  */
 public static int string_to_any(
	String 	argin_string, 
	Any	send, 
	int	command_in_type,
	Vector	argin_array)
 {
  

  // 
  // Test and treatements common to almost all commands
  //
  if(command_in_type != Tango_DEV_VOID)
  {

   // Ensure that the input string is not empty to avoid string
   // parsing funstions to fail. But allow the empty string input
   // for string type argin commands.
   if((command_in_type != Tango_DEV_STRING) && (argin_string.equals("")))
   {
    argin_array.removeAllElements();
    argin_array.addElement("Empty argument, you must specify a value");

    return -1;
   }

   // By default return as parsed argin string the argin string itself as
   // the parsed argin string is usefull only for array types.
   // Also remove useless white spaces.
   argin_array.addElement(argin_string.trim());
  }

  
  switch(command_in_type)
  {
   case Tango_DEV_VOID:
	break;
   case Tango_DEV_BOOLEAN:
   	DevBooleanHelper.insert(send, Boolean.getBoolean(argin_string));
	break;
   case Tango_DEV_USHORT:
	{
	 int tmp_int = check_ushort(argin_string, argin_array);
	 if(tmp_int == -1)
	  return -1;

   	 DevUShortHelper.insert(send, (short)(tmp_int));
	}
	break;
   case Tango_DEV_SHORT:
   	DevShortHelper.insert(send, parse_short(argin_string));
	break;
   case Tango_DEV_ULONG:
	{
   	 long tmp_long = check_ulong(argin_string, argin_array);
	 if(tmp_long == -1)
	  return -1;

         // Note: the insert() method expects a 32bits integer
   	 DevULongHelper.insert(send, (int)(tmp_long));
	}
	break;
   case Tango_DEV_LONG:
        // Note: Java int type is 32bits wide and is therefore mapped
 	//       to Tango_DevLong (Java long type is 64bits wide)
   	DevLongHelper.insert(send, parse_int(argin_string));
	break;
   case Tango_DEV_FLOAT:
   	DevFloatHelper.insert(send, Float.valueOf(argin_string).floatValue());
	break;
   case Tango_DEV_DOUBLE:
   	DevDoubleHelper.insert(send,Double.valueOf(argin_string).doubleValue());
	break;
   case Tango_DEV_STRING:
   	DevStringHelper.insert(send, argin_string);
	break;
   case Tango_DEVVAR_CHARARRAY:
	{
	/*
	 * A sequence of characters is expected as argin
	 */

	 argin_array.removeAllElements();
	 byte[] ret_dummy = argin_string.getBytes();
	 String bidon = new String();

	 for(int i=0; i < argin_string.length(); i++)
  	 {
	  if(ret_dummy[i] >= 32)
	   bidon = (new Character((char)ret_dummy[i]).toString());
	  else
	   bidon = " ";

 	  bidon += " = 0x" + Integer.toString(ret_dummy[i], 16);

	  argin_array.addElement(bidon);
	 }

   	 DevVarCharArrayHelper.insert(send, ret_dummy);
	}
	break;
   case Tango_DEVVAR_USHORTARRAY:
   case Tango_DEVVAR_SHORTARRAY:
	{
	/*
	 * A sequence of short is expected as argin, each short
	 * must be separated by a comma and zero or more white spaces.
	 */

	 Vector	  dummy = parse_string_1sep(argin_string, ",");

	 argin_array.removeAllElements();
	 short[] ret_dummy = new short[dummy.size()];
	 short bidon;

	 for(int i=0; i < dummy.size(); i++)
  	 {
	  try
	  {
	   if(command_in_type == Tango_DEVVAR_USHORTARRAY)
	   {
	    int tmp_int = check_ushort((String)dummy.elementAt(i), argin_array);
	    if(tmp_int == -1)
	     return -1;

	    bidon = (short)(tmp_int);
	    argin_array.addElement(short_to_ushort(bidon));
	   }
	   else
	   {
	    bidon = parse_short((String)dummy.elementAt(i));
	    argin_array.addElement(Short.toString(bidon));
	   }

	   ret_dummy[i] = bidon;
	  }
	  catch(java.lang.NumberFormatException ignored) 
	  { 
	   argin_array.removeAllElements();
	   argin_array.addElement(
		"Following element not of type short: ");
	   argin_array.addElement((String)dummy.elementAt(i));

 	   return -1;
	  }
 	 }

	 if(command_in_type == Tango_DEVVAR_USHORTARRAY)
   	  DevVarUShortArrayHelper.insert(send, ret_dummy);
	 else
   	  DevVarShortArrayHelper.insert(send, ret_dummy);
	}
	break;
   case Tango_DEVVAR_ULONGARRAY:
   case Tango_DEVVAR_LONGARRAY:
        // Note: Java int type is 32bits wide and is therefore mapped
 	//       to Tango_DevLong (Java long type is 64bits wide)
	{
	/*
	 * A sequence of ulong is expected as argin, each ulong
	 * must be separated by a comma and zero or more white spaces.
	 */

	 Vector	  dummy = parse_string_1sep(argin_string, ",");

	 argin_array.removeAllElements();
	 int[] ret_dummy = new int[dummy.size()];
	 int bidon;

	 for(int i=0; i < dummy.size(); i++)
  	 {
	  try
	  {
	   if(command_in_type == Tango_DEVVAR_ULONGARRAY)
	   {
	    long tmp_long = check_ulong((String)dummy.elementAt(i),argin_array);
	    if(tmp_long == -1)
	     return -1;

	    bidon = (int)(tmp_long);
	    argin_array.addElement(int_to_uint(bidon));
	   }
	   else
	   {
	    bidon = parse_int((String)dummy.elementAt(i));
	    argin_array.addElement(Integer.toString(bidon));
	   }

	   ret_dummy[i] = bidon;
	  }
	  catch(java.lang.NumberFormatException ignored) 
	  { 
	   argin_array.removeAllElements();
	   argin_array.addElement(
		"Following element not of type Java integer: ");
	   argin_array.addElement((String)dummy.elementAt(i));

 	   return -1;
	  }
 	 }

	 if(command_in_type == Tango_DEVVAR_ULONGARRAY)
   	  DevVarULongArrayHelper.insert(send, ret_dummy);
	 else
   	  DevVarLongArrayHelper.insert(send, ret_dummy);
	}
	break;
   case Tango_DEVVAR_FLOATARRAY:
	{
	/*
	 * A sequence of float is expected as argin, each float
	 * must be separated by a comma and zero or more white spaces.
	 */

	 Vector	  dummy = parse_string_1sep(argin_string, ",");

	 argin_array.removeAllElements();
	 float[] ret_dummy = new float[dummy.size()];
	 float bidon;

	 for(int i=0; i < dummy.size(); i++)
  	 {
	  try
	  {
	   bidon = Float.valueOf((String)dummy.elementAt(i)).floatValue();
	   ret_dummy[i] = bidon;
	   argin_array.addElement(Float.toString(bidon));
	  }
	  catch(java.lang.NumberFormatException ignored) 
	  { 
	   argin_array.removeAllElements();
	   argin_array.addElement(
		"Following element not of type float: ");
	   argin_array.addElement((String)dummy.elementAt(i));

 	   return -1;
	  }
 	 }

   	 DevVarFloatArrayHelper.insert(send, ret_dummy);
	}
	break;

   case Tango_DEVVAR_DOUBLEARRAY:
	{
	/*
	 * A sequence of double is expected as argin, each double
	 * must be separated by a comma and zero or more white spaces.
	 */

	 Vector	  dummy = parse_string_1sep(argin_string, ",");

	 argin_array.removeAllElements();
	 double[] ret_dummy = new double[dummy.size()];
	 double bidon;

	 for(int i=0; i < dummy.size(); i++)
  	 {
	  try
	  {
	   bidon = Double.valueOf((String)dummy.elementAt(i)).doubleValue();
	   ret_dummy[i] = bidon;
	   argin_array.addElement(Double.toString(bidon));
	  }
	  catch(java.lang.NumberFormatException ignored) 
	  { 
	   argin_array.removeAllElements();
	   argin_array.addElement(
		"Following element not of type double: ");
	   argin_array.addElement((String)dummy.elementAt(i));

 	   return -1;
	  }
 	 }

   	 DevVarDoubleArrayHelper.insert(send, ret_dummy);
	}
	break;

   case Tango_DEVVAR_STRINGARRAY:
	{
	/*
	 * A sequence of strings is expected as argin, each string
	 * must be inside double quotes, strings must be separated by
	 * zero or more characters (any character).
	 */

	 Vector	  dummy = parse_string(argin_string, "\"");

	 String[] ret_dummy = new String[dummy.size()];
	 argin_array.removeAllElements();
	 for(int i=0; i < dummy.size(); i++)
 	 {
	  ret_dummy[i] = (String)dummy.elementAt(i);
	  argin_array.addElement(dummy.elementAt(i));
	 }

   	 DevVarStringArrayHelper.insert(send, ret_dummy);
	}
	break;

   case Tango_DEVVAR_LONGSTRINGARRAY:
	{ 
	 argin_array.removeAllElements();
	 argin_array.addElement(
		"Type <I>DevVarLongStringArray</I> not supported as argin");
	 argin_array.addElement("in the current version, sorry");

	 return -1;
	}
	//break;

   case Tango_DEVVAR_DOUBLESTRINGARRAY:
	{ 
	 argin_array.removeAllElements();
	 argin_array.addElement(
		"Type <I>DevVarDoubleStringArray</I> not supported as argin");
	 argin_array.addElement("in the current version, sorry");

	 return -1;
	}
	//break;

   case Tango_DEV_STATE:
   	DevStateHelper.insert(	
		send, 
		DevState.from_int(Integer.parseInt(argin_string)));
	break;
   default:
	break;
  }

  // Normal end
  return 0;
 }



 /**
  *
  */
 private static String int_to_uint(int val)
 {
  long tmp_long = (long)(val);
  if(tmp_long < 0)
   tmp_long += 2 * ((long)(Integer.MAX_VALUE) + 1);
  String ret_string = Long.toString(tmp_long);
  return ret_string;
 }



 /**
  *
  */
 private static String short_to_ushort(short val)
 {
  int tmp_int = (int)(val);
  if(tmp_int < 0)
   tmp_int += 2 * (Short.MAX_VALUE + 1);
  String ret_string = Integer.toString(tmp_int);
  return ret_string;
 }




 /**
  *
  */
 private static short parse_short(String argin_string)
 {
  int conv_base;
  String str = argin_string.trim();

  if(str.startsWith("0x") || str.startsWith("0X")) 
  {
   conv_base = 16;
   str = str.substring(2);
  }
  else
   conv_base = 10;

  short tmp_short = Short.parseShort(str, conv_base);
  return tmp_short;
 }





 /**
  *
  */
 private static int parse_int(String argin_string)
 {
  int conv_base;
  String str = argin_string.trim();

  if(str.startsWith("0x") || str.startsWith("0X")) 
  {
   conv_base = 16;
   str = str.substring(2);
  }
  else
   conv_base = 10;

  int tmp_int = Integer.parseInt(str, conv_base);
  return tmp_int;
 }



 /**
  *
  */
 private static long parse_long(String argin_string)
 {
  int conv_base;
  String str = argin_string.trim();

  if(str.startsWith("0x") || str.startsWith("0X")) 
  {
   conv_base = 16;
   str = str.substring(2);
  }
  else
   conv_base = 10;

  long tmp_long = Long.parseLong(str, conv_base);
  return tmp_long;
 }



 /**
  *
  */
 private static int check_ushort(
	String argin_string, 
	Vector  argin_array)
 {
  int tmp_int = parse_int(argin_string);
  if((tmp_int > (Short.MAX_VALUE*2 + 1)) || (tmp_int < 0))
  {
   argin_array.removeAllElements();
   argin_array.addElement(
	"Value " + argin_string + 
	" out of range [0," + (Short.MAX_VALUE*2 + 1) + "]\n");

   return -1;
  }
  return tmp_int;
 }



 /**
  *
  */
 private static long check_ulong(
	String argin_string, 
	Vector  argin_array)
 {
  long tmp_long = parse_long(argin_string);
  if((tmp_long > ((long)(Integer.MAX_VALUE)*2 + 1)) || (tmp_long < 0))
  {
   argin_array.removeAllElements();
   argin_array.addElement(
	"Value " + argin_string + 
	" out of range [0," + ((long)(Integer.MAX_VALUE)*2 + 1) + "]\n");

   return -1;
  }
  return tmp_long;
 }




 /**
  *
  */
 public static String any_to_string(
	Any	received, 
	int	command_out_type)
 {
  String ret_string = new String("");

  switch(command_out_type)
  {
   case Tango_DEV_VOID:
	break;
   case Tango_DEV_BOOLEAN:
   	Boolean bidon = new Boolean(DevBooleanHelper.extract(received));
	ret_string = bidon.toString();
	break;
   case Tango_DEV_USHORT:
 	// Note: The extract() return a signed 16bits short therefore we need
	//       to do the cast from signed to unsigned by hand
   	ret_string = short_to_ushort(DevUShortHelper.extract(received));
	break;
   case Tango_DEV_SHORT:
        // Note: Java int type is 32bits wide and is therefore mapped
 	//       to Tango_DevLong (Java long type is 64bits wide)
   	ret_string = Integer.toString(DevShortHelper.extract(received));
	break;
   case Tango_DEV_ULONG:
 	// Note: The extract() return a signed 32bits int therefore we need
	//       to do the cast from signed to unsigned by hand
   	ret_string = int_to_uint(DevULongHelper.extract(received));
	break;
   case Tango_DEV_LONG:
   	ret_string = Integer.toString(DevLongHelper.extract(received));
	break;
   case Tango_DEV_FLOAT:
   	ret_string = Float.toString(DevFloatHelper.extract(received));
	break;
   case Tango_DEV_DOUBLE:
   	ret_string = Double.toString(DevDoubleHelper.extract(received));
	break;
   case Tango_DEV_STRING:
   	ret_string = DevStringHelper.extract(received);
	break;
   case Tango_DEVVAR_CHARARRAY:
	{
	 byte[] dummy = DevVarCharArrayHelper.extract(received);
 	 for(int i=0; i<dummy.length; i++)
	 {
	  if(dummy[i] >= 32)
	   ret_string += (new Character((char)dummy[i]).toString());
	  else
	   ret_string += " ";
	  ret_string += " = 0x" + Integer.toString(dummy[i], 16) + "\n";
	 }
	}
	break;
   case Tango_DEVVAR_USHORTARRAY:
 	// Note: The extract() return a signed 16bits short therefore we need
	//       to do the cast from signed to unsigned by hand
	{
	 short[] dummy = DevVarUShortArrayHelper.extract(received);

 	 for(int i=0; i<dummy.length; i++)
	  ret_string += short_to_ushort(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_SHORTARRAY:
	{
	 short[] dummy = DevVarShortArrayHelper.extract(received);
 	 for(int i=0; i<dummy.length; i++)
	  ret_string += Short.toString(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_ULONGARRAY:
	{
	 int[] dummy = DevVarULongArrayHelper.extract(received);

 	 for(int i=0; i<dummy.length; i++)
	  ret_string += int_to_uint(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_LONGARRAY:
	{
	 int[] dummy = DevVarLongArrayHelper.extract(received);
 	 for(int i=0; i<dummy.length; i++)
	  ret_string += Integer.toString(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_FLOATARRAY:
	{
	 float[] dummy = DevVarFloatArrayHelper.extract(received);
 	 for(int i=0; i<dummy.length; i++)
	  ret_string += Float.toString(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_DOUBLEARRAY:
	{
	 double[] dummy = DevVarDoubleArrayHelper.extract(received);
	 //ret_string = "\n";
 	 for(int i=0; i<dummy.length; i++)
	  ret_string += Double.toString(dummy[i]) + "\n";
	}
	break;
   case Tango_DEVVAR_STRINGARRAY:
	{
	 String[] dummy = DevVarStringArrayHelper.extract(received);
	 //ret_string = "\n";
 	 for(int i=0; i<dummy.length; i++)
	  ret_string += dummy[i] + "\n";
	}
	break;
   case Tango_DEVVAR_LONGSTRINGARRAY:
	{
	 DevVarLongStringArray dummy = 
		DevVarLongStringArrayHelper.extract(received);

	 ret_string += "lvalue:\n";
 	 for(int i=0; i<dummy.lvalue.length; i++)
	  ret_string += Integer.toString(dummy.lvalue[i]) + "\n";

	 ret_string += "svalue:\n";
 	 for(int i=0; i<dummy.svalue.length; i++)
	  ret_string += dummy.svalue[i] + "\n";
	}
	break;
   case Tango_DEVVAR_DOUBLESTRINGARRAY:
	{
	 DevVarDoubleStringArray dummy = 
		DevVarDoubleStringArrayHelper.extract(received);
	 //ret_string = "\n";

	 ret_string += "dvalue:\n";
 	 for(int i=0; i<dummy.dvalue.length; i++)
	  ret_string += Double.toString(dummy.dvalue[i]) + "\n";

	 ret_string += "svalue:\n";
 	 for(int i=0; i<dummy.svalue.length; i++)
	  ret_string += dummy.svalue[i] + "\n";
	}
	break;
   case Tango_DEV_STATE:
   	ret_string = Tango_DevStateName[
		DevStateHelper.extract(received).value()];
	break;
   default:
	break;
  }
  
  return ret_string;
 }



 /**
  *
  */
 private static Vector parse_string(
	String argin_string,
	String separator_string)
 {
  Vector  dummy = new Vector();
  int	  ind_beg = 0;
  int	  ind_end = 0;
  argin_string = argin_string.trim();
  while((ind_beg != -1) && (ind_end != -1))
  {
   ind_beg = argin_string.indexOf(separator_string, ind_beg);
   ind_end = argin_string.indexOf(separator_string, ind_beg + 1);
   if((ind_beg != -1) && (ind_end != -1))
   {
    dummy.addElement(argin_string.substring(ind_beg + 1, ind_end));
    ind_beg = ind_end + 1; 
   }
  }
 
  return dummy;
 }




 /**
  *
  */
 private static Vector parse_string_1sep(
	String argin_string,
	String separator_string)
 {
  Vector  dummy = new Vector();
  String  element_string = null;
  int	  ind_beg = 0;
  int	  ind_end = 0;

  argin_string = argin_string.trim();
  while((ind_beg != -1) && (ind_end != -1))
  {
   ind_end = argin_string.indexOf(separator_string, ind_beg);
   if(ind_end != -1)
   {
    element_string = argin_string.substring(ind_beg, ind_end).trim();
    if(element_string.length() != 0)
     dummy.addElement(element_string);
    ind_beg = ind_end + 1; 
   }
   else
   {
    element_string = argin_string.substring(ind_beg).trim();
    if(element_string.length() != 0)
     dummy.addElement(element_string);
   }
  }
 
  return dummy;
 }
 



 /**
  *
  */
 public static String argin_example(int command_in_type)
 {
  String ret_string = new String("Ex: ");

  
  switch(command_in_type)
  {
   case Tango_DEV_VOID:
	ret_string = new String("");
	break;
   case Tango_DEV_BOOLEAN:
 	ret_string += "true";
	break;
   case Tango_DEV_USHORT:
	ret_string += "10 or 0xa (unsigned 16bits)";
	break;
   case Tango_DEV_SHORT:
	ret_string += "10 or 0xa (signed 16bits)";
	break;
   case Tango_DEV_ULONG:
	ret_string += "10 or 0xa (unsigned 32bits)";
	break;
   case Tango_DEV_LONG:
	ret_string += "10 or 0xa (signed 32bits)";
	break;
   case Tango_DEV_FLOAT:
	ret_string += "2.3 (32bits float)";
	break;
   case Tango_DEV_DOUBLE:
	ret_string += "2.3 (64bits float)";
	break;
   case Tango_DEV_STRING:
	ret_string = "no quotes needed";
	break;
   case Tango_DEVVAR_CHARARRAY:
	ret_string += "abc (no quotes needed)";
	break;
   case Tango_DEVVAR_USHORTARRAY:
	ret_string += "2,0xa,4 (unsigned 16bits)";
	break;
   case Tango_DEVVAR_SHORTARRAY:
	ret_string += "2,0xa,4 (signed 16bits)";
	break;
   case Tango_DEVVAR_ULONGARRAY:
	ret_string += "2,0xa,4 (unsigned 32bits)";
	break;
   case Tango_DEVVAR_LONGARRAY:
	ret_string += "2,0xa,4 (signed 32bits)";
	break;
   case Tango_DEVVAR_FLOATARRAY:
	ret_string += "2.3,4 (32bits floats)";
	break;
   case Tango_DEVVAR_DOUBLEARRAY:
	ret_string += "2.3,4 (64bits floats)";
	break;
   case Tango_DEVVAR_STRINGARRAY:
	ret_string += "\"Dance\",\"TANGO\"";
	break;
   case Tango_DEVVAR_LONGSTRINGARRAY:
   case Tango_DEVVAR_DOUBLESTRINGARRAY:
	ret_string = "not supported";
	break;
   case Tango_DEV_STATE:
	ret_string += "0 (16bits value)";
	break;
   default:
   	ret_string = new String("");
	break;
  }


  return ret_string;
 }


}

