/*****************************************************************************
 *
 *
 */
import java.util.Properties;
import java.util.Vector;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Date;



import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

import org.omg.CORBA.*;

/*****************************************************************************
 *
 *
 */
public class DevHelper implements TangoConst
{
 static ORB 	orb;
 Device		dbase;
 Device		device;
 String		device_name;
 String		dbase_host;
 String		dbase_port;
 DevCmdInfo[] 	commands;
 String		client_host;


 public static final String CMD_RESULT_FINISHED = "finished";


 /**
  * Constructor importing the device using the specified name and 
  * the database specified by its host machine name and the listening port.
  */
 public DevHelper(
	String dev_name,
        String dbase_host,
        String dbase_port) throws 	
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  org.omg.CORBA.Object  obj;




  //
  // Connect to database
  //

  Properties props = System.getProperties();
  props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
  props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
  System.setProperties(props);
  String[] args = new String[1];
  args[0] = new String("nada");
  orb = ORB.init(args, props);
  String dbase_path = 
	"corbaloc:iiop:" + 
	dbase_host + ":" + 
	dbase_port + "/database";
  obj = ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
  dbase = fr.esrf.Tango.DeviceHelper.narrow(obj);


  //
  // Keep some global informations
  //

  // A record of device to deal with
  this.device_name = dev_name;
  this.dbase_host  = dbase_host;
  this.dbase_port  = dbase_port;
  
  // A record of the machine running on
  try
  {
   client_host = InetAddress.getLocalHost().getHostName();
  }
  catch(Exception ignored) {}
 

  //
  // Import the device wanted and get its command list
  //
  import_device();


 }



 /**
  * Import the TANGO Device Server and update variable member
  */
 private void import_device()
        throws 	
		DevHelperDevFailed        // import device failed
 {
  Any			send;
  org.omg.CORBA.Object  obj;
  int			nb_commands;
  int			i;
  int			j;



  // Get from TANGO database the informations needed to connect to the device
  Any received = null;
  try
  {
   send = orb.create_any();
   DevStringHelper.insert(send, device_name);
   received = dbase.command_inout(new String("DbImportDevice"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }



  // Extract the IOR from informations
  DevVarLongStringArray db_received;
  db_received = DevVarLongStringArrayHelper.extract(received);

  // Check if the device is defined in the database but not exported
  if(db_received.lvalue[0] == 0)
   throw(new DevHelperDevFailed(
	new String("device defined but not exported"), 
	new String("DevHelper")));

  // Import the TANGO device
  obj = ((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
  device = DeviceHelper.narrow(obj);


  //
  // Get the command list for the device (i.e. proceed the
  // command command_list_query() on the device itself)
  //
  DevCmdInfo[] dev_commands = null;
  try
  {
   dev_commands = device.command_list_query();
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  // Get the number of commands of this device
  nb_commands = dev_commands.length;

  //
  // Add CORBA operations available on all devices
  //
  commands = new DevCmdInfo[nb_commands + 3];

  // Add the CORBA commands
  i=0;
  commands[i] = new DevCmdInfo();
  commands[i].cmd_name      = "BlackBox";
  commands[i].in_type       = Tango_DEV_LONG;
  commands[i].in_type_desc  = "Nb commands";
  commands[i].out_type      = Tango_DEVVAR_STRINGARRAY;
  commands[i].out_type_desc = "Last commands";
  i++;
  commands[i] = new DevCmdInfo();
  commands[i].cmd_name      = "Info";
  commands[i].in_type       = Tango_DEV_VOID;
  commands[i].in_type_desc  = "";
  commands[i].out_type      = Tango_DEV_STRING;
  commands[i].out_type_desc = "Device infos";
  i++;
  commands[i] = new DevCmdInfo();
  commands[i].cmd_name      = "Ping";
  commands[i].in_type       = Tango_DEV_VOID;
  commands[i].in_type_desc  = "";
  commands[i].out_type      = Tango_DEV_STRING;
  commands[i].out_type_desc = "Device alive";
  i++;


  // Copy the device specific commands
  for (j=0; j<nb_commands; j++)
   commands[j+i] = dev_commands[j];

 }




 /**
  * Get the device command list
  */
 public DevCmdInfo[] command_list_query()
 {
  return commands;
 }


 /**
  * Get the device name
  */
 public String get_device_name()
 {
  return device_name;
 }




 /**
  * Execute a command on the device with the specified argin
  */
 public String exec_command(String command_name, String argin_string) throws
		DevHelperDevFailed,        // command execution on device failed
		NumberFormatException	// string to any convertion failed
 {
  Any		send;
  Any		received = null;
  int		index;
  String 	ret_client_string;

  long		t_before = 0;
  long		t_after  = 0;
  String	argout_string = new String("");

  boolean	comm_failure;
  boolean	transient_failure;
  int		nb_retry = 0;
  boolean	list_reimport = false;
  boolean	comm_reimport = false;




  // Found the command information
  for(
	index=0; 
	(index<commands.length) && 
	!command_name.equals(commands[index].cmd_name); 
	index++);

  // Try once to update the command list (perhaps the DS is under
  // design and its command list has changed)
  if(index >= commands.length)
  {
   import_device();
   list_reimport = true;

   // Found the command information
   // NOTE: need to repeat the following code instead of putting it
   // in a loop because the commands[] update was not correctly reported.
   for(
	index=0; 
	(index<commands.length) && 
	!command_name.equals(commands[index].cmd_name); 
	index++);

   // If the requested command doesn't exist in the list then inform the client
   if(index >= commands.length)
    throw(new DevHelperDevFailed(
	new String("unknown command for that device"), 
	new String("DevHelper")));
  }




  // First convert the argin string to TANGO Any type according to command
  // specific argin type.
  Vector   argin_array = new Vector();
  send = orb.create_any();
  if(HtmlHelper.string_to_any(
        argin_string,
        send,
        commands[index].in_type,
        argin_array) == -1)
  {
   String message = new String("");
   for(int i=0; i < argin_array.size(); i++)
    message += (String)argin_array.elementAt(i);

   throw new NumberFormatException(message);
  }



  //
  // Execute the command
  //
  COMM_FAILURE e_comm_failure = null;
  TRANSIENT e_transient = null;
  nb_retry = 0;
  do
  {
   comm_failure = false;
   transient_failure = false;

  
   if(command_name.equals("BlackBox"))
   {
    try
    {
     String[] dummy = null;
     t_before = System.currentTimeMillis();
     dummy = device.black_box(Integer.parseInt(argin_string));
     t_after  = System.currentTimeMillis();
 
     // Convert argout to string
     for(int i=0; i<dummy.length; i++)
      argout_string += dummy[i] + "\n";
    }
    catch(TRANSIENT e)
    {
     transient_failure = true;
     e_transient = e;
    }
    catch(COMM_FAILURE e)
    {
     comm_failure = true;
     e_comm_failure = e;
    }
    catch(DevFailed e)
    {
     throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
    }
   }
   else if(command_name.equals("Info"))
   {
    try
    {
     DevInfo dummy = null;

     t_before = System.currentTimeMillis();
     dummy = device.info();
     t_after  = System.currentTimeMillis();
 
     // Convert argout to string
     argout_string += "device class:   " + dummy.dev_class + "\n";
     argout_string += "server id:      " + dummy.server_id + "\n";
     argout_string += "server host:    " + dummy.server_host + "\n";
     argout_string += "server version: " + dummy.server_version + "\n";
     argout_string += "doc URL:        " + dummy.doc_url+ "\n";
    }
    catch(TRANSIENT e)
    {
     transient_failure = true;
     e_transient = e;
    }
    catch(COMM_FAILURE e)
    {
     comm_failure = true;
     e_comm_failure = e;
    }
    catch(DevFailed e)
    {
     throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
    }
   }
   else if(command_name.equals("Ping"))
   {
    try
    {
     t_before = System.currentTimeMillis();
     device.ping();
     t_after  = System.currentTimeMillis();
     argout_string = "Device ALIVE";
    }
    catch(TRANSIENT e)
    {
     transient_failure = true;
     e_transient = e;
    }
    catch(COMM_FAILURE e)
    {
     comm_failure = true;
     e_comm_failure = e;
    }
    catch(DevFailed e)
    {
     argout_string = "Device NOT ALIVE";
     t_after = t_before = 0;
    }
   }
   else
   {
    try
    {
     t_before = System.currentTimeMillis();
     received = device.command_inout(command_name, send);
     t_after  = System.currentTimeMillis();

     // Convert argout from TANGO Any type to string according to command
     // specific argout type.
     argout_string =
	HtmlHelper.any_to_string(received, commands[index].out_type);
    }
    catch(TRANSIENT e)
    {
     transient_failure = true;
     e_transient = e;
    }
    catch(COMM_FAILURE e)
    {
     comm_failure = true;
     e_comm_failure = e;
    }
    catch(DevFailed e)
    {
     throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
    }
   }


   // Try to reconnect to the device the first this one doesn't answer,
   // if it's not there two times then it's probably definitevely dead.
   if((nb_retry == 0) && (comm_failure || transient_failure))
   {
    import_device();
    comm_reimport = true;
   }

   nb_retry++;
  }
  while((nb_retry<2) && (comm_failure || transient_failure));

  // If the device is dead then inform the client
  if(comm_failure)
   throw(e_comm_failure);
  if(transient_failure)
   throw(e_transient);




  //
  // Prepare string to return (include extra informations to command argout)
  //

  // Prepare Java date convertion stuff
  Date date = new Date();
  SimpleDateFormat dateformat =
        new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
  //dateformat.setTimeZone(TimeZone.getTimeZone("ECT"));
  dateformat.setTimeZone(TimeZone.getDefault());

  // Notify a re-import of the device
  String reimport = "";
  if(list_reimport || comm_reimport)
   reimport="   WARNING: device re-imported";
 
  // Construct the string
  ret_client_string = 
        "\n###################################\n" +
        dateformat.format(date) + reimport + "\n" +
        "From host   : " + client_host + "\n" +
        device_name + ": " + command_name + "\n" +
        "Duration    : " + Long.toString(t_after-t_before) + " (ms)\n";
  
  // Prepare string to append
  if(commands[index].in_type != Tango_DEV_VOID)
  {
   String ret_dummy = new String();
   for(int i=0; i < argin_array.size(); i++)
      ret_dummy += (String)argin_array.elementAt(i) + "\n";

   ret_client_string += "In  Argument(s):\n" + ret_dummy;
  }

  if(commands[index].out_type != Tango_DEV_VOID)
   ret_client_string += "Out Argument(s):\n" + argout_string;



  return ret_client_string;
 }
}
