
import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbInfo extends HttpServlet 
{

 static ORB orb;
 Device dbase = null;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Database Info";
 static String servlet_name = "DbInfo";


 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }




 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();


  //
  // Get from HTML page user values given in the input forms
  //
  String dbase_host = req.getParameter("dbase_host");
  getServletContext().log("DbInfo: host: " + dbase_host);
  String dbase_port = req.getParameter("dbase_port");
  getServletContext().log("DbInfo: port: " + dbase_port);


  //
  // Check if a new database instance is requested
  //
  get_dbase(dbase_host, dbase_port);
  if(dbase == null)
   return;



  //
  // Execute the query on the database server
  //
  try
  {
   Any send = orb.create_any();
   Any received = dbase.command_inout(new String("DbInfo"),send);
   String[] db_info = DevVarStringArrayHelper.extract(received);
 
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);

   out.println("<P>");
   out.println("The latest online status of the TANGO database is :");
   out.println("<P>");
   out.println("<TABLE BORDER CELLPADDING=\"5\">");

   for (int i=0; i< db_info.length; i++)
   {
    out.println("<TR>");
    out.println("<TD><I>"+db_info[i]+"</I></TD>");
    out.println("</TR>");
   }
   out.println("</TABLE>");
   out.println("<P>");

   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbInfo failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbInfo</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = 
	"corbaloc:iiop:" + 
	dbase_host + ":" + 
	dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = fr.esrf.Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
