/*****************************************************************************
 *
 *
 */
import java.util.Properties;
import java.util.Vector;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Date;



import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

import org.omg.CORBA.*;

/*****************************************************************************
 *
 *
 */
public class DbHelper implements TangoConst
{
 static ORB 		orb;
 Device			dbase;
 Device			device;
 String			device_name;
 DevCmdInfo[] 	commands;
 String			client_host;


 public static final String CMD_RESULT_FINISHED = "finished";


 /**********************************
  * Constructor importing the database
  */
 public DbHelper(
	String dbase_host,
	String dbase_port) throws 	
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any			send;
  org.omg.CORBA.Object	obj;
  int			nb_commands;
  int			i;
  int			j;




  //
  // Connect to database
  //

  Properties props = System.getProperties();
  props.put("ORBClass","com.ooc.CORBA.ORB");
  props.put("ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
  System.setProperties(props);
  String[] args = new String[1];
  args[0] = new String("nada");
  orb = ORB.init(args, props);
  String dbase_path = 
	"corbaloc:iiop:" + 
	dbase_host + ":" + 
	dbase_port + "/database";
  obj = ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
  dbase = fr.esrf.Tango.DeviceHelper.narrow(obj);

  
  //
  // Ensure that the database is there
  // (indeed the narrow() not always physically access the device)
  //
  try
  {
   dbase.ping();
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }

 }



 /**********************************
  * Add a device to database
  */
 public void add_device(
	String server,
	String device,
	String device_class) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  String[] server_device = new String[3];
  server_device[0] = server;
  server_device[1] = device;
  server_device[2] = device_class;

  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send,server_device);

  Any received = null;

  try
  {
   received = dbase.command_inout(new String("DbAddDevice"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }

 }



 /**********************************
  * Get the list of domain names
  */
 public String[] get_domain(String domain_filter) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;
  
  Any send = orb.create_any();
  DevStringHelper.insert(send, domain_filter);
  try
  {
   received = dbase.command_inout(new String("DbGetDeviceDomainList"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }

  return DevVarStringArrayHelper.extract(received); 
 }




 /**********************************
  * Get the list of family names
  */
 public String[] get_family(
	String domain,
	String family_filter) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String family = domain + "/" + family_filter;
  Any send = orb.create_any();
  DevStringHelper.insert(send, family);
  try
  {
   received = dbase.command_inout(new String("DbGetDeviceFamilyList"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return DevVarStringArrayHelper.extract(received); 
 }




 /**********************************
  * Get the list of member names
  */
 public String[] get_member(
	String domain, 
	String family,
	String member_filter) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String member = domain + "/" + family + "/" + member_filter;
  Any send = orb.create_any();
  DevStringHelper.insert(send, member);
  try
  {
   received = dbase.command_inout(new String("DbGetDeviceMemberList"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return DevVarStringArrayHelper.extract(received); 
 }




 /**********************************
  * Get the list of property names
  */
 public String[] get_property(
	String domain, 	
	String family, 
	String member,
	String property_filter) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String device_name = domain + "/" + family + "/" + member;
  String[] dummy = new String[2];
  dummy[0] = device_name;
  dummy[1] = property_filter;

  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send, dummy);
  try
  {
   received =dbase.command_inout(new String("DbGetDevicePropertyList"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return DevVarStringArrayHelper.extract(received); 
 }



 /**********************************
  * Get the list of property values 
  */
 public String[] get_property_value(
	String domain, 	
	String family, 
	String member,
	String property) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String device_name = domain + "/" + family + "/" + member;
  String[] dummy = new String[2];
  dummy[0] = device_name;
  dummy[1] = property;
  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send, dummy);
  try
  {
   received =dbase.command_inout(new String("DbGetDeviceProperty"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  String[] ret_dummy = DevVarStringArrayHelper.extract(received); 

  // return format is:
  // device_name nb_properties property_name nb_properties value value
  int nb_properties = Integer.parseInt(ret_dummy[3]);
  String[] values = new String[nb_properties];
  for(int i=0;i < nb_properties;i++)
   values[i] = ret_dummy[i+4];
  
  return values;
 }



 /**********************************
  * Get the list of attribute names
  */
 public String[] get_attr(
	String domain, 	
	String family, 
	String member,
	String attr_filter) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String device_name = domain + "/" + family + "/" + member;
  String[] dummy = new String[2];
  dummy[0] = device_name;
  dummy[1] = attr_filter;

  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send, dummy);
  try
  {
   received =dbase.command_inout(
	new String("DbGetDeviceAttributeList"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return DevVarStringArrayHelper.extract(received); 
 }



 /**********************************
  * Get the list of attribute property names
  */
 public String[] get_attr_property(
	String domain, 	
	String family, 
	String member,
	String attr) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String device_name = domain + "/" + family + "/" + member;
  String[] dummy = new String[2];
  dummy[0] = device_name;
  dummy[1] = attr;

  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send, dummy);
  try
  {
   received =dbase.command_inout(
	new String("DbGetDeviceAttributeProperty"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }



  String[] ret_dummy = DevVarStringArrayHelper.extract(received); 

  // return format is:
  // device_name nb_attribute attribute nb_properties property_name 
  // property_value ... attribute nb_properties property_name property_value
  int nb_properties = Integer.parseInt(ret_dummy[3]);
  String[] values = new String[nb_properties];
  for(int i=0;i < nb_properties;i++)
   values[i] = ret_dummy[(i*2)+4];
  
  return values;
 }


 /**********************************
  * Get the list of attribute property values
  */
 public String[] get_attr_property_value(
	String domain, 	
	String family, 
	String member,
	String attr,
	String property) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String device_name = domain + "/" + family + "/" + member;
  String[] dummy = new String[2];
  dummy[0] = device_name;
  dummy[1] = attr;

  Any send = orb.create_any();
  DevVarStringArrayHelper.insert(send, dummy);
  try
  {
   received =dbase.command_inout(
	new String("DbGetDeviceAttributeProperty"),send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }



  String[] ret_dummy = DevVarStringArrayHelper.extract(received); 

  // return format is:
  // device_name nb_attribute attribute nb_properties property_name 
  // property_value ... attribute nb_properties property_name property_value
  int nb_properties = Integer.parseInt(ret_dummy[3]);

  String[] values = new String[1];
  boolean notfound = true;
  for(int i=0;(i < nb_properties) && notfound;i++)
  {
   if(ret_dummy[(i*2)+4].equals(property))
   {
     values[0] = ret_dummy[(i*2)+4+1];
     notfound = false;
   }
  }
  
  return values;
 }



 /**********************************
  * Remove from database values
  */
 public void delete_value(
	String domain, 	
	String family, 
	String member,
	String property,
	String attr,
	String attr_property) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String tango_cmd = null;
  String[] dummy_array = null;
  String dummy = null;
  String device_name = domain + "/" + family + "/" + member;


  //
  // Select the database delete command corresponding to the 
  // type of value to delete
  //
  if(attr_property != null)
  {
   dummy_array = new String[3];
   dummy_array[1] = attr;
   dummy_array[2] = attr_property;
   tango_cmd = new String("DbDeleteDeviceAttributeProperty");
  }
  else if(attr != null)
  {
   dummy_array = new String[2];
   dummy_array[1] = attr;
   tango_cmd = new String("DbDeleteDeviceAttribute");
  }
  else if(property != null)
  {
   dummy_array = new String[2];
   dummy_array[1] = property;
   tango_cmd = new String("DbDeleteDeviceProperty");
  }
  else if(member != null)
  {
   dummy = device_name;
   tango_cmd = new String("DbDeleteDevice");
  }


  //
  // Prepare database command argin
  //
  Any send = orb.create_any();
  if(dummy_array != null)
  {
   dummy_array[0] = device_name;
   DevVarStringArrayHelper.insert(send, dummy_array);
  }
  else
  {
   DevStringHelper.insert(send, dummy);
  }


  //
  // Execute command on database
  //
  try
  {
   received = dbase.command_inout(tango_cmd, send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return;
 }


 /**********************************
  * Create a new entry in the database
  * (without specifying the property value)
  */
 public void new_value(
	String domain, 	
	String family, 
	String member,
	String property,
	String attr,
	String attr_property) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  new_value(
	domain, 	
	family, 
	member,
	property,
	attr,
	attr_property,
	"new_value");
 }

 /**********************************
  * Create a new entry in the database
  * (specifying the property value)
  */
 public void new_value(
	String domain, 	
	String family, 
	String member,
	String property,
	String attr,
	String attr_property,
	String new_value) throws
		SystemException, // ORB failed connecting to database
		DevHelperDevFailed        // import device failed
 {
  Any received = null;

  String tango_cmd = null;
  String[] dummy_array = null;
  String dummy = null;
  String device_name = domain + "/" + family + "/" + member;


  //
  // Select the database put command corresponding to the 
  // type of value to create
  //
  if(attr_property != null)
  {
   // New attribute property
   dummy_array = new String[6];
   dummy_array[1] = "1";
   dummy_array[2] = attr;
   dummy_array[3] = "1";
   dummy_array[4] = attr_property;
   dummy_array[5] = new_value;
   tango_cmd = new String("DbPutDeviceAttributeProperty");
  }
  else if(attr != null)
  {
   // New attribute 
   dummy_array = new String[6];
   dummy_array[1] = "1";
   dummy_array[2] = attr;
   dummy_array[3] = "1";
   dummy_array[4] = "new_property";
   dummy_array[5] = new_value;
   tango_cmd = new String("DbPutDeviceAttributeProperty");
  }
  else if(property != null)
  {
   // New property
   dummy_array = new String[5];
   dummy_array[1] = "1";
   dummy_array[2] = property;
   dummy_array[3] = "1";
   dummy_array[4] = new_value;
   tango_cmd = new String("DbPutDeviceProperty");
  }


  //
  // Prepare database command argin
  //
  Any send = orb.create_any();
  dummy_array[0] = device_name;
  DevVarStringArrayHelper.insert(send, dummy_array);


  //
  // Execute command on database
  //
  try
  {
   received = dbase.command_inout(tango_cmd, send);
  }
  catch(DevFailed e)
  {
   throw(new DevHelperDevFailed(e.errors[0].reason, e.errors[0].origin));
  }


  return;
 }


}
