
import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbGetDeviceProperty extends HttpServlet 
{

 static ORB orb;
 Device dbase;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Get Device Properties";
 static String servlet_name = "DbGetDeviceProperty";

 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }


 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();

   //
   // Get from HTML page user values given in the input forms
   //
   String device     = req.getParameter("device");
   String dbase_host = req.getParameter("dbase_host");
   String dbase_port = req.getParameter("dbase_port");


   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;


   //
   // Get Device property names
   //
   Any received;
   Any send = null;
   String[] device_get = null;
   String[] property_names = null;

   try
   {
    send = orb.create_any();
    device_get = new String[2];
    device_get[0] = device;
    device_get[1] = "*";
    DevVarStringArrayHelper.insert(send,device_get);
    received = dbase.command_inout(new String("DbGetDevicePropertyList"),send);
    property_names = DevVarStringArrayHelper.extract(received);
   }
   catch(DevFailed ex)
   {
    getServletContext().log(servlet_name + 
	": DbGetDevicePropertyList failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();
    message.addElement("The command <I>DbGetDevicePropertyList</I> failed.");
    message.addElement(ex.errors[0].reason);
    message.addElement(ex.errors[0].origin);
    HtmlHelper.error(out, title, message);
   }


   //
   // Get Device property values
   //
   String[] property_values = null;
   try
   {
    device_get = new String[property_names.length + 1];
    device_get[0] = device;
    for(int i=0;i<property_names.length;i++)
     device_get[i+1] = property_names[i];
    DevVarStringArrayHelper.insert(send,device_get);
    received = dbase.command_inout(new String("DbGetDeviceProperty"),send);
    property_values = DevVarStringArrayHelper.extract(received);
   }
   catch(DevFailed ex)
   {
    getServletContext().log(servlet_name + 
	": DbGetDeviceProperty failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();
    message.addElement("The command <I>DbGetDeviceProperty</I> failed.");
    message.addElement(ex.errors[0].reason);
    message.addElement(ex.errors[0].origin);
    HtmlHelper.error(out, title, message);
   }


   //
   // Generate servlet output (i.e. HTML page send back to httpd client)
   //
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);


   out.println("<P>");
   out.println("The device <I>"+ device + "</I> has the following ");
   out.println("properties stored in the database  :");
   out.println("<P>");

   out.println("<TABLE BORDER CELLPADDING=\"5\">");

   out.println("<TR>");
   out.println("<TH>Name</TH>");
   out.println("<TH>Value</TH>");
   out.println("</TR>");

   int nb_properties = Integer.parseInt(property_values[1]);
   int parse_idx=2;
   for (int i=0; i< nb_properties; i++)
   {
    out.println("<TR>");
    out.println("<TD><I>"+property_values[parse_idx++]+"</I></TD>");

    int nb_vals = Integer.parseInt(property_values[parse_idx++]);

    out.println("<TD><TABLE BORDER=0 CELLPADDING=\"0\">");
    for (int j=0; j< nb_vals; j++)
     out.println("<TR><TD><I>"+property_values[parse_idx++]+"</I></TD></TR>");
    out.println("</TABLE></TD>");

    out.println("</TR>");
   }
   out.println("</TABLE>");
   out.println("<P>");


   HtmlHelper.bottom(out);
  }
  catch(SystemException ex)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = 
	"corbaloc:iiop:" + 
	dbase_host + ":" + 
	dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = fr.esrf.Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
