/****************************************************************************
 *
 *
 */

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;

// Needed for command result history
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Observable;
import java.lang.Object;




/****************************************************************************
 *
 */ 
public class DbExec extends HttpServlet 
			implements TangoConst
{
 PrintWriter 	out;

 static Vector		devices = new Vector();

 boolean	verbose_level = true; // default verbose level



 /**********************************
  *
  */ 
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }



 /**********************************
  *
  */ 
 public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws 
		ServletException, 
		IOException
 {
  String client_host    = null;
  String client_cmd     = null;
  String dbase_host     = null;
  String dbase_port     = null;
  DbDevice dbase        = null;
  String[] ret_array    = null;
  String domain         = null;
  String family         = null;
  String member         = null;
  String property       = null;
  String value          = null;
  String attr           = null;
  String attr_property  = null;
  String attr_property_value  = null;
  String ret_client_string = new String("");


  debug("doPost()");



  // 
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();




  // 
  // Get from HTML page user values given in the input forms
  // (if the perameter is not present then a null is returned)
  //
  client_host   = req.getParameter("host");
  client_cmd    = req.getParameter("cmd");
  dbase_host    = req.getParameter("dbase_host");
  dbase_port    = req.getParameter("dbase_port");
  domain        = req.getParameter("domain");
  family        = req.getParameter("family");
  member        = req.getParameter("member");
  property      = req.getParameter("property");
  value         = req.getParameter("value");
  attr          = req.getParameter("attr");
  attr_property       = req.getParameter("attr_property");
  attr_property_value = req.getParameter("attr_property_value");



  //
  // Log a minimum in log files
  //
  debug("client name : " + client_host);
  debug("client cmd  : " + client_cmd);
  debug("dbase host  : " + dbase_host);
  debug("dbase port  : " + dbase_port);
  debug("domain      : " + domain);
  if(family != null)
   debug("family      : " + family);
  if(member != null)
   debug("member      : " + member);
  if(property != null)
   debug("property    : " + property);
  if(value != null)
   debug("value       : " + value);
  if(attr != null)
   debug("attr        : " + attr);
  if(attr_property != null)
   debug("attr_property: " + attr_property);
  if(attr_property_value != null)
   debug("attr_property_value: " + attr_property_value);



  //
  // Get a database instance 
  //
  try
  {
   dbase = get_dbase(dbase_host, dbase_port);
  }
  catch(SystemException e)
  {
   // TODO: what to do with errors messages
   debug("ORB failed connecting to database");
   return;
  }
  catch(DevHelperDevFailed e)
  {
   // TODO: what to do with errors messages
   debug("failed to import database");
   debug("reason: " + e.reason);
   debug("origin: " + e.origin);

   return;
  }



  //
  // Check if this is a database request
  //
  if(client_cmd.startsWith("get_database"))
  {
   try
   {
    if(family == null)
     ret_array = dbase.device.get_domain(domain);
    else if(member == null)
     ret_array = dbase.device.get_family(domain, family);
    else if(attr == null)
    {
     if(property == null)
      ret_array = dbase.device.get_member(domain, family, member);
     else if(value == null)
      ret_array =dbase.device.get_property(domain, family, member, property);
     else
      ret_array =dbase.device.get_property_value(domain,family,member,property);
    }
    else if(attr_property == null)
     ret_array = dbase.device.get_attr(domain, family, member, attr);
    else if(attr_property_value == null)
     ret_array = dbase.device.get_attr_property(domain, family, member, attr);
    else
     ret_array = dbase.device.get_attr_property_value(
 	domain, family, member, attr, attr_property);
   }
   catch(DevHelperDevFailed e)
   {
    debug("failed to get name list");
    debug("reason: " + e.reason);
    debug("origin: " + e.origin);
 
    // TODO: what to do with errors messages
    return;
   }
   catch(Exception e)
   {
    debug("Exception: " + e.getClass().getName());
    debug("   " + e.getMessage());
    // TODO: what to do with errors messages
    return;
   }
  }


  // 
  // Check if this is a delete request
  //
  if(client_cmd.startsWith("delete"))
  {
   try
   {
    dbase.device.delete_value(
        domain,
        family,
        member,
        property,
        attr,
        attr_property);
   }
   catch(DevHelperDevFailed e)
   {
    debug("failed to delete values");
    debug("reason: " + e.reason);
    debug("origin: " + e.origin);
 
    // TODO: what to do with errors messages
    return;
   }
   catch(Exception e)
   {
    debug("Exception: " + e.getClass().getName());
    debug("   " + e.getMessage());
    // TODO: what to do with errors messages
    return;
   }

   // Don't forget the empty return array expected
   ret_array = new String[0];
  }



  // 
  // Check if this is a new request
  //
  if(client_cmd.startsWith("new"))
  {
   try
   {
    if(value != null)
     dbase.device.new_value(
        domain,
        family,
        member,
        property,
        attr,
        attr_property,
	value);
    else
     dbase.device.new_value(
        domain,
        family,
        member,
        property,
        attr,
        attr_property);
   }
   catch(DevHelperDevFailed e)
   {
    debug("failed to add value");
    debug("reason: " + e.reason);
    debug("origin: " + e.origin);
 
    // TODO: what to do with errors messages
    return;
   }
   catch(Exception e)
   {
    debug("Exception: " + e.getClass().getName());
    debug("   " + e.getMessage());
    // TODO: what to do with errors messages
    return;
   }

   // Don't forget the empty return array expected
   ret_array = new String[0];
  }



  //
  // Generate servlet output (no HTML page send back to httpd client)
  //
  for(int i=0;i<ret_array.length;i++)
   ret_client_string += ret_array[i] + "\n";
  out.println(ret_client_string);   

 }







 /**********************************
  *
  */ 
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  String client_host = null;
  String device_name = null;

  debug("doGet()");

  // 
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();



  //
  // Get arguments from client request.
  // In a way the device name is used to identify the client.
  //
  client_host = req.getParameter("host");
  device_name = req.getParameter("device");


  //
  // Log a minimum in log files
  //
  debug("client name : " + client_host);
  debug("device      : " + device_name);


  // 
  // Check if this is not a administration request
  //
  if(device_name.startsWith("admin"))
  {
   // Check if there is a maintenance command from administrator
   if(client_host.startsWith("verbose"))
   {
    if(client_host.endsWith("true"))
    {
     // Log a minimum to show that the level has changed
     if(verbose_level == false)
     {
      verbose_level = true;
      debug("doGet()");
      debug("client name : " + client_host);
      debug("device      : " + device_name);
     }
     else
      verbose_level = true;
    }

    if(client_host.endsWith("false"))
     verbose_level = false;
   }

   // Generate HTML output page waited by the client browser
   admin_output_html();

   return;
  }
 

  //
  // Check if the client is not telling us that is no more interresting
  // in receiving command results (posting from method stop() of an applet)
  //
  String applet_finished = new String(DevHelper.CMD_RESULT_FINISHED);
  boolean remove_client  = false;
  if(device_name.startsWith(applet_finished))
  {
   device_name = device_name.substring(applet_finished.length());
   debug("client no more interrested");
   remove_client = true;
  }



 
  // 
  // If the client told us that he is no more interresting
  // in receiving command results then remove its corresponding source.
  //
  if(remove_client)
  {
   debug("removing source for: " + device_name);

  
   // One client less using this device
   try
   {
// TODO:
//    release_dbase(device_name);
   }
   catch(Exception e)
   {
    debug("Panic, not in the device list !!");
   }
   
   return;
  }




  debug("leaving doGet()");
 }
 






 /**********************************
  *
  */ 
 private DbDevice found_dbase(String dbase_host, String dbase_port) 
	throws DevFailed
 {
  DbDevice	dev_cnt = null;

  //
  // Check if this device has been already imported
  //
  boolean	not_found = true;
  Enumeration	enum = devices.elements();
  debug("nb dbase    : " + devices.size());
  while(enum.hasMoreElements() && not_found)
  {
   dev_cnt = (DbDevice)enum.nextElement();
   if(dbase_host.equalsIgnoreCase(dev_cnt.dbase_host) &&
      dbase_host.equalsIgnoreCase(dev_cnt.dbase_host))
    not_found = false;
  }


  //
  // If not already imported throw an exception
  //
  if(not_found)
    throw new DevFailed();

  return dev_cnt;
 }




 /**********************************
  *
  */ 
 private DbDevice get_dbase(String dbase_host, String dbase_port) 
	throws DevHelperDevFailed
 {
  DbDevice	dev_cnt = null;


  //
  // Check if this device has been already imported
  //
  boolean not_found = true;
  try
  {
   dev_cnt = found_dbase(dbase_host, dbase_port);
   not_found = false;
  }
  catch(Exception ignored) { }


  //
  // Import the device wanted if not alreay imported
  // else note that there is one client more using this device
  //
  if(not_found)
  {
   debug("importing   : " + dbase_host + ":" + dbase_port);

   // Import the device
   dev_cnt = new DbDevice(dbase_host, dbase_port);

   // Update the device list
   devices.addElement(dev_cnt);
  } 



  //
  // Mark that one more client is using this device
  //
  dev_cnt.use_counter++;


  return dev_cnt;
 }



 /**********************************
  *
  */ 
 private void release_dbase(String dbase_host, String dbase_port) 
	throws DevFailed
 {
  DbDevice	dev_cnt = null;


  //
  // Check if this device has been already imported
  //
  try
  {
   dev_cnt = found_dbase(dbase_host, dbase_port);
  }
  catch(Exception e) 
  { 
   throw new DevFailed();
  }


  //
  // Mark that one less client is using this device
  //
  dev_cnt.use_counter--;


  //
  // Remove the device from the list if no body is using it
  //
  if(dev_cnt.use_counter <= 0)
  {
   debug("releasing   : " + dbase_host + ":" + dbase_port);

   // Update the device list
   devices.removeElement(dev_cnt);
  } 

 }




 /**********************************
  *
  */ 
 private void admin_output_html()
 {
  // Generate HTML output page waited by the client browser
  Enumeration		enum;
  DbDevice		dev_cnt = null;
  SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
  dateformat.setTimeZone(TimeZone.getDefault());


  HtmlHelper.head(out, "JIVE - TANGO Web Control Center");

  out.println("<H1><FONT COLOR=#FF0000><BLINK>");
  out.println("Administration Page - Access Limited");
  out.println("</BLINK></FONT></H1>");

  out.println("<p>This page is not automatically updated.");
  out.println("Reload it to get refreshed information.<p>");

  out.println("<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 BGCOLOR=#CCFFFF>");

  
  out.println("<TR>");
  out.println("<TH>Number of devices imported</TH>");
  out.println("<TH>" + devices.size() + "</TH>");
  out.println("</TR>");

  if(devices.size() != 0)
  {
   out.println("<TR>");
   out.println("<TD>");
   out.println("<TABLE BORDER=1 CELLPADDING=2 ALIGN=CENTER>");
   out.println("<TR>");
   out.println("<TD ALIGN=CENTER>host</TD>");
   out.println("<TD ALIGN=CENTER>port</TD>");
   out.println("<TD ALIGN=CENTER>no of call</TD>");
   out.println("</TR>");
   enum    = devices.elements();
   while(enum.hasMoreElements())
   {
    dev_cnt = (DbDevice)enum.nextElement();

    out.println("<TR>");
    out.println("<TD ALIGN=CENTER>" + dev_cnt.dbase_host + "</TD>");
    out.println("<TD ALIGN=CENTER>" + dev_cnt.dbase_port + "</TD>");
    out.println("<TD ALIGN=CENTER>" + dev_cnt.use_counter + "</TD>");
    out.println("</TR>");
   }
   out.println("</TABLE>");
   out.println("</TD>");
   out.println("<TD>&nbsp;</TD>");
   out.println("</TR>");
  }

  out.println("<TR>");
  out.println("<TH><BR><BR></TH>");
  out.println("<TH>&nbsp;</TH>");
  out.println("</TR>");
 


  out.println("<TR>");
  out.println("<TH>  Verbose on file httpd/logs/jserv.log  </TH>");
  Boolean dummy = new Boolean(verbose_level);
  out.println("<TH>" + dummy.toString() + "</TH>");
  out.println("</TR>");
  

  out.println("<TR>");
  out.println("<TH>");
  out.println("<FORM METHOD=GET ACTION=/jive/servlet/DbExec>");
  out.println("<INPUT TYPE=HIDDEN NAME=device VALUE=\"admin\">");

  dummy = new Boolean(!verbose_level);
  out.println("<INPUT TYPE=HIDDEN NAME=host   VALUE=\"verbose" +
	dummy.toString() + "\">");

  String button_label = "Enable";
  if(verbose_level)
   button_label = "Disable"; 

  out.println("<INPUT TYPE=SUBMIT VALUE=\"" + button_label + "\" "+
	"STYLE=\"BACKGROUND-COLOR: #FF0000\">");
  out.println("</FORM>");
  out.println("</TH>");
  out.println("<TH>&nbsp;</TH>");
  out.println("</TR>");
 

  out.println("<TR>");
  out.println("<TD ALIGN=\"CENTER\">Last update: " +
        dateformat.format(new Date()) + "</TD>");
  out.println("<TD>&nbsp;</TD>");
  out.println("</TR>");



  out.println("</TABLE>");

  HtmlHelper.bottom(out);
 }



 /**********************************
  *
  */ 
 private void debug(String message)
 {
  if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log(
	"DbExec: " + message);
  }
 }



}





/****************************************************************************
 *
 */
class DbDevice
{
 public DbHelper device;
 public int      use_counter;
 String          dbase_host = null;
 String          dbase_port = null;

 /**********************************
 *
 */
 DbDevice(String host, String port) throws DevHelperDevFailed
 {
  device = new DbHelper(host, port);
  dbase_host = host;
  dbase_port = port;
  use_counter = 0;
 }
}

