
import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbAddDevice extends HttpServlet 
{

 static 	ORB orb;
 DbHelper 	dbase;
 String		host  = null;
 String		port  = null;
 PrintWriter	out = null;

 static String	title = "Add Device";
 static String	servlet_name = "DbAddDevice";



 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }

 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  try
  {
   //
   // Prepare servlet output (i.e. HTML page send back to httpd client)
   //
   res.setContentType("text/html");
   out = res.getWriter();


   //
   // Get from HTML page user values given in the input forms
   //
   String server_name = req.getParameter("server");
   String device_name = req.getParameter("device");
   String class_name  = req.getParameter("class");
   String dbase_host  = req.getParameter("dbase_host");
   String dbase_port  = req.getParameter("dbase_port");

   getServletContext().log(servlet_name + ": server " + server_name);
   getServletContext().log(servlet_name + ": device " + device_name);
   getServletContext().log(servlet_name + ": class  " + class_name);


   //
   // Check if a new database instance is requested
   //
   get_dbase(dbase_host, dbase_port);
   if(dbase == null)
    return;




   //
   // Add the device to the TANGO database
   //
   dbase.add_device(server_name, device_name, class_name);
 



   //
   // Prepare HTML page to return
   //
   res.setContentType("text/html");
   PrintWriter out = res.getWriter();

   HtmlHelper.head(out, "Database Web Control Center<br>" + title);

   out.println("<P>");
   out.println("The following device <B>" + device_name + "</B> ");
   out.println("of class <B>" + class_name + "</B> served by the ");
   out.println("device server <B>" + server_name + "</B>  has been ");
   out.println("successfully added to the TANGO database");
   out.println("<P>");

   HtmlHelper.bottom(out);
  }
  catch(SystemException e)
  {
   String error_label = servlet_name + ": ORB failed !";
   getServletContext().log(error_label);

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement(error_label);
   HtmlHelper.error(out, title, message);
  }
  catch(DevHelperDevFailed e)
  {
   getServletContext().log(servlet_name + ": DbAddDevice failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbAddDevice</I> failed.");
   message.addElement(e.reason);
   message.addElement(e.origin);
   HtmlHelper.error(out, title, message);
  }
 }




 private void get_dbase(
        String dbase_host,
        String dbase_port)
 {

  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);

   // Import the device
   try
   {
    dbase = new DbHelper(dbase_host, dbase_port);
   }
   catch(DevHelperDevFailed e)
   {
    getServletContext().log(servlet_name + ": Failed connecting to database !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);
    message.addElement("Exception: " + e.getClass().getName());
    message.addElement("reason: " + e.reason);
    message.addElement("origin: " + e.origin);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }
   catch(SystemException e)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
}
