/****************************************************************************
 *
 * Refers to servlets/CmdGet.java for explanations on this servlet.
 *
 */

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import javax.servlet.*;
import javax.servlet.http.*;

// Needed for command result history
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.Observable;
import java.lang.Object;




/****************************************************************************
 *
 */ 
public class CmdExec extends HttpServlet 
			implements TangoConst
{
 PrintWriter    out;
 static Vector  devices = new Vector();
 boolean        verbose_level = true; // default verbose level
 final long	WATCHDOG =  1800000;    // unit is milliseconds



 /**********************************
  *
  */ 
 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }



 /**********************************
  *
  */ 
 public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws 
		ServletException, 
		IOException
 {
  CmdDevice	dev_cnt;
  String device_name	= new String("");
  String client_host	= null;
  String ret_client_string;

  debug("doPost()");



  // 
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();




  // 
  // Get from HTML page user values given in the input forms
  //
  client_host                  = req.getParameter("host");
  device_name                  = req.getParameter("device");
  String dbase_host            = req.getParameter("dbase_host");
  String dbase_port            = req.getParameter("dbase_port");
  String command_name          = req.getParameter("cmd");
  int    command_in_type       = Integer.parseInt(req.getParameter("cmd_in"));
  String command_in_type_desc  = req.getParameter("cmd_in_desc");
  int    command_out_type      = Integer.parseInt(req.getParameter("cmd_out"));
  String command_out_type_desc = req.getParameter("cmd_out_desc");
  String argin_string          = req.getParameter("argin");
  String argout_string         = new String("");




  //
  // Log a minimum in log files
  //
  debug("client name : " + client_host);
  debug("device      : " + device_name);
  debug("on database : " + dbase_host + ":" + dbase_port);
  debug("command     : " + command_name);




  //
  // Get a device instance 
  // (import if not already imported)
  //
  try
  {
   dev_cnt = get_device(device_name, dbase_host, dbase_port);
  }
  catch(Exception e)
  {
   debug("Can not import device: " + device_name);

   ret_client_string = 
        "\n###################################\nERROR !!\n" +
	"Can not import device: " + device_name +"\n";

   out.println(ret_client_string);
   return;
  }



  //
  // Cleanup device list using watchdog
  //
  cleanup_device();



  //
  // Execute the command on the device
  //
  try
  {
   ret_client_string = dev_cnt.device.exec_command(command_name, argin_string);
  }
  catch(NumberFormatException e)
  {
   ret_client_string = 
        "\n###################################\nERROR !!\n" +
	"NumberFormatException:\n" +
	e.getMessage();
   out.println(ret_client_string);
   return;
  }
  catch(COMM_FAILURE e)
  {
   ret_client_string = 
        "\n###################################\nERROR !!\n" +
   	"CORBA COMM_FAILURE exception:\n" +
	e.getMessage();
   out.println(ret_client_string);
   return;
  }
  catch(SystemException e)
  {
   ret_client_string = 
        "\n###################################\nERROR !!\n" +
   	"CORBA SystemException:\n" +
        "name: " + e.getClass().getName() + "\n" +
        "minor: " + e.minor;
   out.println(ret_client_string);
   return;
  }
  catch(DevHelperDevFailed e)
  {
   ret_client_string = 
        "\n###################################\nERROR !!\n" +
	"failed executing command: " + command_name + "\n" +
        "reason: " + e.reason + "\n" +
        "origin: " + e.origin;

   out.println(ret_client_string);
   return;
  }
 


  //
  // Generate servlet output (no HTML page send back to httpd client)
  //
  out.println(ret_client_string);

 }








 /**********************************
  *
  */ 
 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  String device_name = null;
  String client_host = null;

  debug("doGet()");

  // 
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();



  //
  // Get arguments from client request.
  // In a way the device name is used to identify the client.
  //
  client_host = req.getParameter("host");
  device_name = req.getParameter("device");


  //
  // Log a minimum in log files
  //
  debug("client name : " + client_host);
  debug("device      : " + device_name);




  // 
  // Check if this is not a administration request
  //	-the request should have a device name called "admin"
  //	-if extra paramteres are needed they are passed in the client_host param
  //
  if(device_name.startsWith("admin"))
  {
   // Check if there is a maintenance command from administrator
   if(client_host.startsWith("verbose"))
   {
    if(client_host.endsWith("true"))
    {
     // Log a minimum to show that the level has changed
     if(verbose_level == false)
     {
      verbose_level = true;
      debug("doGet()");
      debug("client name : " + client_host);
      debug("device      : " + device_name);
     }
     else
      verbose_level = true;
    }

    if(client_host.endsWith("false"))
     verbose_level = false;
   }

   // Generate HTML output page waited by the client browser
   admin_output_html();

   return;
  }
 

  //
  // Check if the client is not telling us that is no more interresting
  // in receiving command results (posting from method stop() of an applet)
  // NOT USED IN THE CURRENT VERSION !!!!
  //
  String applet_finished = new String(DevHelper.CMD_RESULT_FINISHED);
  if(device_name.startsWith(applet_finished))
  {
   device_name = device_name.substring(applet_finished.length());
   // One client less using this device
   debug("decr use for: " + device_name);
   return;
  }



  //
  // Nothing send back to the client
  //

  debug("leaving doGet()");
 }
 




 /**********************************
  *
  */ 
 private CmdDevice found_device(
	String device_name,
        String dbase_host,
        String dbase_port) throws DevFailed
 {
  CmdDevice	dev_cnt = null;

  //
  // Check if this device has been already imported
  //
  boolean	not_found = true;
  Enumeration	enum = devices.elements();
  while(enum.hasMoreElements() && not_found)
  {
   dev_cnt = (CmdDevice)enum.nextElement();
   if(device_name.equalsIgnoreCase(dev_cnt.device.get_device_name()) &&
      dbase_host.equalsIgnoreCase(dev_cnt.dbase_host) &&
      dbase_port.equalsIgnoreCase(dev_cnt.dbase_port))
    not_found = false;
  }


  //
  // If not already imported throw an exception
  //
  if(not_found)
    throw new DevFailed();

  return dev_cnt;
 }




 /**********************************
  *
  */ 
 private CmdDevice get_device(
	String device_name,
	String dbase_host,
	String dbase_port) throws DevFailed
 {
  CmdDevice	dev_cnt = null;


  //
  // Check if this device has been already imported
  //
  boolean not_found = true;
  try
  {
   dev_cnt = found_device(device_name, dbase_host, dbase_port);
   not_found = false;
  }
  catch(Exception ignored) { }


  //
  // Import the device wanted if not alreay imported
  // else note that there is one client more using this device
  //
  if(not_found)
  {
   debug("importing   : " + device_name);
   debug("on database : " + dbase_host + ":" + dbase_port);

   // Import the device
   try
   {
    dev_cnt = new CmdDevice(
	device_name, 
	dbase_host,
	dbase_port,
	WATCHDOG);
   }
   catch(Exception e)
   {
    throw new DevFailed();
   }

   // Update the device list
   devices.addElement(dev_cnt);
   debug("new nb devs : " + devices.size());

  } 



  //
  // Reset the watchdog on this device
  //
  dev_cnt.reset_watchdog();


  return dev_cnt;
 }

 /**********************************
  *
  */ 
 private void cleanup_device()
 {
  CmdDevice	dev_cnt = null;
  Date		cur_date = new Date();
  boolean	removed = false;

  //
  // Parse all device list looking for a watchdog expired
  //
  int i = 0;
  while(i<devices.size())
  {
   dev_cnt = (CmdDevice)devices.elementAt(i);
   if(cur_date.after(dev_cnt.watchdog_date))
   {
    debug("removing    : " + dev_cnt.device.get_device_name());
    devices.removeElementAt(i);
    removed = true;
   }
   else
    i++;
  }

  if(removed)
   debug("new nb devs : " + devices.size());
 }





 /**********************************
  *
  */ 
 private void admin_output_html()
 {
  // Generate HTML output page waited by the client browser
  Enumeration		enum;
  CmdDevice		dev_cnt = null;
  SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
  dateformat.setTimeZone(TimeZone.getDefault());



  HtmlHelper.head(out, "JIVE - TANGO Web Control Center");

  out.println("<H1><FONT COLOR=#FF0000><BLINK>");
  out.println("Administration Page - Access Limited");
  out.println("</BLINK></FONT></H1>");

  out.println("<p>This page is not automatically updated.");
  out.println("Reload it to get refreshed information.<p>");

  out.println("<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 "+
	"BGCOLOR=#CCFFFF ALIGN=CENTER>");

  out.println("<TR>");
  out.println("<TH>Number of devices imported</TH>");
  out.println("<TH>" + devices.size() + "</TH>");
  out.println("</TR>");

  if(devices.size() != 0)
  {
   Date birth_date = new Date();

   out.println("<TR>");
   out.println("<TD>");
   out.println("<TABLE BORDER=1 CELLPADDING=2 ALIGN=CENTER>");
   enum    = devices.elements();
   while(enum.hasMoreElements())
   {
    dev_cnt = (CmdDevice)enum.nextElement();
    birth_date.setTime(dev_cnt.watchdog_date.getTime() - WATCHDOG);
    out.println("<TR>");
    out.println("<TD>" + dateformat.format(birth_date) + "</TD>");
    out.println("<TD>" + dev_cnt.dbase_host +":"+ dev_cnt.dbase_port +"</TD>");
    out.println("<TD>" + dev_cnt.device.get_device_name() + "</TD>");
    out.println("</TR>");
   }
   out.println("</TABLE>");
   out.println("</TD>");
   out.println("<TD>&nbsp;</TD>");
   out.println("</TR>");
  }

  out.println("<TR>");
  out.println("<TH><BR><BR></TH>");
  out.println("<TH>&nbsp;</TH>");
  out.println("</TR>");
 


  out.println("<TR>");
  out.println("<TH>  Verbose on file httpd/logs/jserv.log  </TH>");
  Boolean dummy = new Boolean(verbose_level);
  out.println("<TH>" + dummy.toString() + "</TH>");
  out.println("</TR>");
  

  out.println("<TR>");
  out.println("<TH>");
  out.println("<FORM METHOD=GET ACTION=/jive/servlet/CmdExec>");
  out.println("<INPUT TYPE=HIDDEN NAME=device VALUE=\"admin\">");

  dummy = new Boolean(!verbose_level);
  out.println("<INPUT TYPE=HIDDEN NAME=host   VALUE=\"verbose" +
	dummy.toString() + "\">");

  String button_label = "Enable";
  if(verbose_level)
   button_label = "Disable"; 

  out.println("<INPUT TYPE=SUBMIT VALUE=\"" + button_label + "\" "+
	"STYLE=\"BACKGROUND-COLOR: #FF0000\">");
  out.println("</FORM>");
  out.println("</TH>");
  out.println("<TH>&nbsp;</TH>");
  out.println("</TR>");
 

  out.println("<TR>");
  out.println("<TD ALIGN=\"CENTER\">Last update: " + 
	dateformat.format(new Date()) + "</TD>");
  out.println("<TD>&nbsp;</TD>");
  out.println("</TR>");

  out.println("</TABLE>");

  HtmlHelper.bottom(out);
 }



 /**********************************
  *
  */ 
 private void debug(String message)
 {
  if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log(
	"CmdExec: " + message);
  }
 }



}










/****************************************************************************
 *
 */
class CmdDevice
{
 public DevHelper	device;
 public Date 		watchdog_date = null;
 long			watchdog;

 String          	dbase_host = null;
 String          	dbase_port = null;

 /**********************************
 *
 */
 CmdDevice(
	String device_name, 
	String dbase_host,
	String dbase_port,
	long watchdog) throws DevHelperDevFailed
 {
  device = new DevHelper(device_name, dbase_host, dbase_port);
  watchdog_date   = new Date();
  this.watchdog   = watchdog;
  this.dbase_host = dbase_host;
  this.dbase_port = dbase_port;
 }


 /**********************************
 *
 */
 void reset_watchdog()
 {
  long watchdog_millis = (new Date()).getTime() + watchdog;
  watchdog_date.setTime(watchdog_millis);
 }
}

