
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class StartDS extends HttpServlet 
{

 static ORB orb;
 Device dbase = null;
 String	host  = null;
 String port  = null;
 String	remote_host = null;
 String	server = null;
 PrintWriter out = null;

 static String title = "Tango Adminitration Software";
 static String servlet_name = "StartDS";


 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }




 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();


  //
  // Get from HTML page user values given in the input forms
  //
	String dbase_host = req.getParameter("dbase_host");
	String dbase_port = req.getParameter("dbase_port");
	String remote_host = req.getParameter("remote_host");
	String server      = req.getParameter("server");
	debug("	dbase_host:	" + dbase_host);
	debug("	dbase_port:	" + dbase_port);
	debug(" server:	" + server);
	debug(" remote_host:	" + remote_host);


	// Check if a new database instance is requested
	//---------------------------------------------------
	get_dbase(dbase_host, dbase_port);
	if(dbase == null)
		return;


	make_html(remote_host, server);
	HtmlHelper.bottom(out, "verdier@esrf.fr");
 }
//-----------------------------------------------------------------
 private Device dev_import(String devname)
 {
  try
  {
	Any		send = null;
	send = orb.create_any();
	DevStringHelper.insert(send, devname);
	Any received = dbase.command_inout(new String("DbImportDevice"),send);

	// Extract the IOR from informations
	DevVarLongStringArray db_received;
	db_received = DevVarLongStringArrayHelper.extract(received);

	// Check if the device is defined in the database but not exported
	if(db_received.lvalue[0]==0)
		return null;

	// Import the TANGO device
	org.omg.CORBA.Object obj =
			((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
	Device device = Tango.DeviceHelper.narrow(obj);
	//debug("device.ping() for " + devname + "  - device: " + device);
	device.ping();
	debug("Ping("+devname+") OK");
	return device;
   }
  catch(Exception ex)
  {
   return null;
  }
 }
//-----------------------------------------------------------------
 private boolean start_ds(Device dev, String dsname)
 {
  try
  {
 	Any	send=null;
	send = orb.create_any();
	DevStringHelper.insert(send, dsname);
	Any	received = dev.command_inout(new String("DevStart"),send);

	return true;
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DevStart failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DevStart("+dsname+")</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
   return false;
  }
 }
//-----------------------------------------------------------------
 private void make_html(String rem_host, String server)
 {
	make_header();

	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<b>Starting " + server + " on " + rem_host + "</b>");

	String	adminDs = new String("tango/admin/"+rem_host);
	Device	dev = dev_import(adminDs);
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	out.println("<P>"); 
	if (dev==null)
	{
		out.println("<b>" + adminDs + " device import Failed." + "</b>");
		return;
	}
	out.println("<b>" + adminDs + " device imported." + "</b>");
	out.println("<P>"); 
	out.println("<P>");
	if (start_ds(dev, server)==true)
		out.println("<b>" + server + " has been started." + "</b>");
 }
//-----------------------------------------------------------------
 private void make_header()
 {
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);
   out.println("<P>"); 
   out.println("<P>");
   out.println("<b>Starting device server:</b>");
   out.println("<P>");
 }

//-----------------------------------------------------------------

 private void get_dbase(String dbase_host, String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
	//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
//-------------------------------------------------------
 private void debug(String message)
 {
  //if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log("CmdGet: " + message);
  }
 }
}
