import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;



public class DoGetServlet extends HttpServlet
{
	static ORB		orb;
	Device			dbase = null;
	String			dbase_host = null;
	String			dbase_port = null;
	String			command = null;
	PrintWriter		out;
	static String	servlet_name = "DoGetServlet";
	


	public void doGet(HttpServletRequest req, HttpServletResponse res)
				throws ServletException, IOException
	{
		res.setContentType("text/plain");
		dbase_host = req.getParameter("dbase_host");
		dbase_port = req.getParameter("dbase_port");
		command    = req.getParameter("command");
		debug("dbase_host: " + dbase_host);
		debug("dbase_port: " + dbase_port);
		debug("command:	" + command);

		out = res.getWriter();
		
		// Check if a new database instance is requested
		//---------------------------------------------------
		get_dbase(dbase_host, dbase_port);
			if(dbase == null)
		return;

	  try
	  {
		if (command.equals("DbGetHostList"))
		{
			String[]	host_list = get_host_list();
			if (host_list!=null)
				for (int i=0 ; i<host_list.length ; i++)
					out.println(host_list[i]);
		}
		else
		if (command.equals("DbGetHostServerList"))
		{
			String		hostname = req.getParameter("devargin");
			String[]	ds_list = get_host_ds(hostname);
			if (ds_list!=null)
				for (int i=0 ; i<ds_list.length ; i++)
					out.println(ds_list[i]);
		}
		else
		if (command.equals("DbGetDeviceClassList"))
		{
			String		dsname = req.getParameter("devargin");
			String[]	dev_list = get_dev_list(dsname);
			if (dev_list!=null)
			{
				int	nbdev = dev_list.length/4;	//	Modulo 4 in array
				for (int i=0 ; i<nbdev ; i++)
					out.println(dev_list[i*4+2]); // Modulo 4  +  Offset 2 in array
			}
		}
		if (command.equals("DevStatus"))
		{
			String	devname = req.getParameter("devname");
			Device	dev = dev_import(devname);
			if (dev==null)
			{
				out.println("Not Exported");
				return;
			}
			out.println(get_dev_status(dev));	
		}
	  }
	  catch(DevFailed e)
	  {
	  	out.println(e.toString());
	  	debug(e.toString());
	  }
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException
	{
		doGet(req, res);
	}



	//-----------------------------------------------------------------
	/**
	 *	Import a device from Tango Database.
	 */
	//-----------------------------------------------------------------
	private Device dev_import(String devname)
	{
	  try
	  {
		Any		send = null;
		send = orb.create_any();
		DevStringHelper.insert(send, devname);
		Any received = dbase.command_inout(new String("DbImportDevice"),send);

		// Extract the IOR from informations
		DevVarLongStringArray db_received;
		db_received = DevVarLongStringArrayHelper.extract(received);

		// Check if the device is defined in the database but not exported
		if(db_received.lvalue[0]==0)
			return null;

		// Import the TANGO device
		org.omg.CORBA.Object obj =
			((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
		Device device = Tango.DeviceHelper.narrow(obj);
		//debug("device.ping() for " + devname + "  - device: " + device);
		device.ping();
		return device;
	 }
 	 catch(Exception ex)
	 {
  		 return null;
	 }
	}
	//-----------------------------------------------------------------
	/**
	 *	Get host list from Tango Database.
	 */
	//-----------------------------------------------------------------
	private String[] get_host_list()
				throws ServletException, IOException, DevFailed
	{
		Any		send = null;
		send = orb.create_any();
		DevStringHelper.insert(send, "*");
		Any received = dbase.command_inout(new String("DbGetHostList"),send);
		return DevVarStringArrayHelper.extract(received);
	}
	//-----------------------------------------------------------------
	/**
	 *	Get the servers registred list for a host.
	 *
	 *	@param	hostname	Host name to get servers registred list.
	 */
	//-----------------------------------------------------------------
	private String[] get_host_ds(String hostname)
				throws ServletException, IOException, DevFailed
	{
		Any	send=null;
		send = orb.create_any();
		DevStringHelper.insert(send, hostname);
		Any	received = dbase.command_inout(new String("DbGetHostServerList"),send);

		return DevVarStringArrayHelper.extract(received);
	}
	//-----------------------------------------------------------------
	/**
	 *	Get the Devices registred list for a server.
	 *
	 *	@param	dsname	device server name to get device registred list.
	 */
	//-----------------------------------------------------------------
	private String[] get_dev_list(String dsname)
				throws ServletException, IOException, DevFailed
	{
		Any	send=null;
		send = orb.create_any();
		DevStringHelper.insert(send, dsname);
		Any	received = dbase.command_inout(new String("DbGetDeviceClassList"),send);

		return DevVarStringArrayHelper.extract(received);
	}
	//-----------------------------------------------------------------
	/**
	 *	Get the Device status.
	 *
	 *	@param	device	Device Object.
	 */
	//-----------------------------------------------------------------
	private String get_dev_status(Device device)
				throws ServletException, IOException, DevFailed
	{
		Any	send=null;
		send = orb.create_any();
		//DevStringHelper.insert(send, dsname);
		Any	received = device.command_inout(new String("DevStatus"),send);

		return DevStringHelper.extract(received);
	}
	//-----------------------------------------------------------------
	/**
	 *	Import the tango database.
	 *
	 *	@param dbase_host	Database host name.
	 *	@param dbase_port	Database port number.
	 */
	//-----------------------------------------------------------------
	private void get_dbase(String dbase_host, String dbase_port)
	{
 		if (dbase == null)
 		{

			getServletContext().log(servlet_name + ": importing " +
			dbase_host + ":" + dbase_port);
			try
			{
				Properties props = System.getProperties();
				props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
				props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
				System.setProperties(props);
				String[] args = new String[1];
				args[0] = new String("andy");
				
				//  orb = ORB.init(this, new java.util.Properties());
				orb = ORB.init(args, props);

				String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
				org.omg.CORBA.Object obj =
						((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
				dbase = Tango.DeviceHelper.narrow(obj);
			}
			catch(SystemException ex)
			{
				getServletContext().log(servlet_name + ": ORB failed !");

				// Messages available on a separate HTML page
				Vector message = new Vector();

				message.addElement("Unable to connect to database instance " +
				dbase_host + ":" + dbase_port);

				HtmlHelper.error(out, servlet_name, message);

				// Remove any previous correct imported database
				dbase       = null;
			}
		}
	}
	
	/**
	 *	Will be used to debug on an output file.
	 * tango:/usr/local/httpd/logs # tail -n24 -f jserv.log
	 */
	private void debug(String message)
	{
		getServletContext().log(servlet_name + ": " + message);
	}
}
