
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class DbGetHostList extends HttpServlet 
{

 static ORB orb;
 Device dbase = null;
 String	host  = null;
 String port  = null;
 PrintWriter out = null;

 static String title = "Database Get Host List";
 static String servlet_name = "DbGetHostList";


 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }




 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();


  //
  // Get from HTML page user values given in the input forms
  //
  String dbase_host = req.getParameter("dbase_host");
  getServletContext().log("DbGetHostList: host: " + dbase_host);
  String dbase_port = req.getParameter("dbase_port");
  getServletContext().log("DbGetHostList: port: " + dbase_port);


	// Check if a new database instance is requested
	//---------------------------------------------------
	get_dbase(dbase_host, dbase_port);
	if(dbase == null)
		return;


	// Execute the query on the database server
	//------------------------------------------------
	String[] host_list = get_host_list();
	if (host_list==null)
		return;

	TangoHost[] hosts = new TangoHost[host_list.length];
	for (int i=0; i<host_list.length; i++)
		hosts[i] = new TangoHost(host_list[i]);

	for (int i=0; i< host_list.length; i++)
	{
		//	Read servers on each host
		//--------------------------------------
		String[] ds_list = get_host_ds(host_list[i]);
		if (ds_list==null)
			return;
		for (int j=0 ; j<ds_list.length ; j++)
		{
			TangoServer ts = new TangoServer(ds_list[j]);
			String[]		dev_list = get_dev_list(ts.name);
			if (dev_list==null)
				return;
			//	Check devices for each server
			//-------------------------------------
			int	nbdev = dev_list.length/4;	//	Modulo 4 in array
			for (int k=0 ; k<nbdev ; k++)
			{
				int	idx = k*4 + 2; // Modulo 4  +  Offset 2 in array
				TangoDevice	dev = new TangoDevice(dev_list[idx]);
				if((dev.device=dev_import(dev.name))==null)
					dev.setState(false);
				else
					dev.setState(true);
				ts.addDevice(dev);
			}
			hosts[i].addServer(ts);
		}
	}
	
	make_html(hosts);
	HtmlHelper.bottom(out, "verdier@esrf.fr");
 }
//-----------------------------------------------------------------
 private Device dev_import(String devname)
 {
  try
  {
	Any		send = null;
	send = orb.create_any();
	DevStringHelper.insert(send, devname);
	Any received = dbase.command_inout(new String("DbImportDevice"),send);

	// Extract the IOR from informations
	DevVarLongStringArray db_received;
	db_received = DevVarLongStringArrayHelper.extract(received);

	// Check if the device is defined in the database but not exported
	if(db_received.lvalue[0]==0)
		return null;

	// Import the TANGO device
	org.omg.CORBA.Object obj =
			((com.ooc.CORBA.ORB)orb).string_to_object(db_received.svalue[1]);
	Device device = Tango.DeviceHelper.narrow(obj);
	//debug("device.ping() for " + devname + "  - device: " + device);
	device.ping();
	return device;
   }
  catch(Exception ex)
  {
   return null;
  }
 }
//-----------------------------------------------------------------
 private String[] get_host_list()
 {
  try
  {
	Any		send = null;
	send = orb.create_any();
	DevStringHelper.insert(send, "*");
	Any received = dbase.command_inout(new String("DbGetHostList"),send);
	return DevVarStringArrayHelper.extract(received);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbGetHostList failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbGetHostList</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
   return null;
  }
}
//-----------------------------------------------------------------
 private String[] get_host_ds(String hostname)
 {
  try
  {
 	Any	send=null;
	send = orb.create_any();
	DevStringHelper.insert(send, hostname);
	Any	received = dbase.command_inout(new String("DbGetHostServerList"),send);

	return DevVarStringArrayHelper.extract(received);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbGetHostServerList failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbGetHostServerList</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
   return null;
  }
 }
//-----------------------------------------------------------------
 private String[] get_dev_list(String dsname)
 {
  try
  {
 	Any	send=null;
	send = orb.create_any();
	DevStringHelper.insert(send, dsname);
	Any	received = dbase.command_inout(new String("DbGetDeviceClassList"),send);

	return DevVarStringArrayHelper.extract(received);
  }
  catch(DevFailed ex)
  {
   getServletContext().log(servlet_name + ": DbGetDeviceClassList failed !");

   // Messages available on a separate HTML page
   Vector message = new Vector();
   message.addElement("The command <I>DbGetDeviceClassList</I> failed.");
   message.addElement(ex.errors[0].reason);
   message.addElement(ex.errors[0].origin);
   HtmlHelper.error(out, title, message);
   return null;
  }
 }
//-----------------------------------------------------------------
 private void make_dev_form(String rem_host, String server,TangoDevice dev)
 {
    out.println("<Td>");
	out.println("<form");
 	if (dev.getState()==false)
	{
		if (dev.name.indexOf("tango/admin")>=0)
		{
			out.println("method=get action=\"/admin/servlet/StartAdmin\">");
			out.println("<Font Color=\"#ff0000\">");
			out.println("<input type=submit value=\""+dev.name+"\" >");
			out.println("<input type=hidden size=6 name=\"dbase_host\" value=\""+host+"\">");
			out.println("<input type=hidden size=6 name=\"dbase_port\" value=\""+port+"\">");
			out.println("<input type=hidden size=6 name=\"remote_host\" value=\""+rem_host+"\">");
			out.println("<input type=hidden size=6 name=\"server\" value=\""+server+"\">");
			out.println("</Font>");
		}
		else
		{
	
			out.println("method=get action=\"/admin/servlet/ConfirmStartDS\">");
			out.println("<Font Color=\"#ff0000\">");
			out.println("<input type=submit value=\""+dev.name+"\">");
			out.println("<input type=hidden size=6 name=\"dbase_host\" value=\""+host+"\">");
			out.println("<input type=hidden size=6 name=\"dbase_port\" value=\""+port+"\">");
			out.println("<input type=hidden size=6 name=\"remote_host\" value=\""+rem_host+"\">");
			out.println("<input type=hidden size=6 name=\"server\" value=\""+server+"\">");
			out.println("</Font>");
		}
	}
	else
	{
		out.println("method=get action=\"/jive/servlet/CmdGet\">");
		out.println("<input type=submit name=\"device\" value=\""+dev.name+"\">");
		out.println("<input type=hidden size=6 name=\"dbase_host\" value=\""+host+"\">");
		out.println("<input type=hidden size=6 name=\"dbase_port\" value=\""+port+"\">");
	}
	out.println("</form>");
    out.println("</Td>");
 }

//-----------------------------------------------------------------
 private void make_html(TangoHost[] hosts)
 {
	make_header();

	out.println("<Table Border=1>");
	out.println("<TR>");
	out.println("<TD><b><center>"+ "Host"    + "</center></b></TD>");
 	out.println("<TD><b><center>"+ "Servers / Devices" + "</center></b></TD>");
	out.println("</TR>");
	for (int i=0 ; i<hosts.length ; i++)
	{
		TangoHost	rhost = hosts[i];
		//	Display Host Name
		out.println("<TR>");
		out.println("<TD><b><center>"+ rhost.name + "</center></b></TD>");
		
		//	Display Servers name
		out.println("<TD>");
		out.println("<Table Border=0>");
		for (int j=0; j<rhost.servers.size() ; j++)
		{
			TangoServer	server = (TangoServer) rhost.servers.elementAt(j);
    		out.println("<Td> " + server.name + "</td>");
			
			//	Display Devices Name
			for (int k=0 ; k<server.devices.size() ; k++)
			{
				make_dev_form(rhost.name, server.name,
						(TangoDevice) server.devices.elementAt(k));
			}
		}
   		out.println("</Table>");
		out.println("</TD>");
		out.println("</TR>");
	}
	out.println("</Table");
 }
//-----------------------------------------------------------------
 private void make_header()
 {
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);
   out.println("<P>"); 
   out.println("<P>");
   out.println("<b>The Following Hosts are registred in the TANGO database:");
   out.println("<P>");
 }

//-----------------------------------------------------------------

 private void get_dbase(String dbase_host, String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
	//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
//-------------------------------------------------------
 private void debug(String message)
 {
  //if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log("CmdGet: " + message);
  }
 }
}
