
import org.omg.CORBA.*;
import Tango.*;
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ConfirmStartDS extends HttpServlet 
{

 static ORB orb;
 Device dbase = null;
 String	host  = null;
 String port  = null;
 String	remote_host = null;
 String	server = null;

 
 PrintWriter out = null;

 static String title = "Starting Device Server";
 static String servlet_name = "ConfirmStartDS";


 public void init(ServletConfig config) throws ServletException
 {
  super.init(config);
 }




 public void doGet(HttpServletRequest req, HttpServletResponse res)
  throws ServletException, IOException
 {
  //
  // Prepare servlet output (i.e. HTML page send back to httpd client)
  //
  res.setContentType("text/html");
  out = res.getWriter();


  //
  // Get from HTML page user values given in the input forms
  //
	String dbase_host  = req.getParameter("dbase_host");
	String dbase_port  = req.getParameter("dbase_port");
	String remote_host = req.getParameter("remote_host");
	String server      = req.getParameter("server");

	debug(" host: " + dbase_host);
	debug(" port: " + dbase_port);
	debug(" remote_host: " + remote_host);
	debug(" server: " + server);


	// Check if a new database instance is requested
	//---------------------------------------------------
	get_dbase(dbase_host, dbase_port);
	if(dbase == null)
		return;
	
	make_html(remote_host, server);
	HtmlHelper.bottom(out, "verdier@esrf.fr");
 }
//-----------------------------------------------------------------
 private void make_html(String rem_host, String server)
 {
	make_header(server);

	out.println("<P>"); 
	out.println("<P>");
	out.println("<P>"); 
	out.println("<P>");
	out.println("<P>"); 
	out.println("<P>");
	out.println("<P>"); 
	out.println("<P>");
	
	out.println("<Table Border=0>");
	out.println("<Tr>");
	out.println("<Td>");
	out.println("<h2>");
	out.println("You will Start "+ server + " device server on:" );
	out.println("</h2>");
	
	out.println("</Td><Td>");
	out.println("<Form method=get action=\"/admin/servlet/StartDS\">");
	out.println("<h2>");
	out.println("<input type=input size=6 name=\"remote_host\" value=\""+rem_host+"\">");
	out.println("<input type=submit value=\"  Start  \" >");
	out.println("<input type=hidden size=6 name=\"dbase_host\" value=\""+host+"\">");
	out.println("<input type=hidden size=6 name=\"dbase_port\" value=\""+port+"\">");
	out.println("<input type=hidden size=6 name=\"server\" value=\""+server+"\">");
	out.println("</h2>");
	out.println("</Td>");
	out.println("</Form>");
	out.println("<Tr>");
	out.println("</Table>");
 }
//-----------------------------------------------------------------
 private void make_header(String server)
 {
   HtmlHelper.head(out, "Database Web Control Center<br>" + title);
   out.println("<P>"); 
   out.println("<P>");
   out.println("<b>Starting the device Server : " + server);
   out.println("<P>");
 }

//-----------------------------------------------------------------

 private void get_dbase(String dbase_host, String dbase_port)
 {
  if(!dbase_host.equals(host) || !dbase_port.equals(port) || (dbase == null))
  {

   getServletContext().log(servlet_name + ": importing " +
        dbase_host + ":" + dbase_port);
   try
   {
    Properties props = System.getProperties();
    props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
    props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
    System.setProperties(props);
    String[] args = new String[1];
    args[0] = new String("andy");
	//  orb = ORB.init(this, new java.util.Properties());
    orb = ORB.init(args, props);

    String dbase_path = "iiop://" + dbase_host + ":" + dbase_port + "/database";
    org.omg.CORBA.Object obj =
        ((com.ooc.CORBA.ORB)orb).string_to_object(dbase_path);
    dbase = Tango.DeviceHelper.narrow(obj);
   }
   catch(SystemException ex)
   {
    getServletContext().log(servlet_name + ": ORB failed !");

    // Messages available on a separate HTML page
    Vector message = new Vector();

    message.addElement("Unable to connect to database instance " +
        dbase_host + ":" + dbase_port);

    HtmlHelper.error(out, title, message);

    // Remove any previous correct imported database
    dbase       = null;
   }

   port = dbase_port;
   host = dbase_host;
  }
 }
//-------------------------------------------------------
 private void debug(String message)
 {
  //if(verbose_level)
  {
   // Message will be readable only if using servletrunner
   //  System.out.println(

   // Message will be readable in APACHE log file jserv.log (if enabled
   // in APACHE jserv configuration files). Warning using log files
   // consume disk space !!
   getServletContext().log(servlet_name + ": " + message);
  }
 }
}
