/***************************************************************************** 
 *
 * Refers to servlets/DbGet.java for explanations on this applet.
 *
 * Note for compiling: this applet use O'Reilly class to simplify
 *      HTTP applet-server communication. To use this class, CLASSPATH
 *      must include a path to O'Reilly's file HttpMessage.class
 *      For instance, if this file is located in the same directory than
 *      the source file using this class then CLASSPATH must contain "./"
 *
 * Note the following files are also needed and therefore the previous
 *	note must be applied:
 *		Tango.jar
 *		DbHelper.class
 *
 * Note for DEBUG: the debug() messages can be seen in the
 *      Java console of the browser.  With Netscape 4.61:
 *      Communicator:Tools:Java Console
 *
 *
 */

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Properties;
import java.lang.Object;

//import Tango.*;
//import TangoDs.*;



/***************************************************************************** 
 *
 *
 */
public class DbGetApplet 
			extends 
				Applet 
			implements 
				Runnable, 
				ActionListener, 
				ItemListener
{
 boolean		isAnApplet     = true;
 boolean		isShuttingDown = false;
 String			client_host  = null;

 // TANGO stuff
 DbHelper		dbase;
 static String		dbase_host = null;
 static String		dbase_port = null;
 static final String	SERVLET_NAME = "/jive/servlet/DbExec";

 // UI components
 TextField		field_host;
 TextField		field_port;
 Button			hostport_button;
 List 			list_domain;
 List 			list_family;
 List 			list_member;
 List 			list_property;
 List 			list_value;
 List 			list_attr;
 List 			list_attr_property;
 List 			list_attr_value;
 TextField		filter_domain;
 TextField		filter_family;
 TextField		filter_member;
 TextField		filter_property;
 TextField		filter_attr;
 String			filter_domain_text  = "*";
 String			filter_family_text  = "*";
 String			filter_member_text  = "*";
 String			filter_property_text= "*";
 String			filter_attr_text    = "*";
 TextField		edit_field;
 TextField		select_field;
 Button			new_button;
 Button			delete_button;
 Button			change_button;
 Button			duplicate_button;
 Button			exit_button;

 String select_domain              = null;
 String select_family              = null;
 String select_member              = null;
 String select_property            = null;
 String select_property_value      = null;
 String select_attr                = null;
 String select_attr_property       = null;
 String select_attr_property_value = null;


 // Constant definitions
 static final String	DBASE_HOST_DEF = "tango";
 static final String	DBASE_PORT_DEF = "10000";
 static final int	LIST_NB_LINES  = 7;
 static final String	HOSTPORT_BUTTON_CMD = "Change";
 static final String	NEW_BUTTON_CMD = "New";
 static final String	CHANGE_BUTTON_CMD = "Change";
 static final String	DELETE_BUTTON_CMD = "Delete";
 static final String	DUPLICATE_BUTTON_CMD = "Duplicate";
 static final String	EXIT_BUTTON_CMD = "Exit";
 static final String	FILTER_DOMAIN_CMD = "domain";
 static final String	FILTER_FAMILY_CMD = "family";
 static final String	FILTER_MEMBER_CMD = "member";
 static final String	FILTER_PROPERTY_CMD = "property";



 String			debug_url = "";
 static int		verbose_level;
 static final int	DBG_NONE   = 0;	// no verbose at all
 static final int	DBG_ERRORS = 1; // minimum verbose level
 static final int	DBG_TRACE  = 2;
 static final int	DBG_INFOS  = 3;
 static final int	DBG_MAX    = 4; // maximum verbose level



 /**********************************
  *
  */
 private static void print_usage()
 {
  System.out.println("Usage: java DbGetApplet [-v[" +
	DBG_NONE + "-" + DBG_MAX +"]] [-hhost] [-pport]");
  System.out.println("         " + DBG_NONE   + " : no debug message at all");
  System.out.println("         " + DBG_ERRORS + " : print out errors");
  System.out.println("         " + DBG_TRACE  + " : entering/leaving methods");
  System.out.println("         " + DBG_INFOS  + " : variables values");
  System.out.println("         " + DBG_MAX    + " : maximum verbose");
  System.out.println("         host : database host name ["+dbase_host+"]");
  System.out.println("         port : database port name ["+dbase_port+"]");
 }



 /**********************************
  * Called when running the applet not from an HTML page and a browser but
  * from local virtual machine as a standalone application.
  */
 public static void main(String args[])
 {
  Frame 		f = new Frame("JIVE - DbGetApplet");
  DbGetApplet		dbGetApplet = new DbGetApplet();
  int			verbose_level_def;
  int			verbose_level;


  // Set default database to work with
  dbase_host = DBASE_HOST_DEF;
  dbase_port = DBASE_PORT_DEF;


  // Print out usage on console
  if(args.length > 3)
  {
   print_usage();
   System.exit(-1);
  }
  if(args.length > 0)
   if(args[0].equals("-help"))
   {
    print_usage();
    System.exit(-1);
   }



  // Default verbose level
  verbose_level_def = DBG_NONE; 
  verbose_level = verbose_level_def;

  // Check command line arguments
  for(int i=0; i < args.length; i++)
  {
   String arg = args[i];

   // Get verbose level from arguments if any
   if((arg.startsWith("-v")) || (arg.startsWith("-V")))
    if(arg.length() > 2)
    {
     try 
     { 
      verbose_level = Integer.parseInt(arg.substring(2)); 
     }
     catch(NumberFormatException e) 
     { 
      System.out.println("Error: wrong verbose level, correct values [" +
	DBG_NONE + "-" + DBG_MAX +"]");
      verbose_level = DBG_MAX; // if -v is given without level assume maximum
     }
    }
    else // if -v is given without level assume maximum
     verbose_level = DBG_MAX;

   // Get database host name to work with
   if((arg.startsWith("-h")) || (arg.startsWith("-H")))
    dbase_host = arg.substring(2);

   // Get database port to work with
   if((arg.startsWith("-p")) || (arg.startsWith("-P")))
    dbase_port = arg.substring(2);
  }




  // Minimum check on verbose level entered
  if((verbose_level<DBG_NONE) || (verbose_level>DBG_MAX))  
  { 
   System.out.println("Error: wrong verbose level, correct values [" +
	DBG_NONE + "-" + DBG_MAX +"]");
   verbose_level = verbose_level_def;
  }

  // Keep the verbose level
  dbGetApplet.verbose_level = verbose_level;	
  System.out.println("DbGetApplet: verbose_level: " + verbose_level);


  // Minimum log
  debug(DBG_INFOS, "database host: " + dbase_host);
  debug(DBG_INFOS, "database port: " + dbase_port);


  // Mark that we are running as a standalone application
  dbGetApplet.isAnApplet  = false;


  // Emulate applet startup procedure
  dbGetApplet.init();


  // Place the applet UI on the window frame
  f.add(dbGetApplet);

  // Configure and display the application window
  f.setTitle("JIVE");
  f.setSize(560,670);	// should be the same than the APPLET tags WIDTH/HEIGHT
			// but not necessary (difference is window borders)
  //f.setResizable(false);
  f.show();
 }




 /**********************************
  * Called when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void init()
 {
  debug(DBG_TRACE, "Entering init()");



  //
  // Get the local machine name for command logs
  //
  try
  {
   client_host = InetAddress.getLocalHost().getHostName();
   debug(DBG_INFOS, "Hostname: " + client_host);
  }
  catch(Exception ignored) {}


  //
  // Initialisation
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 

   // Set a default verbose level for APPLET debug
   verbose_level = DBG_MAX;
   
   // Get parameters from HTML page
   dbase_host  = this.getParameter("dbase_host");
   dbase_port  = this.getParameter("dbase_port");
  }

  //
  // Get an instance of the database to work with
  //
  get_dbase_instance();


  //
  // Construct the user interface panel
  //

  // Prepare global resources for components
  Font  titleFont   = new Font("Times", Font.BOLD,  14);
  Font  headFont    = new Font("Times", Font.BOLD,  12);
  Font  normFont    = new Font("Times", Font.PLAIN, 12);
  Color buttonColor = new Color(0xff, 0x90, 0x00);
  Color titleColor  = new Color(0x33, 0x66, 0xff);
  Color backColor   = new Color(0xcc, 0xff, 0xff);


  // Entire applet background
  setBackground(backColor);

  // Default font used by all the components of the UI
  setFont(normFont);



  // Construct the UI itself placing components according to predefined layout
  Panel 		p1 = new Panel();
  GridBagLayout		p1_layout = new GridBagLayout();
  GridBagConstraints	p1_const  = new GridBagConstraints();
  p1.setLayout(p1_layout);
  p1_const.fill  = GridBagConstraints.BOTH;
  p1_const.weightx  = 1.0;	// component enlarge if window is enlarged
  p1_const.weighty  = 1.0;
  p1_const.insets= new Insets(0,5,0,5);

  Panel p2 = new Panel();
  Panel p3 = new Panel();





  // Row number: 0
  Label bidon;
  bidon = new Label("Selection of some device properties");
  bidon.setFont(titleFont);
  bidon.setForeground(titleColor);
  bidon.setAlignment(Label.CENTER);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default


  // Row number: 1
  // Composed with a subpanel
  Panel	p1b = new Panel();
  bidon = new Label("Working on TANGO instance host:");
  bidon.setFont(normFont);
  p1b.add(bidon);
  field_host = new TextField(dbase_host);
  p1b.add(field_host);
  bidon = new Label("port:");
  bidon.setFont(normFont);
  p1b.add(bidon);
  field_port = new TextField(dbase_port);
  p1b.add(field_port);
  hostport_button = new Button(HOSTPORT_BUTTON_CMD);
  hostport_button.setBackground(buttonColor);
  hostport_button.setFont(headFont);
  hostport_button.addActionListener(this);
  p1b.add(hostport_button);


  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(p1b, p1_const);
  p1.add(p1b);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 2
  bidon = new Label("Domain:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Family:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Member:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Attribute:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Property:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Value:");
  bidon.setFont(headFont);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default







  // Row number: 3

  // Add first list
//  list_domain = new List(LIST_NB_LINES); 
  list_domain = new List(); 
  update_domain_list("*");
  list_domain.addItemListener(this);
  p1_const.gridheight = 5;
  p1_layout.setConstraints(list_domain, p1_const);
  p1.add(list_domain);
  p1_const.gridheight = 1; // reset to default

  // Add second list
//  list_family = new List(LIST_NB_LINES); 
  list_family = new List(); 
  list_family.addItemListener(this);
  p1_const.gridheight = 5;
  p1_layout.setConstraints(list_family, p1_const);
  p1.add(list_family);
  p1_const.gridheight = 1; // reset to default

  // Add third list
//  list_member = new List(LIST_NB_LINES); 
  list_member = new List(); 
  list_member.addItemListener(this);
  p1_const.gridheight = 5;
  p1_layout.setConstraints(list_member, p1_const);
  p1.add(list_member);
  p1_const.gridheight = 1; // reset to default

  // Add first attribute list
  list_attr = new List(LIST_NB_LINES); 
  list_attr.addItemListener(this);
  p1_layout.setConstraints(list_attr, p1_const);
  p1.add(list_attr);

  // Add second attribute list
  list_attr_property = new List(LIST_NB_LINES); 
  list_attr_property.addItemListener(this);
  p1_layout.setConstraints(list_attr_property, p1_const);
  p1.add(list_attr_property);

  // Add third attribute list
  list_attr_value = new List(LIST_NB_LINES); 
  list_attr_value.addItemListener(this);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(list_attr_value, p1_const);
  p1.add(list_attr_value);
  p1_const.gridwidth = 1; // reset to default





  // Row number: 4

  // Add first attribute list label
  bidon = new Label("Filter:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default




  // Row number: 5

  // Add first attribute list filter
  filter_attr = new TextField(filter_attr_text);
  filter_attr.addActionListener(this);
  p1_layout.setConstraints(filter_attr, p1_const);
  p1.add(filter_attr);

  bidon = new Label("");
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default





  // Row number: 6

  bidon = new Label("Property:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("Value:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default




  // Row number: 7

  // Add first property list
  list_property = new List(LIST_NB_LINES); 
  list_property.addItemListener(this);
  p1_layout.setConstraints(list_property, p1_const);
  p1.add(list_property);

  // Add second property list
  list_value = new List(LIST_NB_LINES); 
  list_value.addItemListener(this);
  p1_layout.setConstraints(list_value, p1_const);
  p1.add(list_value);

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default






  // Row number: 8

  // Add first list filter label
  bidon = new Label("Filter:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  // Add second list filter label
  bidon = new Label("Filter:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  // Add third list filter label
  bidon = new Label("Filter:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  // Add fourth list filter label
  bidon = new Label("Filter:");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  // No filter label for fifth list but add empty field
  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 5

  // Add first list filter
  filter_domain = new TextField(filter_domain_text);
  filter_domain.addActionListener(this);
  p1_layout.setConstraints(filter_domain, p1_const);
  p1.add(filter_domain);

  // Add second list filter
  filter_family = new TextField(filter_family_text);
  filter_family.addActionListener(this);
  p1_layout.setConstraints(filter_family, p1_const);
  p1.add(filter_family);

  // Add third list filter
  filter_member = new TextField(filter_member_text);
  filter_member.addActionListener(this);
  p1_layout.setConstraints(filter_member, p1_const);
  p1.add(filter_member);

  // Add fourth list filter
  filter_property = new TextField(filter_property_text);
  filter_property.addActionListener(this);
  p1_layout.setConstraints(filter_property, p1_const);
  p1.add(filter_property);

  // No filter for fifth list but add empty field
  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 6

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 7

  bidon = new Label("Edition and creation of database values");
  bidon.setFont(titleFont);
  bidon.setForeground(titleColor);
  bidon.setAlignment(Label.CENTER);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 8

  bidon = new Label("Selection:");
  bidon.setFont(headFont);
  p1_const.gridwidth = 3;
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default

  bidon = new Label("Value:");
  bidon.setFont(headFont);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 9

  select_field = new TextField("");
  select_field.addActionListener(this);
  select_field.setEditable(false);
  p1_const.gridwidth = 3;
  p1_layout.setConstraints(select_field, p1_const);
  p1.add(select_field);
  p1_const.gridwidth = 1; // reset to default

  edit_field = new TextField("");
  edit_field.addActionListener(this);
  edit_field.setEditable(false);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(edit_field, p1_const);
  p1.add(edit_field);
  p1_const.gridwidth = 1; // reset to default




  // Row number: 10

  bidon = new Label("");
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  bidon = new Label("");
  p1_layout.setConstraints(bidon, p1_const);
  p1.add(bidon);

  new_button = new Button(NEW_BUTTON_CMD);
  new_button.setBackground(buttonColor);
  new_button.setFont(headFont);
  new_button.addActionListener(this);
  p2.add(new_button);

  change_button = new Button(CHANGE_BUTTON_CMD);
  change_button.setBackground(buttonColor);
  change_button.setFont(headFont);
  change_button.addActionListener(this);
  p2.add(change_button);

  delete_button = new Button(DELETE_BUTTON_CMD);
  delete_button.setBackground(buttonColor);
  delete_button.setFont(headFont);
  delete_button.addActionListener(this);
  p2.add(delete_button);

  duplicate_button = new Button(DUPLICATE_BUTTON_CMD);
  duplicate_button.setBackground(buttonColor);
  duplicate_button.setFont(headFont);
  duplicate_button.addActionListener(this);
  p2.add(duplicate_button);

  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(p2, p1_const);
  p1.add(p2);
  p1_const.gridwidth = 1; // reset to default



  // Bottom part of the UI
  if(!isAnApplet)
  {
   exit_button = new Button(EXIT_BUTTON_CMD);
   exit_button.setBackground(buttonColor);
   exit_button.setFont(headFont);
   exit_button.addActionListener(this);
   p3.add("South", exit_button);
  }


  // Default behaviour of buttons and fields
  edit_disable();



  // Place together all the sub-panels on the global layout
  setLayout(new BorderLayout());
  add("North",  p1);
  add("South",  p3);

  debug(DBG_TRACE, "Leaving  init()");
 }
 

 /**********************************
  * Import the database to work with
  */
 private void get_dbase_instance()
 {

  if(!isAnApplet)
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try 
   {   
    dbase = new DbHelper(dbase_host, dbase_port); 
   }
   catch(Exception e)
 //  catch(SystemException e)
   {
    debug(DBG_ERRORS, "ORB failed connecting to database");
    e.printStackTrace();
    System.exit(-1);
   }
  }

 }
 


 /**********************************
  * Disable edition capability (edit fields and buttons)
  */
 private void edit_disable()
 {
  edit_field.setText("");
  edit_field.setEditable(false);

  new_button.setEnabled(false);
  change_button.setEnabled(false);
  delete_button.setEnabled(false);
  duplicate_button.setEnabled(false);
 }

 


 /**********************************
  * Enable edition capability (edit fields and buttons)
  */
 private void edit_enable()
 {
  edit_field.setEditable(true);

// TODO:
//  new_button.setEnabled(true);
  new_button.setEnabled(false);

// TODO:
//  change_button.setEnabled(true);
  delete_button.setEnabled(true);

// TODO:
//  duplicate_button.setEnabled(true);
 }




 /**********************************
  * Update the UI after a domain selection.
  */
 private void update_domain()
 {
  filter_domain_text = filter_domain.getText();
  debug(DBG_MAX,"Filter domain: " + filter_domain_text);
  update_domain_list(filter_domain_text);
  list_family.removeAll();
  list_member.removeAll();
  list_property.removeAll();
  list_value.removeAll();

  list_attr.removeAll();
  list_attr_property.removeAll();
  list_attr_value.removeAll();
    
  filter_family.setText("*");
  filter_member.setText("*");
  filter_property.setText("*");
 
  filter_attr.setText("*");

  update_select(
	null,
	null,
	null,
	null,
	null,
	null);
  edit_disable();

  filter_domain.requestFocus();
 }



 /**********************************
  * Update the UI after a family selection.
  */
 private void update_family()
 {
  String domain = list_domain.getSelectedItem();
  filter_family_text = filter_family.getText();
  update_family_list(domain, filter_family_text);
  list_member.removeAll();
  list_property.removeAll();
  list_value.removeAll();

  list_attr.removeAll();
  list_attr_property.removeAll();
  list_attr_value.removeAll();
    
  filter_member.setText("*");
  filter_property.setText("*");
 
  filter_attr.setText("*");

  update_select(
	domain,
	null,
	null,
	null,
	null,
	null);
  edit_disable();

  filter_family.requestFocus();
 }



 /**********************************
  * Update the UI after a member selection.
  */
 private void update_member()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  filter_member_text = filter_member.getText();
  update_member_list(domain, family, filter_member_text);
  list_property.removeAll();
  list_value.removeAll();

  list_attr.removeAll();
  list_attr_property.removeAll();
  list_attr_value.removeAll();

  filter_property.setText("*");
  filter_attr.setText("*");

  update_select(
	domain,
	family,
	null,
	null,
	null,
	null);
  edit_disable();

  filter_member.requestFocus();
 }


 /**********************************
  * Update the UI after a property selection.
  */
 private void update_property()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  filter_property_text = filter_property.getText();
  update_property_list(domain, family, member, filter_property_text);
  list_value.removeAll();

  update_select(
	domain,
	family,
	member,
	null,
	null,
	null);
  edit_field.setText(member);
  edit_enable();

  filter_property.requestFocus();
 }


 /**********************************
  * Update the UI after a property selection.
  */
 private void update_property_value()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  String property = list_property.getSelectedItem();
  update_value_list(domain, family, member, property);

  update_select(
	domain,
	family,
	member,
	property,
	null,
	null);
  edit_field.setText(property);
  edit_enable();
//TODO: move this to edit_enable()
  new_button.setEnabled(true);

  filter_property.requestFocus();
 }

 /**********************************
  * Update the UI after a property value selection.
  */
 private void update_property_value_select()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  String property = list_property.getSelectedItem();
  String value = list_value.getSelectedItem();

  update_select(
	domain,
	family,
	member,
	property,
	null,
	null);
  edit_field.setText(value);
  edit_disable();
 }

 /**********************************
  * Update the UI after a member selection.
  */
 private void update_attr()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  filter_attr_text = filter_attr.getText();
  update_attr_list(domain, family, member, filter_attr_text);
  list_attr_property.removeAll();
  list_attr_value.removeAll();


  update_select(
	domain,
	family,
	member,
	null,
	null,
	null);
  edit_field.setText(member);
  edit_enable();
 }


 /**********************************
  * Update the UI after an attribute selection.
  */
 private void update_attr_property()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  String attr   = list_attr.getSelectedItem();
  update_attr_property_list(domain, family, member, attr);

  list_attr_value.removeAll();

  update_select(
	domain,
	family,
	member,
	null,
	attr,
	null);
  edit_field.setText(attr);
  edit_enable();
//TODO: move this to edit_enable()
  new_button.setEnabled(true);

 }



 /**********************************
  * Update the UI after an attribute property selection.
  */
 private void update_attr_property_value()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  String attr   = list_attr.getSelectedItem();
  String property   = list_attr_property.getSelectedItem();
  update_attr_property_value_list(domain, family, member, attr, property);

  update_select(
	domain,
	family,
	member,
	null,
	attr,
	property);
  edit_field.setText(property);
  edit_enable();
//TODO: move this to edit_enable()
  new_button.setEnabled(true);
 }


 /**********************************
  * Update the UI after an attribute property value selection.
  */
 private void update_attr_property_value_select()
 {
  String domain = list_domain.getSelectedItem();
  String family = list_family.getSelectedItem();
  String member = list_member.getSelectedItem();
  String attr   = list_attr.getSelectedItem();
  String property   = list_attr_property.getSelectedItem();
  String value  = list_attr_value.getSelectedItem();

  update_select(
	domain,
	family,
	member,
	null,
	attr,
	property);
  edit_field.setText(value);
  edit_disable();
 }


 /**********************************
  * Update on the UI the selected field
  */
 private void update_select( 
	String domain,
	String family,
	String member,
	String property,
	String attr,
	String attr_property)
 {
  select_domain              = domain;
  select_family              = family;
  select_member              = member;
  select_property            = property;
  select_attr                = attr;
  select_attr_property       = attr_property;

  String text = "";
  
  if(domain != null)
   text += domain;

  if(family != null)
   text += "/" + family;

  if(member != null)
   text += "/" + member;

  if(property != null)
   text += ":" + property;

  if(attr != null)
   text += ":" + attr;

  if(attr_property != null)
   text += "/" + attr_property;

  select_field.setText(text);
 }








 /**********************************
  * Request a command to the servlet
  *
  */
 private String[] get_servlet_answer(
        String cmd,
	String domain,
	String family,
	String member,
	String property,
	String value,
	String attr,
	String attr_property,
 	String attr_property_value)
 {
  String[] ret_array = null;

  try
  {
   String	dummy	= null;
   Vector	argouts	= new Vector();


   //
   // Prepare connection to the servlet
   //
   URL		  servlet_url = new URL(
	getCodeBase(), 
    	debug_url + 
        SERVLET_NAME);

   HttpMessage msg = new HttpMessage(servlet_url);
  


   //
   // Prepare argin parameters for the servlet
   //
   Properties  params = new Properties();
   params.put("host",       client_host);
   params.put("cmd",        cmd);
   params.put("dbase_host", dbase_host);
   params.put("dbase_port", dbase_port);
   params.put("domain",     domain);
   if(family != null)
    params.put("family",    family);
   if(member != null)
    params.put("member",    member);
   if(property != null)
    params.put("property",  property);
   if(value != null)
    params.put("value",     value);
   if(attr != null)
    params.put("attr",      attr);
   if(attr_property != null)
    params.put("attr_property",      attr_property);
   if(attr_property_value != null)
    params.put("attr_property_value",      attr_property_value);



   //
   // Make a synchronous request (wait for the answer) to the servlet
   //
   debug(DBG_TRACE, "Waiting for servlet...");
   InputStream    in          = msg.sendPostMessage(params);
   debug(DBG_TRACE, "done, something to print!!");



   //
   // Extract argouts from servlet returned string (expected strings
   // separated by '\n' charater)
   //
   BufferedReader data        = new BufferedReader(
			  	new InputStreamReader(
				new BufferedInputStream(in)));
    
   while((dummy = data.readLine()) != null)
   {
    argouts.addElement(dummy);
    debug(DBG_INFOS, dummy);
   }

   // Vector -> Array (but removing the last empty string)
   ret_array = new String[argouts.size() - 1];
   for(int i=0; i < (argouts.size() - 1); i++)
    ret_array[i] = (String)argouts.elementAt(i);

  }
  catch(Exception e)
  { 
   debug(DBG_ERRORS, "Exception: " + e.getClass().getName());
   debug(DBG_ERRORS, "   " + e.getMessage());
   e.printStackTrace();
   // TODO: what to do with errors messages
   System.exit(-1);
  }


  //
  // Return the expected strings as an array of strings
  //
  return ret_array;
 }



 /**********************************
  * Request values
  * 
  */
 private String[] request_servlet_get_database(
	String domain,
	String family,
	String member,
	String property,
	String value,
	String attr,
	String attr_property,
 	String attr_property_value)
 {
  return get_servlet_answer(
	"get_database",
	domain,
	family,
	member,
	property,
  	value,
	attr,
	attr_property,
	attr_property_value);
 }



 /**********************************
  * Request to delete a value
  * 
  */
 private void request_servlet_delete(
	String domain,
	String family,
	String member,
	String property,
	String attr,
	String attr_property)
 {
  get_servlet_answer(
	"delete",
	domain,
	family,
	member,
	property,
  	null,
	attr,
	attr_property,
	null);


  return;
 }


 /**********************************
  * Request to add a value
  * 
  */
 private void request_servlet_new(
	String domain,
	String family,
	String member,
	String property,
	String attr,
	String attr_property)
 {
  get_servlet_answer(
	"new",
	domain,
	family,
	member,
	property,
  	null,
	attr,
	attr_property,
	null);


  return;
 }








 /**********************************
  * Get from database the list of domain names and 
  * update the UI list.
  */
 private void update_domain_list(String domain_filter)
 {
  String[] array_domain = null;

  
  //
  // Get the domain names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_domain = request_servlet_get_database(
	domain_filter, 
	null, 
	null, 
	null, 
	null, 
	null, 
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_domain = dbase.get_domain(domain_filter);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get domain list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    debug(DBG_ERRORS, "Exception: " + e.getClass().getName());
    debug(DBG_ERRORS, "   " + e.getMessage());
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }


  //
  // Update the UI list
  //
  int nb_domain = array_domain.length;
  debug(DBG_MAX, "nb of domain: " + nb_domain);
  list_domain.removeAll();
  for(int i=0; i < nb_domain;i++)
   list_domain.add(array_domain[i]);
 }



 /**********************************
  * Get from database the list of family names corresponding to the
  * specified family name  and update the UI list.
  */
 private void update_family_list(String domain, String family_filter)
 {
  String[] array_family = null;

  
  //
  // Get the family names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_family = request_servlet_get_database(
	domain, 
	family_filter, 
	null, 
	null, 
	null, 
	null, 
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_family = dbase.get_family(domain, family_filter);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get family list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  list_family.removeAll();
  int nb_family = array_family.length;
  debug(DBG_MAX, "nb of family: " + nb_family);
  list_family.removeAll();
  for(int i=0; i < nb_family;i++)
   list_family.add(array_family[i]);
 }




 /**********************************
  * Get from database the list of members names corresponding to the
  * specified domain and family names and update the UI list.
  */
 private void update_member_list(
	String domain, 
	String family,
	String member_filter)
 {
  String[] array_member = null;

  
  //
  // Get the member names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_member = request_servlet_get_database(
	domain, 
	family, 
	member_filter, 
	null, 
	null, 
	null, 
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_member = dbase.get_member(domain, family, member_filter);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get member list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  list_member.removeAll();
  int nb_member = array_member.length;
  debug(DBG_MAX, "nb of member: " + nb_member);
  list_member.removeAll();
  for(int i=0; i < nb_member;i++)
   list_member.add(array_member[i]);
 }


 /**********************************
  * Get from database the list of members names corresponding to the
  * specified domain family and property names and update the UI list.
  */
 private void update_property_list(
	String domain, 
	String family, 
	String member,
	String property_filter)
 {
  String[] array_property = null;

  
  //
  // Get the property names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_property = request_servlet_get_database(
	domain, 	
	family, 
	member, 
	property_filter, 
	null,
	null, 
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_property = dbase.get_property(domain, family, member,property_filter);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get property list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  list_property.removeAll();
  int nb_property = array_property.length;
  debug(DBG_MAX, "nb of property: " + nb_property);
  list_property.removeAll();
  for(int i=0; i < nb_property;i++)
   list_property.add(array_property[i]);

  // Needed for the new when the list is empty
  if(nb_property == 0)
   list_property.add(" ");
 }


 /**********************************
  * Get from database the list of values of corresponding to the
  * specified property and update the UI list.
  */
 private void update_value_list(
	String domain, 
	String family, 
	String member,
	String property)
 {
  String[] array_value = null;

  
  //
  // Get the values
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_value = request_servlet_get_database(
	domain, 
	family, 
	member, 
	property, 
	"bidon",
	null, 
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_value = dbase.get_property_value(domain, family, member, property);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get value list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }



  //
  // Update the UI list
  //
  list_value.removeAll();
  int nb_value = array_value.length;
  debug(DBG_MAX, "nb of value: " + nb_value);
  list_value.removeAll();
  for(int i=0; i < nb_value;i++)
   list_value.add(array_value[i]);
 }







 /**********************************
  * Get from database the list of attribute names corresponding to the
  * specified device and update the UI list.
  */
 private void update_attr_list(
	String domain, 
	String family, 
	String member,
	String attr_filter)
 {
  String[] array_attr = null;

  
  //
  // Get the attr names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_attr = request_servlet_get_database(
	domain, 	
	family, 
	member, 
 	null,
	null, 
	attr_filter,
	null, 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_attr = dbase.get_attr(domain, family, member, attr_filter);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get attr list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  int nb_attr = array_attr.length;
  debug(DBG_MAX, "nb of attr: " + nb_attr);
  list_attr.removeAll();
  for(int i=0; i < nb_attr;i++)
   list_attr.add(array_attr[i]);

  // Needed for the new when the list is empty
  if(nb_attr == 0)
   list_attr.add(" ");

 }



 /**********************************
  * Get from database the list of attribute property names corresponding to the
  * specified device and update the UI list.
  */
 private void update_attr_property_list(
	String domain, 
	String family, 
	String member,
	String attr)
 {
  String[] array_property = null;

  
  //
  // Get the property names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   array_property = request_servlet_get_database(
	domain, 	
	family, 
	member, 
 	null,
	null, 
	attr,
	"bidon", 
	null);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    array_property = dbase.get_attr_property(
	domain, family, member, attr);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get property list");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  int nb_property = array_property.length;
  debug(DBG_MAX, "nb of property: " + nb_property);
  list_attr_property.removeAll();
  for(int i=0; i < nb_property;i++)
   list_attr_property.add(array_property[i]);
 }


 /**********************************
  * Get from database the list of attribute property values corresponding to the
  * specified device and update the UI list.
  */
 private void update_attr_property_value_list(
	String domain, 
	String family, 
	String member,
	String attr,
	String property)
 {
  String[] property_value = null;

  
  //
  // Get the property names
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   property_value = request_servlet_get_database(
	domain, 	
	family, 
	member, 
 	null,
	null, 
	attr,
	property,
	"bidon");
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    property_value = dbase.get_attr_property_value(
	domain, family, member, attr, property);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to get property value");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  int nb_property = property_value.length;
  debug(DBG_MAX, "nb of values: " + nb_property);
  list_attr_value.removeAll();
  for(int i=0; i < nb_property;i++)
   list_attr_value.add(property_value[i]);
 }


 /**********************************
  * Remove from the database the current selected value
  * update the UI list.
  */
 private void delete_value()
 {
  //
  // Remove the current selection (not selected fields are null)
  //
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   request_servlet_delete(
	select_domain, 
	select_family, 
	select_member, 
	select_property,
	select_attr, 
	select_attr_property);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    dbase.delete_value(
	select_domain, 
	select_family, 
	select_member, 
	select_property,
	select_attr, 
	select_attr_property);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to delete value");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  if(select_attr_property != null)
  {
   update_attr_property();
   // database behaviour: if an attribute has no more properties
   // it will be deleted 
   if(list_attr_property.getItemCount() == 0)
    update_attr();
  }
  else if(select_attr != null)
   update_attr();
  else if(select_property != null)
   update_property();
  else if(select_member != null)
   update_member();
 }


 /**********************************
  * Create a new entry in the database
  */
 private void new_value()
 {
  //
  // Check if a new entry name has been entered comparing to current
  // selection (not selected fields are null). If not then there is
  // nothing to do (won't recreate something already existing)
  //
  String new_entry = edit_field.getText();
  String last_selection = null;

  String new_domain = select_domain;
  String new_family = select_family;
  String new_member = select_member;
  String new_property = select_property;
  String new_attr = select_attr;
  String new_attr_property = select_attr_property;

  if(select_attr_property != null)
  {
   last_selection = select_attr_property;
   new_attr_property = new_entry;
   debug(DBG_INFOS, "new attr property");
  }
  else if(select_attr != null)
  {
   last_selection = select_attr;
   new_attr = new_entry;
   debug(DBG_INFOS, "new attr");
  }
  else if(select_property != null)
  {
   last_selection = select_property;
   new_property = new_entry;
   debug(DBG_INFOS, "new property");
  }
  else if(select_member != null)
  {
   last_selection = select_member;
   new_member = new_entry;
   debug(DBG_INFOS, "new member");
  }

  // Should never be but...
  if(last_selection == null) 
  {
   debug(DBG_INFOS, "panic, last_selection null");
   return;
  }

  // Nothing to do if nothing changed
  if(last_selection.equals(new_entry))
  {
   debug(DBG_INFOS, "nothing to do");
   return;
  }


  //
  // Create a new entry in the database
  //
  debug(DBG_INFOS, "adding: " + new_entry);
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   request_servlet_new(
	new_domain, 
	new_family, 
	new_member, 
	new_property,
	new_attr, 
	new_attr_property);
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    dbase.new_value(
	new_domain, 
	new_family, 
	new_member, 
	new_property,
	new_attr, 
	new_attr_property);
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to delete value");
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    // TODO: what to do with errors messages
    System.exit(-1);
   }
   catch(Exception e)
   {
    e.printStackTrace();
    // TODO: what to do with errors messages
    System.exit(-1);
   }
  }

  //
  // Update the UI list
  //
  if(select_attr_property != null)
  {
   update_attr_property();
   select_list_item(list_attr_property, new_entry);
   update_attr_property_value();
  } 
  else if(select_attr != null)
  {
   update_attr();
   select_list_item(list_attr, new_entry);
   update_attr_property();
  }
  else if(select_property != null)
  {
   update_property();
   select_list_item(list_property, new_entry);
   update_property_value();
  }
  else if(select_member != null)
  {
   update_member();
   select_list_item(list_member, new_entry);
   update_property();
   update_attr();
  }

 }





 /**********************************
  * Select on a list the item specified.
  */
 private void select_list_item(List list, String item)
 {
  int idx = list.getItemCount() - 1;
  while((idx != -1) && !list.getItem(idx).equalsIgnoreCase(item)) 
   idx--;
  list.select(idx);
 }



 /**********************************
  * Called when a button on the UI is depressed
  */
 public void actionPerformed(ActionEvent evt)
 {
  Object src = evt.getSource();

  if(src == hostport_button)
  {
   String new_host = field_host.getText();
   String new_port = field_port.getText();
   if(!new_host.equals(dbase_host) || !new_port.equals(dbase_port))
   {
    debug(DBG_TRACE, "changing database to: " + new_host + ":" + new_port);
    dbase_host = new_host;
    dbase_port = new_port;
    get_dbase_instance();
    update_domain();
   }
  }

  if(src == filter_domain) 
   update_domain();

  if(src == filter_family) 
   update_family();

  if(src == filter_member) 
   update_member();

  if(src == filter_property) 
   update_property();

  if(src == filter_attr) 
   update_attr();

  if(src == new_button) 
   new_value();

  if(src == delete_button) 
   delete_value();

  if(src == exit_button) 
   System.exit(0);
 
 }



 /**********************************
  * Called when an item in the command list is selected
  */
 public void itemStateChanged(ItemEvent e)
 {
  List list  = (List)(e.getItemSelectable());

  if(e.getStateChange() == ItemEvent.SELECTED)
  {
   debug(DBG_MAX, "selection: " + list.getSelectedItem());

   if(list == list_domain)
   {
    debug(DBG_MAX, "on domain list");
    update_family();
   }

   if(list == list_family)
   {
    debug(DBG_MAX, "on family list");
    update_member();
   }

   if(list == list_member)
   {
    debug(DBG_MAX, "on member list");
    update_property();
    update_attr();
   }

   if(list == list_property)
   {
    debug(DBG_MAX, "on property list");
    update_property_value();
   }

   if(list == list_value)
   {
    debug(DBG_MAX, "on value list");
    update_property_value_select();
   }

   if(list == list_attr)
   {
    debug(DBG_MAX, "on attribute list");
    update_attr_property();
   }

   if(list == list_attr_property)
   {
    debug(DBG_MAX, "on attribute property list");
    update_attr_property_value();
   }

   if(list == list_attr_value)
   {
    debug(DBG_MAX, "on attribute property value list");
    update_attr_property_value_select();
   }

  }
 }










 /**********************************
  * Call when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void start()
 {
  debug(DBG_TRACE, "Entering start()"); 

  isShuttingDown = false;


  debug(DBG_TRACE, "Leaving  start()");
 }



 /**********************************
  * Call when the associated thread is started (in start() method)
  */
 public void run()
 {

  debug(DBG_TRACE, "Entering run()");


  debug(DBG_TRACE, "Leaving  run()");
 }





 /**********************************
  * Call when the client browser leave the HTML page containing this applet
  * (i.e. change the URL location)
  */
 public void stop()
 {
  debug(DBG_TRACE, "Entering stop()");

  // Inform the thread that we want it to end
  isShuttingDown = true;


  debug(DBG_TRACE, "Leaving  stop()");
 }






 /**********************************
  *
  */
 private static void debug(int level, String message)
 {
  if(verbose_level >=  level)
   System.out.println("DbGetApplet: " + message);
 }

}
