/***************************************************************************** 
 *
 * Refers to servlets/CmdGet.java for explanations on this applet.
 *
 * Note for compiling: this applet use O'Reilly class to simplify
 *	HTTP applet-server communication. To use this class, CLASSPATH
 *	must include a path to O'Reilly's file HttpMessage.class
 *	For instance, if this file is located in the same directory than
 *	the source file using this class then CLASSPATH must contain "./"
 *
 *
 * Note for DEBUG: the debug() messages can be seen in the
 *	Java console of the browser.  With Netscape 4.61: 
 *	Communicator:Tools:Java Console
 *
 */

import java.applet.*;
import java.awt.*;
import java.net.*;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.net.InetAddress;
import java.util.Properties;


/***************************************************************************** 
 *
 *
 */
public class CmdHistApplet_old extends Applet implements Runnable
{
 TextArea	history;
 Thread		thread;
 String		device_name = null;
 String		local_host  = null;

 // FOR DEBUG THE CmdExec SERVLET WITH servletrunner:
 //String	debug_url = "http://amber1.esrf.fr:8080"; 
 // FOR NO DEBUG:
 String	debug_url = "";



 /**
  * Call when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void init()
 {
  debug("Entering init()");

  // Get Applet parameters
  device_name = this.getParameter("device");

  history = new TextArea();
  history.setBackground(new Color(0xcc, 0xff, 0xff));
  history.setEditable(false);

  setLayout(new BorderLayout());
  add("Center",history);


  debug("Leaving  init()");
 }
 




 /**
  * Call when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void start()
 {
  debug("Entering start()"); 

  thread = new Thread(this);
  thread.start();

  try
  {
   local_host = InetAddress.getLocalHost().getHostName();
   debug("Hostname: " + local_host);
  }
  catch(Exception ignored) {}

  debug("Leaving  start()");
 }



 /**
  * Call when the associated thread is started (in start() method)
  */
 public void run()
 {
  debug("Entering run()");

  while(true)
  {
   history.append(getNextCommand());
   int last_pos = history.getText().length();
   history.select(last_pos, last_pos);
  }

 }



 /**
  * Call when the client browser leave the HTML page containing this applet
  * (i.e. change the URL location)
  */
 public void stop()
 {
  debug("Entering stop()");

  try
  {
   URL		servlet_url = new URL(
	getCodeBase(), 
    	debug_url + 
	"/servlet/CmdExec_old");

   HttpMessage 	msg         = new HttpMessage(servlet_url);

   Properties	params      = new Properties();
   params.put("host", local_host);
   params.put("device", "finished" + device_name);

   InputStream	in          = msg.sendGetMessage(params);
  }
  catch(Exception e)
  { 
   debug("Exception: " + e.getClass().getName());
   debug("   " + e.getMessage());
  }



  thread.stop();
  thread = null;

  debug("Leaving  stop()");
 }



 /**
  * Retrieve from the HTTP server the next command result
  * This retrieving is blocking until the server (i.e. the servlet)
  * decides that there is something to display by this applet.
  */
 String getNextCommand()
 {
  debug("Entering getNextCommand()");

  String 	NextResult = null;


  // Need to loop because the blocking retrieving is not so blocking !
  // It may return with an IOException due to a timeout on retrieving.
  while(NextResult == null)
  {
   try
   {
    String	dummy       = null;

    URL		  servlet_url = new URL(
	getCodeBase(), 
    	debug_url + 
	"/servlet/CmdExec_old");

    HttpMessage	  msg         = new HttpMessage(servlet_url);
  
    Properties	params      = new Properties();
    params.put("host", local_host);
    params.put("device", device_name);

    debug("Waiting for servlet...");
    InputStream    in          = msg.sendGetMessage(params);
    debug("done, something to print!!");


    BufferedReader data        = new BufferedReader(
			  	new InputStreamReader(
				new BufferedInputStream(in)));
    
    dummy = data.readLine();
    NextResult = dummy + "\n";
    while((dummy = data.readLine()) != null)
     NextResult += dummy + "\n";

    debug("NextResult:BEG" + NextResult + "END");
   }
   catch(Exception e)
   { 
    debug("Exception: " + e.getClass().getName());
    debug("   " + e.getMessage());
   }
  }

  debug("Leaving  getNextCommand()");

  return  NextResult;
 }


 /**
  *
  */
 private void debug(String message)
 {
  // FOR DEBUG ONLY:
  System.out.println("CmdHistApplet: " + message);
 }

}
