/***************************************************************************** 
 *
 * Refers to servlets/CmdGet.java for explanations on this applet.
 *
 * Note for compiling: this applet use O'Reilly class to simplify
 *      HTTP applet-server communication. To use this class, CLASSPATH
 *      must include a path to O'Reilly's file HttpMessage.class
 *      For instance, if this file is located in the same directory than
 *      the source file using this class then CLASSPATH must contain "./"
 *
 * Note the following files are also needed and therefore the previous
 *	note must be applied:
 *		Tango.jar
 *		DevHelper.class
 *
 * Note for DEBUG: the debug() messages can be seen in the
 *      Java console of the browser.  With Netscape 4.61:
 *      Communicator:Tools:Java Console
 *
 *
 */

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Properties;

//import Tango.*;
//import TangoDs.*;
//import org.omg.CORBA.*;



/***************************************************************************** 
 *
 *
 */
public class CmdGetApplet
			extends 
				Applet 
			implements 
				Runnable, 
				ActionListener, 
				ItemListener,
				MouseListener
{
 boolean		isAnApplet     = true;
 Thread			thread;
 String			client_host  = null;

 // TANGO device stuff
 DevHelper		device;
 String			device_name = null;
 static String		dbase_host = null;
 static String		dbase_port = null;
 static String		session_id = null;
 int			nb_commands;
 CmdInfo[] 		commands;
 static final String	EXEC_SERVLET_NAME = "/jive/servlet/CmdExec";

 // UI components
 List 			list_commands;
 TextField  		in_type_field;
 TextField  		out_type_field;
 TextArea  		in_type_desc;
 TextArea  		out_type_desc;
 TextField  		in_value;
 TextArea       	history;
 Button			exec_button;
 Button			exit_button;
 Label			in_example;


 // Constant definitions
 static final String	DBASE_HOST_DEF  = "tango";
 static final String	DBASE_PORT_DEF  = "10000";
 static final String	EXEC_BUTTON_CMD = "Execute";
 static final String	EXIT_BUTTON_CMD = "Exit";


 // FOR DEBUG THE CmdExec SERVLET WITH servletrunner:
 //String		debug_url = "http://almeria.esrf.fr:8080"; 
 // FOR NO DEBUG:
 String			debug_url = "";
 static int		verbose_level;
 static final int	DBG_NONE   = 0;	// no verbose at all
 static final int	DBG_ERRORS = 1; // minimum verbose level
 static final int	DBG_TRACE  = 2;
 static final int	DBG_INFOS  = 3;
 static final int	DBG_MAX    = 4; // maximum verbose level


 // Taken from fr.esrf.TangoDs.TangoConst to avoid using Tango.jar
 final String[] Tango_CmdArgTypeName = {
                new String("DevVoid"),
                new String("DevBoolean"),
                new String("DevShort"),
                new String("DevLong"),
                new String("DevFloat"),
                new String("DevDouble"),
                new String("DevUShort"),
                new String("DevULong"),
                new String("DevString"),
                new String("DevVarCharArray"),
                new String("DevVarShortArray"),
                new String("DevVarLongArray"),
                new String("DevVarFloatArray"),
                new String("DevVarDoubleArray"),
                new String("DevVarUShortArray"),
                new String("DevVarULongArray"),
                new String("DevVarStringArray"),
                new String("DevVarLongStringArray"),
                new String("DevVarDoubleStringArray"),
                new String("DevState")
 };



 /**********************************
  * Called when running the applet not from an HTML page and a browser but
  * from local virtual machine as a standalone application.
  */
 public static void main(String args[])
 {
  Frame 		f = new Frame("JIVE - CmdGetApplet");
  CmdGetApplet		cmdGetApplet = new CmdGetApplet();
  int			verbose_level_def;
  int			verbose_level;


  // Set default database to work with
  dbase_host = DBASE_HOST_DEF;
  dbase_port = DBASE_PORT_DEF;


  // Get device name from arguments
  if(args.length < 1)
  {
   System.out.println("Usage: java cmdGetApplet device_name [-v[" +
	DBG_NONE + "-" + DBG_MAX +"]] [-hhost] [-pport]");
   System.out.println("         " + DBG_NONE   + " : no debug message at all");
   System.out.println("         " + DBG_ERRORS + " : print out errors");
   System.out.println("         " + DBG_TRACE  + " : entering/leaving methods");
   System.out.println("         " + DBG_INFOS  + " : variables values");
   System.out.println("         " + DBG_MAX    + " : maximum verbose");
   System.out.println("         host : database host name ["+dbase_host+"]");
   System.out.println("         port : database port name ["+dbase_port+"]");
   System.exit(-1);
  }
  else
   cmdGetApplet.device_name = args[0];

  // Default verbose level
  verbose_level_def = DBG_NONE; 
  verbose_level = verbose_level_def;

  // Check command line arguments
  for(int i=0; i < args.length; i++)
  {
   String arg = args[i];

   // Get verbose level from arguments if any
   if((arg.startsWith("-v")) || (arg.startsWith("-V")))
    if(arg.length() > 2)
    {
     try 
     { 
      verbose_level = Integer.parseInt(arg.substring(2)); 
     }
     catch(NumberFormatException e) 
     { 
      System.out.println("Error: wrong verbose level, correct values [" +
	DBG_NONE + "-" + DBG_MAX +"]");
      verbose_level = DBG_MAX; // if -v is given without level assume maximum
     }
    }
    else // if -v is given without level assume maximum
     verbose_level = DBG_MAX;

   // Get database host name to work with
   if((arg.startsWith("-h")) || (arg.startsWith("-H")))
    dbase_host = arg.substring(2);

   // Get database port to work with
   if((arg.startsWith("-p")) || (arg.startsWith("-P")))
    dbase_port = arg.substring(2);
  }



  // Minimum check on verbose level entered
  if((verbose_level<DBG_NONE) || (verbose_level>DBG_MAX))  
  { 
   System.out.println("Error: wrong verbose level, correct values [" +
	DBG_NONE + "-" + DBG_MAX +"]");
   verbose_level = verbose_level_def;
  }

  // Keep the verbose level
  cmdGetApplet.verbose_level = verbose_level;	
  System.out.println("CmdGetApplet: verbose_level: " + verbose_level);

  // Minimum log
  debug(DBG_INFOS, "database host: " + dbase_host);
  debug(DBG_INFOS, "database port: " + dbase_port);

  // Mark that we are running as a standalone application
  cmdGetApplet.isAnApplet  = false;


  // Emulate applet startup procedure
  cmdGetApplet.init();


  // Place the applet UI on the window frame
  f.add(cmdGetApplet);

  // Configure and display the application window
  f.setTitle("JIVE");
  f.setSize(460,460);	// should be the same than the APPLET tags WIDTH/HEIGHT
			// but not necessary (difference is window borders)
  //f.setResizable(false);
  f.show();
 }




 /**********************************
  * Called when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void init()
 {
  debug(DBG_TRACE, "Entering init()");


  //
  // TANGO init (only if running in standalone application)
  //
  if(!isAnApplet)
  {
   try 
   {   
    device = new DevHelper(device_name, dbase_host, dbase_port); 
   }
   catch(DevHelperDevFailed e)
   {
    debug(DBG_ERRORS, "failed to import device: " + device_name);
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    e.printStackTrace();

    System.exit(-1);
   }
   catch(Exception e)
//   catch(SystemException e)
   {
    debug(DBG_ERRORS, "ORB failed connecting to database");
    e.printStackTrace();
    System.exit(-1);
   }
  }



  //
  // Get the device name and commands
  // (as applet arguments if running as an applet or directly from
  // the database server if running a a standalone application)
  //
  get_commands();


  //
  // Get the local machine name for command logs
  //
  try
  {
   client_host = InetAddress.getLocalHost().getHostName();
   debug(DBG_INFOS, "Hostname: " + client_host);
  }
  catch(Exception ignored) {}



  //
  // Construct the user interface panel
  //

  // Prepare global resources for components
  Font  titleFont   = new Font("Times", Font.BOLD,  14);
  Font  headFont    = new Font("Times", Font.BOLD,  12);
  Font  normFont    = new Font("Times", Font.PLAIN, 12);
  Color buttonColor = new Color(0xff, 0x90, 0x00);
  Color titleColor  = new Color(0x33, 0x66, 0xff);
  Color backColor   = new Color(0xcc, 0xff, 0xff);


  // Entire applet background
  setBackground(backColor);

  // Default font used by all the components of the UI
  setFont(normFont);



  // Construct the UI itself placing components according to predefined layout
  GridBagLayout		p1_layout = new GridBagLayout();
  GridBagConstraints	p1_const  = new GridBagConstraints();
  setLayout(p1_layout);
  p1_const.fill  = GridBagConstraints.BOTH;
  p1_const.weightx  = 1.0;      // component enlarge if window is enlarged
  p1_const.weighty  = 0.0;
  p1_const.insets= new Insets(0,5,0,5);

  Panel p2 = new Panel();




  // Row number: 1
  Label bidon;
  bidon = new Label("Working on device: " + 
	dbase_host + ":" +
	dbase_port + ":" + device_name);
  bidon.setFont(titleFont);
  bidon.setForeground(titleColor);
  bidon.setAlignment(Label.CENTER);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);
  p1_const.gridwidth = 1; // reset to default


  // Row number: 2
  bidon = new Label("Command List");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);

  bidon = new Label("Argin Type");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);

  bidon = new Label("Argout Type");
  bidon.setFont(headFont);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 3

  // Add list of commands
  list_commands = new List(); 
  for(int i=0; i<nb_commands;i++)
   list_commands.add(commands[i].cmd_name);
  list_commands.addItemListener(this);
  list_commands.addMouseListener(this);
  p1_const.gridheight = 5;
  p1_layout.setConstraints(list_commands, p1_const);
  add(list_commands);
  p1_const.gridheight = 1; // reset to default


  in_type_field = new TextField(10);
  in_type_field.setEditable(false);
  p1_layout.setConstraints(in_type_field, p1_const);
  add(in_type_field);
  out_type_field = new TextField(10);
  out_type_field.setEditable(false);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(out_type_field, p1_const);
  add(out_type_field);
  p1_const.gridwidth = 1; // reset to default


  // Row number: 4
  bidon = new Label("Argin Description");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);

  bidon = new Label("Argout Description");
  bidon.setFont(headFont);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);
  p1_const.gridwidth = 1; // reset to default



  // Row number: 5
  in_type_desc = new TextArea("",1,20,TextArea.SCROLLBARS_HORIZONTAL_ONLY);
  in_type_desc.setEditable(false);
  p1_layout.setConstraints(in_type_desc, p1_const);
  add(in_type_desc);
  out_type_desc = new TextArea("",1,20,TextArea.SCROLLBARS_HORIZONTAL_ONLY);
  out_type_desc.setEditable(false);
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(out_type_desc, p1_const);
  add(out_type_desc);
  p1_const.gridwidth = 1; // reset to default


  // Row number: 6
  bidon = new Label("Argin Value");
  bidon.setFont(headFont);
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);

  bidon = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(bidon, p1_const);
  add(bidon);
  p1_const.gridwidth = 1; // reset to default


  // Row number: 7
  in_value = new TextField(10);
  in_value.setEditable(true);
  p1_layout.setConstraints(in_value, p1_const);
  add(in_value);

  in_example = new Label("");
  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(in_example, p1_const);
  add(in_example);
  p1_const.gridwidth = 1; // reset to default




  // Center part of the UI
  exec_button = new Button(EXEC_BUTTON_CMD);
  exec_button.setBackground(buttonColor);
  exec_button.setFont(headFont);
  exec_button.addActionListener(this);
  p2.add(exec_button);

  if(!isAnApplet)
  {
   exit_button = new Button(EXIT_BUTTON_CMD);
   exit_button.setBackground(buttonColor);
   exit_button.setFont(headFont);
   exit_button.addActionListener(this);
   p2.add(exit_button);
  }

  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_layout.setConstraints(p2, p1_const);
  add(p2);
  p1_const.gridwidth = 1; // reset to default


  // Bottom part of the UI
  history = new TextArea();
  history.setBackground(backColor);
  history.setEditable(false);

  p1_const.gridwidth = GridBagConstraints.REMAINDER; 	// end of row
  p1_const.weighty  = 1.0;
  p1_layout.setConstraints(history, p1_const);
  add(history);
  p1_const.gridwidth = 1; // reset to default
  p1_const.weighty  = 0.0;


  // Fill the UI field with default values
  list_commands.select(0);
  update_command_infos(0);


  debug(DBG_TRACE, "Leaving  init()");
 }
 


 /**********************************
  * Called when a button on the UI is depressed
  */
 public void actionPerformed(ActionEvent evt)
 {
  String button_cmd = evt.getActionCommand();
  
  if(button_cmd      == EXEC_BUTTON_CMD)
   execCurCommand();
  else if(button_cmd == EXIT_BUTTON_CMD)
   System.exit(0);
 
 }



 /**********************************
  * Called when an item in the command list is selected
  */
 public void itemStateChanged(ItemEvent e)
 {
  List list  = (List)(e.getItemSelectable());
  int  index = ((Integer)e.getItem()).intValue();

  if(e.getStateChange() == ItemEvent.SELECTED)
  {
   debug(DBG_INFOS, "Command selected: " + list.getItem(index));
   update_command_infos(index);
  }
 }



 /**********************************
  * Required by MouseListener interface
  */
 public void mousePressed(MouseEvent evt) {}
 public void mouseReleased(MouseEvent evt) {}
 public void mouseEntered(MouseEvent evt) {}
 public void mouseExited(MouseEvent evt) {}
 public void mouseClicked(MouseEvent evt) 
 {
  // If double clicked on a command then execute it
  if(evt.getClickCount() >= 2)
   execCurCommand();
 }



 /**********************************
  * Get the device name and commands
  *
  * from applet arguments if running as an applet or directly from
  * the database server if running as a standalone application.
  */
 void get_commands()
 {
  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 

   // Set a default verbose level for APPLET debug
   verbose_level = DBG_MAX;
   
   // Get parameters from HTML page
   device_name = this.getParameter("device");
   dbase_host  = this.getParameter("dbase_host");
   dbase_port  = this.getParameter("dbase_port");

   session_id = this.getParameter("session_id");
   debug(DBG_INFOS, "Session id: " + session_id);

   nb_commands = Integer.parseInt(this.getParameter("nb_commands"));

   // Prepare to store the commands information
   commands = new CmdInfo[nb_commands];

   // Add list of commands
   for(int i=0; i<nb_commands;i++)
   {
    String  num = Integer.toString(i);

    commands[i] = new CmdInfo();

    commands[i].cmd_name = this.getParameter("cmd"+num);

    commands[i].in_type  = Integer.parseInt(this.getParameter("cmd_in"+num));
    commands[i].in_type_desc = this.getParameter("cmd_in_desc"+num);

    commands[i].out_type = Integer.parseInt(this.getParameter("cmd_out"+num));
    commands[i].out_type_desc = this.getParameter("cmd_out_desc"+num);
   }
  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //

   fr.esrf.Tango.DevCmdInfo[]	tango_commands;

   // Get an array with the command list (including CORBA operations ping()
   // blackbox() etc) available for this device.
   tango_commands = device.command_list_query();

   // Get the number of commands of this device
   nb_commands = tango_commands.length;

   // Prepare to store the commands information
   commands = new CmdInfo[nb_commands];

   // Convert from fr.esrf.Tango.DevCmdInfo
   for(int i=0; i<nb_commands;i++)
   {
    commands[i] = new CmdInfo();

    commands[i].cmd_name      = tango_commands[i].cmd_name;

    commands[i].in_type       = tango_commands[i].in_type;
    commands[i].in_type_desc  = tango_commands[i].in_type_desc;

    commands[i].out_type      = tango_commands[i].out_type;
    commands[i].out_type_desc = tango_commands[i].out_type_desc;
   }
  }
 }




 /**********************************
  * Execute the current selected command on the device
  *
  * talk to the device through a servlet if running as an applet or 
  * talk directly to the device if running as a standalone application.
  */
 void execCurCommand()
 {
  debug(DBG_TRACE, "Entering execCurCommand()");

  // Get from UI command to be executed
  int index = list_commands.getSelectedIndex();
  String command_name = commands[index].cmd_name;
  debug(DBG_INFOS, "Command to be executed: " + command_name);

  // Get argin string from UI component
  String argin_string = in_value.getText();

  // Prepare command specific informations
  int	command_in_type  = commands[index].in_type;
  int	command_out_type = commands[index].out_type;

  String ret_client_string = null;

  if(isAnApplet)
  {
   //
   // Running as an applet, access to TANGO through servlets
   // 
   try
   {
    String dummy  = null;
    URL          servlet_url = new URL(
        getCodeBase(),
        debug_url + 
	EXEC_SERVLET_NAME);

    HttpMessage  msg         = new HttpMessage(servlet_url);



    Properties   params      = new Properties();
    params.put("host",         client_host);
    params.put("cmd",          command_name);
    params.put("device",       device_name);
    params.put("dbase_host",   dbase_host);
    params.put("dbase_port",   dbase_port);
    params.put("cmd_in",       Integer.toString(command_in_type));
    params.put("cmd_in_desc",  commands[index].in_type_desc);
    params.put("cmd_out",      Integer.toString(command_out_type));
    params.put("cmd_out_desc", commands[index].out_type_desc);
    params.put("argin",        argin_string);

    debug(DBG_TRACE, "Waiting for servlet...");
    InputStream  in          = msg.sendPostMessage(params);
    debug(DBG_TRACE, "done, something to print!!");


    BufferedReader data      = new BufferedReader(
                               new InputStreamReader(
                               new BufferedInputStream(in)));
    
    dummy = data.readLine();
    ret_client_string = dummy + "\n";
    while((dummy = data.readLine()) != null)
     ret_client_string += dummy + "\n";

    debug(DBG_INFOS, "NextResult:BEG" + ret_client_string + "END");
   }
   catch(Exception e)
   {
    debug(DBG_ERRORS, "Exception: " + e.getClass().getName());
    debug(DBG_ERRORS, "   " + e.getMessage());

    append_error(e.getMessage());
   }

  }
  else
  {
   //
   // Running in a standalone application, direct access to TANGO
   //
   try
   {
    ret_client_string = device.exec_command(command_name, argin_string);
   }
   catch(DevHelperDevFailed e)
   {
    append_error(
	"failed execution command: " + command_name + "\n" +
    	"reason: " + e.reason + "\n" +
    	"origin: " + e.origin);

    debug(DBG_ERRORS, "failed execution command: " + command_name);
    debug(DBG_ERRORS, "reason: " + e.reason);
    debug(DBG_ERRORS, "origin: " + e.origin);
    return;
   }
   catch(Exception e)
//   catch(SystemException e)
   {
    append_error(e.getMessage());
    return;
   }

  }

  //
  // Update history on UI 
  //
  append_history(ret_client_string);

  debug(DBG_TRACE, "Leaving execCurCommand()");
 }




 /**********************************
  * Update the UI fields according to the command number specified
  */
 private void update_command_infos(int i)
 {
  in_type_field.setText(Tango_CmdArgTypeName[commands[i].in_type]);
  if(commands[i].in_type != 0)
  {
   in_type_desc.setText(commands[i].in_type_desc);
   in_value.setEditable(true);
   in_example.setText(HtmlHelper.argin_example(commands[i].in_type)); 
  }
  else
  {
   in_type_desc.setText("");
   in_value.setText("");
   in_value.setEditable(false);
   in_example.setText(""); 
  }

  out_type_field.setText(Tango_CmdArgTypeName[commands[i].out_type]);
  if(commands[i].out_type != 0)
   out_type_desc.setText(commands[i].out_type_desc);
  else
   out_type_desc.setText("");

 }





 /**********************************
  * Call when the client browser open the HTML page containing this applet
  * (i.e. change the URL location to the HTML page)
  */
 public void start()
 {
  debug(DBG_TRACE, "Entering start()"); 

  debug(DBG_TRACE, "Leaving  start()");
 }



 /**********************************
  * Call when the associated thread is started (in start() method)
  */
 public void run()
 {
  debug(DBG_TRACE, "Entering run()");

  debug(DBG_TRACE, "Leaving  run()");
 }





 /**********************************
  * Call when the client browser leave the HTML page containing this applet
  * (i.e. change the URL location)
  */
 public void stop()
 {
  debug(DBG_TRACE, "Entering stop()");

  debug(DBG_TRACE, "Leaving  stop()");
 }





 /**********************************
  *
  */
 private void append_error(String message)
 {
  debug(DBG_ERRORS, message);
  append_history(
        "\n###################################\nERROR !!\n" +
	message);
 }


 /**********************************
  *
  */
 private void append_history(String message)
 {
  history.append(message);
  int last_pos = history.getText().length();
  history.select(last_pos, last_pos);
 }


 /**********************************
  *
  */
 private static void debug(int level, String message)
 {
  if(verbose_level >=  level)
   System.out.println("CmdGetApplet: " + message);
 }

}




/***************************************************************************** 
 *
 *
 */
class CmdInfo
{
 public CmdInfo()
 {
 }

 public CmdInfo(String cmd_name,
               int cmd_tag,
               int in_type,
               int out_type,
               String in_type_desc,
               String out_type_desc)
 {
  this.cmd_name = cmd_name;
  this.cmd_tag = cmd_tag;
  this.in_type = in_type;
  this.out_type = out_type;
  this.in_type_desc = in_type_desc;
  this.out_type_desc = out_type_desc;
 }

 public String cmd_name;
 public int cmd_tag;
 public int in_type;
 public int out_type;
 public String in_type_desc;
 public String out_type_desc;
}
