sequence DServMisc label "Testing Miscellaneous features of the DServer device"
{
	cpp user manu on device devtestmem
	{
		new ("dserver/devtest/api");

//
// Testing DevState and DevStatus commands
//

		command_inout("DevStatus") = "The device is ON";
		command_inout("DevState") = Tango::DevState.ON;	

//
// Testing DevRestart command on the dserver device
//

		new("dev/test/10") on device devtest;
		command_inout("IOState",Tango::DevState.OFF) on device devtest;
		state() = Tango::DevState.OFF on device devtest;
		delete() on device devtest;
		
		command_inout("DevRestartServer");
		
		sleep(3);
		delete();
		new("dserver/devtest/api");
				
		new("dev/test/10") on device devtest;
		state() = Tango::DevState.ON on device devtest;
		delete() on device devtest;

//
// Testing the DevRestart command on classical device
//

		command_inout("DevRestart","a/b/c") = except("API_DeviceNotFound",Tango::ErrSeverity.ERROR);		

		new("dev/test/10") on device devtest;
		command_inout("IOState",Tango::DevState.OFF) on device devtest;
		state() = Tango::DevState.OFF on device devtest;
		delete() on device devtest;

		command_inout("DevRestart","dev/test/10");

		sleep(3);

		new("dev/test/10") on device devtest;
		state() = Tango::DevState.ON on device devtest;
		delete() on device devtest;
				
//
// Testing name, description, state ans status CORBA attributes
//
		
		name() = "dserver/devtest/api";
		description() = "A device server device !!";
		status() = "The device is ON";
		state() = Tango::DevState.ON;

//
// Ping the device
//
			
		ping();
		
//
// Testing info call
//
		
		info() = ["DServer","devtest/api","amber12.esrf.fr","1","http://www.ulla.com"];
		
		delete();
	}
}
