sequence AttrMisc label "Testing miscellaneous cases of the read_attribute features"
{
	cpp user manu on device devtestmem
	{
		new ("dev/test/10");

	      	read_attribute("Toto") = except("API_AttrNotFound",Tango::ErrSeverity.ERROR);
	      	read_attribute("attr_no_data") = except("API_AttrValueNotSet",Tango::ErrSeverity.ERROR);
	      	read_attribute("attr_wrong_type") = except("API_AttrOptProp",Tango::ErrSeverity.ERROR);
	      	read_attribute("attr_wrong_size") = except("API_AttrOptProp",Tango::ErrSeverity.ERROR);
	      	read_attribute("attr_no_alarm") = except("API_AttrNoAlarm",Tango::ErrSeverity.ERROR);

//
// Testing SCALAR attribute of type different than READ
// As we have never write any attribute (yet), the write values should all
// be initialised to 0
//

	      	read_attribute("Short_attr_with_w") = attrib(("Short_attr_with_w",0,1,0,44,0));
	      	read_attribute("Short_attr_w") = attrib(("Short_attr_w",0,1,0,0));
	      	read_attribute("Short_attr_rw") = attrib(("Short_attr_rw",0,1,0,66,0));

//
// Test read attribute on write type attribute
//

	      	read_attribute("Short_attr_w") = attrib(("Short_attr_w",0,1,0,0));
	      	read_attribute("Long_attr_w") = attrib(("Long_attr_w",0,1,0,0));
	      	read_attribute("Double_attr_w") = attrib(("Double_attr_w",0,1,0,0));
	      	read_attribute("String_attr_w") = attrib(("String_attr_w",0,1,0,"Not initialised"));

//
// Test alarm on attribute. An alarm is defined for the Long_attr attribute
// is < 1000 and > 1500.
//

		state() = Tango::DevState.ON;
		read_attribute("Long_attr") = attrib(("Long_attr",0,1,0,1246));
		
		command_inout("IOSetAttr",900);
		state() = Tango::DevState.ALARM;
		status() = "Device is ON
Alarm : Value too low for attribute Long_attr";
		command_inout("IOSetAttr",1200);
		state() = Tango::DevState.ALARM;
		status() = "Device is ON";
		command_inout("IOState",Tango::DevState.ON);
		state() = Tango::DevState.ON;
		status() = "Device is ON";
		
		command_inout("IOSetAttr",2000);
		state() = Tango::DevState.ALARM;
		status() = "Device is ON
Alarm : Value too high for attribute Long_attr";
		command_inout("IOSetAttr",1200);
		state() = Tango::DevState.ALARM;
		status() = "Device is ON";
		command_inout("IOState",Tango::DevState.ON);
		state() = Tango::DevState.ON;		
		status() = "Device is ON";
		
		command_inout("IOSetAttr",1246);
																		
		delete();
	}
}
