sequence Attr label "Testing read_attribute features"
{
	cpp trace user manu on device devtestmem
	{
		new ("dev/test/10");

//
// Test one attribute at a time for all SCALAR types
//

	      	read_attribute("Short_attr") = attrib(("Short_attr",0,1,0,12));
	      	read_attribute("Long_attr") = attrib(("Long_attr",0,1,0,1246));
	      	read_attribute("Double_attr") = attrib(("Double_attr",0,1,0,3.2));
	      	read_attribute("String_attr") = attrib(("String_attr",0,1,0,"test_string"));

//
// Test several SCALAR attributes in one call
//

		read_attribute(["String_attr","Double_attr"]) = attrib(
				("String_attr",0,1,0,"test_string")
				("Double_attr",0,1,0,3.2));
		read_attribute(["String_attr","Double_attr","Long_attr","Short_attr"]) = attrib(
				("String_attr",0,1,0,"test_string")
				("Double_attr",0,1,0,3.2)
				("Long_attr",0,1,0,1246)
				("Short_attr",0,1,0,12));
				
//
// Test one attribute at a time for all SPECTRUM types
//

		read_attribute("Short_spec_attr") = attrib(("Short_spec_attr",0,4,0,10,20,30,40));
		read_attribute("Long_spec_attr") = attrib(("Long_spec_attr",0,10,0,0,1,2,3,4,5,6,7,8,9));
		read_attribute("Double_spec_attr") = attrib(("Double_spec_attr",0,2,0,1.11,2.22));
		read_attribute("String_spec_attr") = attrib(("String_spec_attr",0,2,0,"Hello world","Hello universe"));				

//
// Test several SPECTRUM attributes in one call
//

		read_attribute(["String_spec_attr","Double_spec_attr"]) = attrib(
				("String_spec_attr",0,2,0,"Hello world","Hello universe")
				("Double_spec_attr",0,2,0,1.11,2.22));
				
//
// Test one attribute at a time for all IMAGE types
//

		read_attribute("Short_ima_attr") = attrib(("Short_ima_attr",0,2,2,40,60,80,100));
		read_attribute("Long_ima_attr") = attrib(("Long_ima_attr",0,3,2,0,1,2,3,4,5));
		read_attribute("Double_ima_attr") = attrib(("Double_ima_attr",0,2,1,5.55,6.66));
		read_attribute("String_ima_attr") = attrib(("String_ima_attr",0,1,2,"Hello milky way","Hello moon"));

//
// Test one call with all three types
//

		read_attribute(["String_spec_attr","Double_attr","Long_ima_attr"]) = attrib(
				("String_spec_attr",0,2,0,"Hello world","Hello universe")
				("Double_attr",0,1,0,3.2)
				("Long_ima_attr",0,3,2,0,1,2,3,4,5));
																
		delete();
	}
}
