//=============================================================================
//
// file :               coutbuf.h
//
// description :        Include for Windows NT debug output class  
//
// project :            TANGO
//
// author(s) :          A.Gotz + E.Taurel
//
// $Revision: 1.3 $
//
// $Log: coutbuf.h,v $
// Revision 1.3  2001/03/30 08:03:45  taurel
// Fix bugs in attributes. For linux, add signal_handler in its own thread, change the way to kill server. For all system, change DevRestart philosophy.
//
// Revision 1.2  2001/03/09 08:20:15  taurel
// Fix bug in the MultiClassAttribute::init_class_attribute() method. Also remove the DbErr_DeviceNotDefined define.
//
// Revision 1.1.1.1  2001/02/27 08:46:20  taurel
// Imported sources
//
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//=============================================================================

#ifndef _COUTBUF_H
#define _COUTBUF_H

#include <tango.h>
#include <streambuf>

namespace Tango
{

//
//   Some defines
//

#define IDC_LIST        -777
#define MAXLISTLINES    200
#define bufferSize      512



class CoutBuf: public streambuf
{
public:
        CoutBuf(HINSTANCE,int,HWND,LPCSTR);
        virtual ~CoutBuf();
	HWND get_debug_window() {return DbgWin;}
	void clear_debug_window() {DbgWin = NULL;}
	void CreateWin(LPCSTR);
       
protected:

        char buffer[bufferSize];
	long nb_critical;
	HWND DbgWin;
	HWND parent_window;

        int dbg_out(LPCSTR);
        virtual int_type overflow(int_type);
        int flushBuffer();
        virtual int sync();
	virtual streamsize xsputn(const char_type *,streamsize);
};


//
//  Some functions for windows window management!!!
//

LRESULT CALLBACK DebugWndProc(HWND, UINT, WPARAM, LPARAM );
void DrawDebugItem(HWND, LPDRAWITEMSTRUCT );
void MeasureDebugItem(HWND, LPMEASUREITEMSTRUCT);

} // End of Tango namespace

#endif /* _COUTBUF_H */
