static const char *RcsId = "$Header: /segfs/tango/cvsroot/cppserver/device/basiccommand.cpp,v 1.3 2001/03/30 08:03:44 taurel Exp $";

//+============================================================================
//
// file :               BasicCommand.cpp
//
// description :        C++ source code for commands which are automatically
//			installed for every devices
//			Three commands are : 
//				DevState, DevStatus, DevRestart
//
// project :            TANGO
//
// author(s) :          A.Gotz + E.Taurel
//
// $Revision: 1.3 $
//
// $Log: basiccommand.cpp,v $
// Revision 1.3  2001/03/30 08:03:44  taurel
// Fix bugs in attributes. For linux, add signal_handler in its own thread, change the way to kill server. For all system, change DevRestart philosophy.
//
// Revision 1.2  2001/03/09 08:20:14  taurel
// Fix bug in the MultiClassAttribute::init_class_attribute() method. Also remove the DbErr_DeviceNotDefined define.
//
// Revision 1.1.1.1  2001/02/27 08:46:20  taurel
// Imported sources
//
// Revision 1.3  2000/04/13 10:40:39  taurel
// Added attribute support
//
// Revision 1.2  2000/02/04 11:00:12  taurel
// Just update revision number
//
// Revision 1.1.1.1  2000/02/04 10:58:27  taurel
// Imported sources
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//-============================================================================

#include <tango.h>
#include <basiccommand.h>

namespace Tango
{

//+-------------------------------------------------------------------------
//
// method : 		DevStatusCmd::DevStatusCmd 
// 
// description : 	constructor for Command class Status
//
//--------------------------------------------------------------------------

DevStatusCmd::DevStatusCmd(const char *name,Tango::CmdArgType in,Tango::CmdArgType out)
:Command(name,in,out)
{
}


//+-------------------------------------------------------------------------
//
// method : 		DevStatusCmd::execute 
// 
// description : 	return status as string
//
//--------------------------------------------------------------------------

CORBA::Any *DevStatusCmd::execute(DeviceImpl *device, const CORBA::Any &in_any)
{

	cout4 << "DevStatus::execute(): arrived " << endl;

//
// return status string as Any
//

	CORBA::Any *out_any;
	try
	{
		out_any = new CORBA::Any();
	}
	catch (bad_alloc)
	{
		Except::throw_exception((const char *)"API_MemoryAllocation",
				      (const char *)"Can't allocate memory in server",
				      (const char *)"DevStatus::execute");
	}
	
	(*out_any) <<= device->dev_status();
	
	cout4 << "Leaving DevStatus::execute()" << endl;
	return out_any;

}

//+-------------------------------------------------------------------------
//
// method : 		DevStateCmd::DevStateCmd
// 
// description : 	constructor for Command class State
//
//--------------------------------------------------------------------------

DevStateCmd::DevStateCmd(const char *name,Tango::CmdArgType in, Tango::CmdArgType out)
:Command(name,in,out)
{
}

//+-------------------------------------------------------------------------
//
// method : 		StateCmd::execute 
// 
// description : 	return state as enumerated type
//
//--------------------------------------------------------------------------

CORBA::Any *DevStateCmd::execute(DeviceImpl *device, const CORBA::Any &in_any)
{

	cout4 << "DevState::execute(): arrived" << endl;

//
// return state as Any
//

	CORBA::Any *out_any;
	try
	{
		out_any = new CORBA::Any();
	}
	catch (bad_alloc)
	{
		Except::throw_exception((const char *)"API_MemoryAllocation",
				      (const char *)"Can't allocate memory in server",
				      (const char *)"DevStatus::execute");
	}
	(*out_any) <<= device->dev_state();
	
	cout4 << "Leaving DevState::execute()" << endl;
	return out_any;
}

} // End of Tango namespace
