
/*********************************************************************

 File:          dev_tango.c

 Project:       Test Clients for Device Servers

 Description:   A simple program for importing a TANGO device
		from a C program

		Usage : dev_tango [device 1]

 Author:     	A. Goetz

 Original:      November 1999


 *********************************************************************/

#include <tango.h>
#include <API.h>
#include <ApiP.h>
#include "DataBase_cmds.h"
#ifdef linux
#include <iostream>
using namespace std;
#else
#include <iostream.h>
#endif

static char device_name[80];

int main(int argc,char **argv)
{

	short taco_state;
	long id, error,state;
	char *status=NULL, device[32];
	devserver ds_tango;
	DevVarDoubleArray sigvalues;
        DevVarCmdArray varcmdarr; 
	DevOpaque dev_raw;


	if (argc < 2)
	{
		printf("usage: taco-tango device\n");
		exit(-1);
	}
	state = dev_import(argv[1], 0, &ds_tango, &error);
		cout << "main(): dev_import(" << argv[1] << ") returned " << state << " error " << error << endl;

	if (state == DS_OK)
	{
		state = dev_cmd_query(ds_tango,&varcmdarr,&error);
		cout << "main(): dev_cmd_query(" << argv[1] << ") returned " << state << " error " << error << endl;
		if (state == DS_OK)
		{
			for (int j=0; j<varcmdarr.length; j++)
			{
				if (varcmdarr.sequence[j].cmd_name != NULL)
				{
					cout << varcmdarr.sequence[j].cmd_name << " ";
				}
				else
				{
					cout << " ";
				}
				cout <<  varcmdarr.sequence[j].cmd << "  in_type " ;
				cout <<  varcmdarr.sequence[j].in_type << " out_type ";
				cout << varcmdarr.sequence[j].out_type << endl;
			}
		}
	}

	for (;;)
	{
		status = NULL;
		state = dev_putget(ds_tango,DevState,NULL,D_VOID_TYPE,&taco_state,D_SHORT_TYPE,&error);
		cout << "main(): dev_putget(DevState) returned " << state << " error " << error << endl;
		if (state == DS_OK)
		{
			cout << "main(): TACO state = " << taco_state << endl;
//			if (status != NULL) free(status);
		}

/*
		sigvalues.length = 0;
		sigvalues.sequence = NULL;
		state = dev_putget(ds_tango,DevReadSigValues,NULL,D_VOID_TYPE,&sigvalues,D_VAR_DOUBLEARR,&error);
		cout << "main(): dev_putget(DevReadSigValues) returned " << state << " error " << error << endl;
		if (state == DS_OK)
		{
			for (long i=0; i<sigvalues.length; i++)
			{
				cout << "main(): sigvalues[" << i << "] = " << sigvalues.sequence[i] << endl;
			}
		}
		state = dev_putget_raw(ds_tango,DevReadSigValues,NULL,D_VOID_TYPE,&dev_raw,D_VAR_DOUBLEARR,&error);
		cout << "main(): dev_putget_raw(DevReadSigValues) returned " << state << " error " << error << endl;
		if (state == DS_OK) cout << "main(): dev_raw.length " << dev_raw.length << endl;
 */
	sleep(1);
	}
/*
*/
}
