#include <time.h>
#include <signal.h>
#include <tango.h>
#include <assert.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>

static long n_total, n_ok, n_notok;
static long t_min, t_max, t_total;
char *device_name;

void signal_handler(int signal)
{
	long t_avg, error;
/*
 *
 * ----orion.ctrm.esrf.fr PING Statistics----
 * 4 packets transmitted, 4 packets received, 0% packet loss
 * round-trip (ms)  min/avg/max = 0/0/1
 *
 */

	t_avg = t_total / n_total;

	printf("\n----%s DEV_PING Statistics----\n",device_name);
	printf("%d packets transmitted, %d packets successful, %d errors\n",
                n_total, n_ok, n_notok);
	printf("round-trip (ms) min/avg/max = %d/%d/%d\n",t_min,t_avg,t_max);

	exit(0);
}

int main(int argc,char *argv[])
{
	long readwrite = 0, error;
	int i, j, n_devices, status;
	short devstatus;
	struct timeval t1, t2, dev_timeout;
	long elapsed;

        (void) signal(SIGINT,  signal_handler);
	(void) signal(SIGQUIT, signal_handler);
	(void) signal(SIGTERM, signal_handler);


	if (argc != 2) {
		cerr << "Usage : client <device_name>" << endl;
		exit(-1);
	}
	device_name = argv[1];

// Connect to device

        Tango::Device_var db_device;        
	Tango::Device_var dev;
	CORBA::ORB_var orb;
	
	try {
		orb = CORBA::ORB_init(argc,argv);
	
// Read env. variable

                char *env = getenv(EnvVariable);
                string db_host;
                string db_port;

                if (env == NULL)
                {
                        cerr << "TANGO_HOST environment variable not defined, exiting..." << endl;
                        exit(-1);
                }

//
// Check env. variable syntax
//

                string env_str(env);
                string::size_type pos;
                if ((pos = env_str.find(':')) == string::npos)
                {
                        cerr << "Wrong syntax for TANGO_HOST environment variable" << endl;
                        cerr << "Syntax = <host>:<port>" << endl;
                        exit(-1);
                }

//
// Init database host and port variable
//

                db_host.assign(env_str,0,pos);
                if (db_host.size() == 0)
                {
                        cerr << "Wrong syntax for TANGO_HOST environment variable" << endl;
                        cerr << "Syntax = <host>:<port>" << endl;
                        exit(-1);
                }

                strstream s;
                db_port.assign(env_str,pos + 1,env_str.size());
                if (db_port.size() == 0)
                {
                        cerr << "Wrong syntax for TANGO_HOST environment variable" << endl;
                        cerr << "Syntax = <host>:<port>" << endl;
                        exit(-1);
                }
                cout << "Db host = " << db_host << ", Db port = " << db_port << endl;

                CORBA::Object_var obj;
		string db_corbaloc = "corbaloc:iiop:";
		db_corbaloc = db_corbaloc+db_host+":"+db_port+"/"+DbObjName;
                obj = orb->string_to_object(db_corbaloc.c_str());
                assert(!CORBA::is_nil(obj));

                db_device = Tango::Device::_narrow(obj);

                if (CORBA::is_nil(db_device))
                {
                        cerr << "Can't build connection to TANGO database server, exiting" << endl;
                        cerr << "DB server host = " << db_host << endl;
                        exit(-1);
                }
                cout << "Connected to database" << endl;

        }
        catch (CORBA::Exception  &e)
        {
                Tango::Util::print_exception(e);
                exit(-1);
        }

// Connect to device

        try
        {
                CORBA::Any send;
                send <<= argv[1];

                CORBA::Any_var received = db_device->command_inout("DbImportDevice",send);

                const Tango::DevVarLongStringArray *db_dev;
                assert(received >>= db_dev);

                cout << "Device name : " << (db_dev->svalue)[0] << endl;
                cout << "Device IOR : " << (db_dev->svalue)[1] << endl;

                if ((db_dev->lvalue)[0] == 0)
                {
                        cerr << "Device " << argv[1] << " not exported" << endl;
                        exit(-1);
                }
                CORBA::Object_var obj = orb->string_to_object((db_dev->svalue)[1]);

                dev = Tango::Device::_narrow(obj);
        }                                               
        catch (CORBA::Exception  &e)
        {
                Tango::Util::print_exception(e);
                exit(-1);
        }

        if (CORBA::is_nil(dev))
        {
                cerr << "Can't build connection to device server, exiting" << endl;
                exit(-1);
        }
        cout << "Connected to device" << endl;          
	
	n_total = n_ok = n_notok = 0;
	t_max = 0;
	t_min = 0;

	for (j=0; j>-1; j++) 
	{
		gettimeofday(&t1, NULL);
		try 
		{
			dev->ping();
		}
		catch (CORBA::Exception &e) 
		{
			Tango::Util::print_exception(e);
			printf("dev_ping to %s: status=NOTOK sequence=%d time=%d ms\n",argv[1],j,elapsed);
			n_notok++;
		}
		gettimeofday(&t2, NULL);
		elapsed = (t2.tv_sec-t1.tv_sec)*1000000;
		elapsed = (t2.tv_usec-t1.tv_usec) + elapsed;

		n_total++;
		if (t_max == 0) t_max = elapsed;
		if (elapsed > t_max) t_max = elapsed;
		if (t_min == 0) t_min = elapsed;
		if (elapsed < t_min) t_min = elapsed;
		t_total = t_total + elapsed;
		printf("dev_ping to %s: status=OK sequence=%d time=%d us\n",argv[1],j,elapsed);
		n_ok++;
		sleep(1);
	}
}
