#include <tango.h>

#include <assert.h>
#include <iostream.h>
#include <stdio.h>

int main(int argc,char *argv[])
{

	if (argc != 3) {
		cerr << "Usage : client <device_name> <port>" << endl;
		exit(-1);
	}

// Connect to device

	Tango::Device_var dev;
	
	try {
		CORBA::ORB_var orb = CORBA::ORB_init(argc,argv);
	
// Try to connect to server using the get_inet_object call

		CORBA::Object_var obj;
		long port=10000;

		sscanf(argv[2],"%d",&port);
		obj = orb->get_inet_object("tango",port,argv[1]);
		dev = Tango::Device::_narrow(obj);
	}
	catch (CORBA::Exception  &e) {
		Tango::Util::print_exception(e);
		exit(-1);
	}
	
	cout << "Connected to database device" << endl;
		
// Print choice

	while (1) {
		long choice;
		
		cout << endl << "Choose a command" << endl << endl;
		cout << "   0 - Exit menu" << endl;
		cout << "   1 - name (read only attribute)" << endl;
		cout << "   2 - description (read only attribute)" << endl;
		cout << "   3 - state (read only attribute)" << endl;
		cout << "   4 - status (read only attribute)" << endl;
		cout << "   5 - DbGetDeviceList (command_inout)" << endl;
		cout << "   6 - DbGetClassList (command_inout)" << endl;
		cout << "   7 - DbExportDevice (command_inout)" << endl;
		cout << "   8 - DbUnExportDevice (command_inout)" << endl;
		cout << "   9 - DbUnExportServer (command_inout)" << endl;
		cout << "  10 - DbImportDevice (command_inout)" << endl;
		cout << "  11 - DbGetDeviceProperty (command_inout)" << endl;
		cout << "  12 - DbPutDeviceProperty (command_inout)" << endl;
		cout << "  13 - DbInfo (command_inout)" << endl;
		
		cout << endl << "Your choice : ";
		cin >> choice;
		
		switch (choice) {
			
//
// Get the name attribute
//

			case 1 :
				try {
					CORBA::String_var n = dev->name();
					cout << "Received name : " << n << endl;
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
				
//
// Get the description attribute
//
				
			case 2 :
				try {
					CORBA::String_var d = dev->description();
					cout << "Received description : " << d << endl;
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;

//
// Get the state attribute
//
				
			case 3 :
				try {
					Tango::DevState d = dev->state();
					cout << "Received state : " << d << endl;
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;

//
// Get the status attribute
//
				
			case 4 :
				try {
					CORBA::String_var d = dev->status();
					cout << "Received status : " << d << endl;
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
				
//
// Execute the DbGetDeviceList command
//
				
			case 5 :
				try {
					int j;
					for (j=0; j<10000; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						Tango::DevVarStringArray *server_class = new Tango::DevVarStringArray;
						server_class->append(CORBA::string_dup("StepperMotor/dd"));
						server_class->append(CORBA::string_dup("StepperMotor"));
						send <<= server_class;
								
						CORBA::Any_var received = dev->command_inout("DbGetDeviceList",send);
						Tango::DevVarStringArray *device_list;
						assert(received >>= device_list);
						
						int i;	
						for (i=0; i<device_list->length(); i++) {
							cout << "Device " << i << " name " << (*device_list)[i] << endl;
						}
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbGetClassList command
//
				
			case 6 :
				try {
					int j;
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
 						char *server_name = CORBA::string_dup("steppermotor/dd");;
                                                send <<= server_name; 
								
						CORBA::Any_var received = dev->command_inout("DbGetClassList",send);
						Tango::DevVarStringArray *class_list;
						assert(received >>= class_list);
						
						int i;	
						for (i=0; i<class_list->length(); i++) {
							cout << "Class " << i << " name " << (*class_list)[i] << endl;
						}
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbExportDevice command
//
				
			case 7 :
				try {
					int j;
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						Tango::DevVarStringArray *export_info = new Tango::DevVarStringArray;
						export_info->append(CORBA::string_dup("id00/motor/01"));
						export_info->append(CORBA::string_dup("ior"));
						export_info->append(CORBA::string_dup("localhost"));
						export_info->append(CORBA::string_dup("1"));
						export_info->append(CORBA::string_dup("0"));
						send <<= export_info;
								
						CORBA::Any_var received = dev->command_inout("DbExportDevice",send);
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbUnExportDevice command
//
				
			case 8 :
				try {
					int j;
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						char *device_name = CORBA::string_dup("id00/motor/01");;
						send <<= device_name;
								
						CORBA::Any_var received = dev->command_inout("DbUnExportDevice",send);
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbUnExportServer command
//
				
			case 9 :
				try {
					int j;
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						char *server_name = CORBA::string_dup("StepperMotor/dd");;
						send <<= server_name;
								
						CORBA::Any_var received = dev->command_inout("DbUnExportServer",send);
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbImportDevice command
//
				
			case 10 :
				try {
					int j;
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						char *device_name = CORBA::string_dup("id00/motor/01");;
						send <<= device_name;
								
						CORBA::Any_var received = dev->command_inout("DbImportDevice",send);
						Tango::DevVarLongStringArray *import_info;
						assert(received >>= import_info);
						
						cout << "Device import info " << " version " << (import_info->svalue)[2] << " IOR " << (import_info->svalue)[1] << endl;
						cout << "Device exported " << (import_info->lvalue)[0] << endl;
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Execute the DbGetDeviceProperty command
//
			case 11 :
				try {
					int j;
					char *d_name="id00/motor/01", *r_name="position";
					for (j=0; j<10; j++) {
						cout << endl << "loop " << j << endl;
						CORBA::Any send;
						Tango::DevVarStringArray *property_names = new Tango::DevVarStringArray;
						property_names->append(CORBA::string_dup(d_name));
						property_names->append(CORBA::string_dup(r_name));
						property_names->append(CORBA::string_dup("dummy"));
						send <<= property_names;
								
						CORBA::Any_var received = dev->command_inout("DbGetDeviceProperty",send);
						Tango::DevVarStringArray *property_list;
						assert(received >>= property_list);
						
						int i;	
						cout << endl << "device name " << (*property_list)[0] << " number " << (*property_list)[1] << endl << endl;
						for (i=2; i<property_list->length(); i++) {
							cout << (*property_list)[i] << endl;
						 }
					 }
				 }
				 catch (CORBA::Exception &e) {
					 Tango::Util::print_exception(e);
				 }
				 break;
				
				 //
// Execute the DbPutDeviceProperty command
//
			case 12 :
				try {
					int j;
					char *d_name="id00/motor/01", *r_name="position", *count[8] = {"1","2","3","4","5","6","7","8"}, value[8][16];
					for (j=0; j<10; j++) {
						cout << "loop " << j << endl;
						CORBA::Any send;
						Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
						property_list->append(CORBA::string_dup(d_name));
						property_list->append(CORBA::string_dup("1"));
						property_list->append(CORBA::string_dup(r_name));
						property_list->append(CORBA::string_dup("8"));
						int k;
						for (k=0; k<8; k++) {
							sprintf(value[k],"%d",k);
							property_list->append(CORBA::string_dup(value[k]));
						}
						send <<= property_list;
								
						CORBA::Any_var received = dev->command_inout("DbPutDeviceProperty",send);
					 }
				 }
				 catch (CORBA::Exception &e) {
					 Tango::Util::print_exception(e);
				 }
				 break;
				
//
// Execute the DbInfo command
//
				
			case 13 :
				try {
					CORBA::Any send;
							
					CORBA::Any_var received = dev->command_inout("DbInfo",send);
					Tango::DevVarStringArray *info_list;
					assert(received >>= info_list);
						
					cout << endl;
					int i;	
					for (i=0; i<info_list->length(); i++) {
						cout << (*info_list)[i] << endl;
					}
				}
				catch (CORBA::Exception &e) {
					Tango::Util::print_exception(e);
				}
				break;
//
// Exit menu
//
																
			case 0 :
				exit(0);
				break;
				
			default :
				cout << "Unknown choice !! " << endl;
				break;
		}
	}
}
