//=============================================================================
//
// file :         DataBaseClass.h
//
// description :  Include for the DataBaseClass root class.
//                This class is represents the singleton class for
//                the DataBase device class.
//                It contains all properties and methods which the 
//                DataBase requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: goetz $
//
// $Revision: 2.6 $
//
// $Log: DataBaseClass.h,v $
// Revision 2.6  2001/03/22 12:56:52  goetz
// fixed bug in DbAddDevice command, device name now unique in device table
//
// Revision 2.5  2001/03/06 12:05:44  goetz
// added DbGetDeviceExportedList; DbExportDevice updates host info in server table
//
// Revision 2.4  2001/03/06 11:01:56  goetz
// added DbGetDeviceExportedList command; DbExportDevice updates host in server table
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================

#ifndef _DATABASECLASS_H
#define _DATABASECLASS_H

#include <tango.h>

namespace DataBase {
//
// Define classes for commands
//
class DbGetDeviceExportedListCmd : public Tango::Command
{
public:
	DbGetDeviceExportedListCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceExportedListCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceExportedListCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteServerInfoCmd : public Tango::Command
{
public:
	DbDeleteServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteServerInfoCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutServerInfoCmd : public Tango::Command
{
public:
	DbPutServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutServerInfoCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetServerInfoCmd : public Tango::Command
{
public:
	DbGetServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetServerInfoCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetServerInfoCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteDeviceAttributePropertyCmd : public Tango::Command
{
public:
	DbDeleteDeviceAttributePropertyCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteDeviceAttributePropertyCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteDeviceAttributePropertyCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteDeviceAttributeCmd : public Tango::Command
{
public:
	DbDeleteDeviceAttributeCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteDeviceAttributeCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteDeviceAttributeCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteServerCmd : public Tango::Command
{
public:
	DbDeleteServerCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteServerCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteServerCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteDeviceCmd : public Tango::Command
{
public:
	DbDeleteDeviceCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteDeviceCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteDeviceCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceAttributeList : public Tango::Command
{
public:
	DbGetDeviceAttributeList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceAttributeList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceAttributeList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetClassAttributeList : public Tango::Command
{
public:
	DbGetClassAttributeList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetClassAttributeList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetClassAttributeList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbAddDevice : public Tango::Command
{
public:
	DbAddDevice(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbAddDevice(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbAddDevice() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbAddServer : public Tango::Command
{
public:
	DbAddServer(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbAddServer(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbAddServer() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbUnExportServer : public Tango::Command
{
public:
	DbUnExportServer(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbUnExportServer(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbUnExportServer() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbUnExportDevice : public Tango::Command
{
public:
	DbUnExportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbUnExportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbUnExportDevice() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbImportDevice : public Tango::Command
{
public:
	DbImportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbImportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbImportDevice() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbExportDevice : public Tango::Command
{
public:
	DbExportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbExportDevice(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbExportDevice() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteClassProperty : public Tango::Command
{
public:
	DbDeleteClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteClassProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutClassProperty : public Tango::Command
{
public:
	DbPutClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutClassProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetClassProperty : public Tango::Command
{
public:
	DbGetClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetClassProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetClassProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutClassAttributeProperty : public Tango::Command
{
public:
	DbPutClassAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutClassAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutClassAttributeProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetClassAttributeProperty : public Tango::Command
{
public:
	DbGetClassAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetClassAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetClassAttributeProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutDeviceAttributeProperty : public Tango::Command
{
public:
	DbPutDeviceAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutDeviceAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutDeviceAttributeProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceAttributeProperty : public Tango::Command
{
public:
	DbGetDeviceAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceAttributeProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceAttributeProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteDeviceProperty : public Tango::Command
{
public:
	DbDeleteDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteDeviceProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutDeviceProperty : public Tango::Command
{
public:
	DbPutDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutDeviceProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceProperty : public Tango::Command
{
public:
	DbGetDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceClassList : public Tango::Command
{
public:
	DbGetDeviceClassList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceClassList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceClassList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetClassList : public Tango::Command
{
public:
	DbGetClassList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetClassList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetClassList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceList : public Tango::Command
{
public:
	DbGetDeviceList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbInfo : public Tango::Command
{
public:
	DbInfo(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbInfo(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbInfo() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceDomainList : public Tango::Command
{
public:
	DbGetDeviceDomainList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceDomainList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceDomainList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceFamilyList : public Tango::Command
{
public:
	DbGetDeviceFamilyList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceFamilyList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceFamilyList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceMemberList : public Tango::Command
{
public:
	DbGetDeviceMemberList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceMemberList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceMemberList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDeviceAliasList : public Tango::Command
{
public:
	DbGetDeviceAliasList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDeviceAliasList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDeviceAliasList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetDevicePropertyList : public Tango::Command
{
public:
	DbGetDevicePropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetDevicePropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetDevicePropertyList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetClassPropertyList : public Tango::Command
{
public:
	DbGetClassPropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetClassPropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetClassPropertyList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetServerList : public Tango::Command
{
public:
	DbGetServerList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetServerList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetServerList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetHostList : public Tango::Command
{
public:
	DbGetHostList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetHostList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetHostList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetHostServerList : public Tango::Command
{
public:
	DbGetHostServerList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetHostServerList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetHostServerList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbDeleteProperty : public Tango::Command
{
public:
	DbDeleteProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbDeleteProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbDeleteProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbPutProperty : public Tango::Command
{
public:
	DbPutProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbPutProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbPutProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetProperty : public Tango::Command
{
public:
	DbGetProperty(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetProperty(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetProperty() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class DbGetPropertyList : public Tango::Command
{
public:
	DbGetPropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DbGetPropertyList(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DbGetPropertyList() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};



//
// The DataBaseClass singleton definition
//

class DataBaseClass : public Tango::DeviceClass
{
public:
	static DataBaseClass *init(const char *);
	static DataBaseClass *instance();
	~DataBaseClass() {_instance = NULL;}
	
protected:
	DataBaseClass(string &);
	static DataBaseClass *_instance;
	void command_factory();

private:
	void device_factory(const Tango::DevVarStringArray *);
};
}
#endif // _DATABASECLASS_H
