static const char *RcsId = "$Header: /segfs/tango/cvsroot/cppserver/dbase/DataBaseClass.cpp,v 2.6 2001/03/22 12:56:52 goetz Exp $";
//+=============================================================================
//
// file :        DataBaseClass.cpp
//
// description : C++ source for the DataBaseClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the DataBase once per process.
//
// project :     TANGO Device Server
//
// author(s) :   A.Gotz
//
// $Version$
//
// $Log: DataBaseClass.cpp,v $
// Revision 2.6  2001/03/22 12:56:52  goetz
// fixed bug in DbAddDevice command, device name now unique in device table
//
// Revision 2.5  2001/03/06 12:05:44  goetz
// added DbGetDeviceExportedList; DbExportDevice updates host info in server table
//
// Revision 2.4  2001/03/06 11:01:56  goetz
// added DbGetDeviceExportedList command; DbExportDevice updates host in server table
//
// Revision 2.3  2001/03/05 12:10:53  goetz
// checking in before going to add new command(s)
//
// Revision 2.2  2001/01/03 11:58:29  goetz
// E.Taurel modified version for new TACO exception class
//
// Revision 2.1  2000/11/02 14:35:23  goetz
// added commands for server info
//
// Revision 2.0  2000/10/19 07:31:08  goetz
// changed major version number to 2
//
// Revision 1.16  2000/10/19 07:30:28  goetz
// ported Database to TANGO V2.0
//
// Revision 1.15  2000/10/02 08:37:16  goetz
// going to port to TANGO V2 i.e. OB V4
//
// Revision 1.14  2000/07/31 07:55:51  goetz
// added commands DbDeleteDevice and DbDeleteServer
//
// Revision 1.13  2000/07/29 13:33:04  goetz
// added commands DbDeleteDevice and DbDeleteServer, bug fixes
//
// Revision 1.12  2000/07/27 13:36:17  goetz
// checking in before going to add new commands with pogo
//
// Revision 1.11  2000/06/29 11:38:26  goetz
// intermediate checkin
//
// Revision 1.10  2000/06/06 11:04:56  goetz
// added DbGetDeviceAttributeList; modified DbGetDevicePropertyList; migrated to pogo
//
// Revision 1.8  2000/05/25 08:32:06  goetz
// added browsing commands for Jive browser
//
// Revision 1.7  2000/05/17 14:41:24  goetz
// get domain, family and member commands converted to use database columns
//
// Revision 1.6  2000/05/16 11:47:09  goetz
// added get commands for alias, domain, family + member
//
// Revision 1.5  2000/03/13 17:36:44  goetz
// fixed bugs in Device Attirbute Properties commands
//
// Revision 1.4  2000/02/16 14:12:51  goetz
// added file DataBase.pogo
//
// Revision 1.3  2000/02/16 14:12:03  goetz
// converted DataBaseds to POGO
//
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-=============================================================================
//
//  This file was generated by POGO
//
//                     (c) - Pascal Verdier - ESRF
//
//=============================================================================


#include <tango.h>

#include <DataBase.h>
#include <DataBaseClass.h>

namespace DataBase {

//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceExportedListCmd::DbGetDeviceExportedListCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceExportedListCmd::DbGetDeviceExportedListCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceExportedListCmd::DbGetDeviceExportedListCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceExportedListCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceExportedListCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceExportedListCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceExportedListCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DbGetDeviceExportedListCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_exported_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerInfoCmd::DbDeleteServerInfoCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteServerInfoCmd::DbDeleteServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteServerInfoCmd::DbDeleteServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerInfoCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteServerInfoCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerInfoCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteServerInfoCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_server_info(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbPutServerInfoCmd::DbPutServerInfoCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutServerInfoCmd::DbPutServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutServerInfoCmd::DbPutServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutServerInfoCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutServerInfoCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutServerInfoCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutServerInfoCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_server_info(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetServerInfoCmd::DbGetServerInfoCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetServerInfoCmd::DbGetServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetServerInfoCmd::DbGetServerInfoCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetServerInfoCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetServerInfoCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetServerInfoCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetServerInfoCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->dev_get_server_info(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributePropertyCmd::DbDeleteDeviceAttributePropertyCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteDeviceAttributePropertyCmd::DbDeleteDeviceAttributePropertyCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteDeviceAttributePropertyCmd::DbDeleteDeviceAttributePropertyCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributePropertyCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteDeviceAttributePropertyCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributePropertyCmd::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributePropertyCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_device_attribute_property(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributeCmd::DbDeleteDeviceAttributeCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteDeviceAttributeCmd::DbDeleteDeviceAttributeCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteDeviceAttributeCmd::DbDeleteDeviceAttributeCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributeCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteDeviceAttributeCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceAttributeCmd::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteDeviceAttributeCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_device_attribute(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerCmd::DbDeleteServerCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteServerCmd::DbDeleteServerCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteServerCmd::DbDeleteServerCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteServerCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteServerCmd::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteServerCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_server(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceCmd::DbDeleteDeviceCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteDeviceCmd::DbDeleteDeviceCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteDeviceCmd::DbDeleteDeviceCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteDeviceCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceCmd::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteDeviceCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_device(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeList::DbGetDeviceAttributeList()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceAttributeList::DbGetDeviceAttributeList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceAttributeList::DbGetDeviceAttributeList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceAttributeList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetPropertyList::DbGetPropertyList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetPropertyList::DbGetPropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetPropertyList::DbGetPropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetPropertyList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetPropertyList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetPropertyList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetPropertyList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_property_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetProperty::DbGetProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetProperty::DbGetProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetProperty::DbGetProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_property(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbPutProperty::DbPutProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutProperty::DbPutProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutProperty::DbPutProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_property(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbDeleteProperty::DbDeleteProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteProperty::DbDeleteProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteProperty::DbDeleteProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_property(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetHostServerList::DbGetHostServerList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetHostServerList::DbGetHostServerList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetHostServerList::DbGetHostServerList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetHostServerList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetHostServerList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetHostServerList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetHostServerList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_host_server_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetHostList::DbGetHostList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetHostList::DbGetHostList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetHostList::DbGetHostList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetHostList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetHostList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetHostList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetHostList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_host_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetServerList::DbGetServerList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetServerList::DbGetServerList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetServerList::DbGetServerList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetServerList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetServerList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetServerList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetServerList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_server_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetClassPropertyList::DbGetClassPropertyList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetClassPropertyList::DbGetClassPropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetClassPropertyList::DbGetClassPropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassPropertyList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetClassPropertyList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassPropertyList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetClassPropertyList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_class_property_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetDevicePropertyList::DbGetDevicePropertyList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDevicePropertyList::DbGetDevicePropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDevicePropertyList::DbGetDevicePropertyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDevicePropertyList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDevicePropertyList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDevicePropertyList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDevicePropertyList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_property_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAliasList::DbGetDeviceAliasList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceAliasList::DbGetDeviceAliasList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceAliasList::DbGetDeviceAliasList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAliasList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceAliasList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAliasList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceAliasList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_alias_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceMemberList::DbGetDeviceMemberList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceMemberList::DbGetDeviceMemberList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceMemberList::DbGetDeviceMemberList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDomainMemberList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceMemberList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceMemberList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceMemberList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_member_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceFamilyList::DbGetDeviceFamilyList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceFamilyList::DbGetDeviceFamilyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceFamilyList::DbGetDeviceFamilyList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDomainFamilyList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceFamilyList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceFamilyList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceFamilyList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_family_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceDomainList::DbGetDeviceDomainList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceDomainList::DbGetDeviceDomainList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceDomainList::DbGetDeviceDomainList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceDomainList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceDomainList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceDomainList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_domain_list(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DbInfo::DbInfo()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbInfo::DbInfo(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbInfo::DbInfo(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbInfo::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbInfo::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbInfo::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbInfo::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	return insert((static_cast<DataBase *>(device))->db_info());
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceList::DbGetDeviceList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceList::DbGetDeviceList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceList::DbGetDeviceList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_list(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetClassList::DbGetClassList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetClassList::DbGetClassList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetClassList::DbGetClassList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetClassList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetClassList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_class_list(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceClassList::DbGetDeviceClassList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceClassList::DbGetDeviceClassList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceClassList::DbGetDeviceClassList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceClassList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceClassList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceClassList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceClassList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_class_list(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceProperty::DbGetDeviceProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceProperty::DbGetDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceProperty::DbGetDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_property(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceProperty::DbPutDeviceProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutDeviceProperty::DbPutDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutDeviceProperty::DbPutDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutDeviceProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutDeviceProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_device_property(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceProperty::DbDeleteDeviceProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteDeviceProperty::DbDeleteDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteDeviceProperty::DbDeleteDeviceProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteDeviceProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteDeviceProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteDeviceProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_device_property(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeProperty::DbGetDeviceAttributeProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetDeviceAttributeProperty::DbGetDeviceAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetDeviceAttributeProperty::DbGetDeviceAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetDeviceAttributeProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetDeviceAttributeProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetDeviceAttributeProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_device_attribute_property(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceAttributeProperty::DbPutDeviceAttributeProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutDeviceAttributeProperty::DbPutDeviceAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutDeviceAttributeProperty::DbPutDeviceAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceAttributeProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutDeviceAttributeProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutDeviceAttributeProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutDeviceAttributeProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_device_attribute_property(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeProperty::DbGetClassAttributeProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetClassAttributeProperty::DbGetClassAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetClassAttributeProperty::DbGetClassAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetClassAttributeProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetClassAttributeProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_property(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbPutClassAttributeProperty::DbPutClassAttributeProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutClassAttributeProperty::DbPutClassAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutClassAttributeProperty::DbPutClassAttributeProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutClassAttributeProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutClassAttributeProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutClassAttributeProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutClassAttributeProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_class_attribute_property(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeList::DbGetClassAttributeList()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetClassAttributeList::DbGetClassAttributeList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetClassAttributeList::DbGetClassAttributeList(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeList::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetClassAttributeList::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassAttributeList::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetClassAttributeList::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_class_attribute_list(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbGetClassProperty::DbGetClassProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbGetClassProperty::DbGetClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbGetClassProperty::DbGetClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbGetClassProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbGetClassProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbGetClassProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_get_class_property(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbPutClassProperty::DbPutClassProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbPutClassProperty::DbPutClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbPutClassProperty::DbPutClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutClassProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbPutClassProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbPutClassProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbPutClassProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_put_class_property(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DbDeleteClassProperty::DbDeleteClassProperty()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbDeleteClassProperty::DbDeleteClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbDeleteClassProperty::DbDeleteClassProperty(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteClassProperty::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbDeleteClassProperty::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbDeleteClassProperty::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbDeleteClassProperty::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_delete_class_property(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbExportDevice::DbExportDevice()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbExportDevice::DbExportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbExportDevice::DbExportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbExportDevice::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbExportDevice::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbExportDevice::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbExportDevice::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_export_device(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbImportDevice::DbImportDevice()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbImportDevice::DbImportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbImportDevice::DbImportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbImportDevice::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbImportDevice::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbImportDevice::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbImportDevice::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<DataBase *>(device))->db_import_device(argin));
}


//+----------------------------------------------------------------------------
//
// method : 		DbUnExportDevice::DbUnExportDevice()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbUnExportDevice::DbUnExportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbUnExportDevice::DbUnExportDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbUnExportDevice::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbUnExportDevice::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbUnExportDevice::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbUnExportDevice::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_un_export_device(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbUnExportServer::DbUnExportServer()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbUnExportServer::DbUnExportServer(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbUnExportServer::DbUnExportServer(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbUnExportServer::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbUnExportServer::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbUnExportServer::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbUnExportServer::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_un_export_server(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbAddServer::DbAddServer()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbAddServer::DbAddServer(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbAddServer::DbAddServer(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbAddServer::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbAddServer::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbAddServer::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbAddServer::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_add_server(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		DbAddDevice::DbAddDevice()
// 
// description : 	constructor for the command of the DataBase.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DbAddDevice::DbAddDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DbAddDevice::DbAddDevice(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}




//+----------------------------------------------------------------------------
//
// method : 		DbAddDevice::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DbAddDevice::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return true;
}




//+----------------------------------------------------------------------------
//
// method : 		DbAddDevice::execute()
// 
// description : 	method to trigger the execution of the command
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DbAddDevice::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<DataBase *>(device))->db_add_device(argin));
	return new CORBA::Any();
}





//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
DataBaseClass *DataBaseClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		DataBaseClass::DataBaseClass(string &s)
// 
// description : 	constructor for the DataBaseClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
DataBaseClass::DataBaseClass(string &s):DeviceClass(s)
{

	cout2 << "Entering DataBaseClass constructor" << endl;
	
	cout2 << "Leaving DataBaseClass constructor" << endl;

}

//+----------------------------------------------------------------------------
//
// method : 		DataBaseClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
DataBaseClass *DataBaseClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new DataBaseClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

DataBaseClass *DataBaseClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		DataBaseClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------

void DataBaseClass::command_factory()
{
	command_list.push_back(new DbGetPropertyList("DbGetPropertyList",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetProperty("DbGetProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbPutProperty("DbPutProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbDeleteProperty("DbDeleteProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbGetHostServerList("DbGetHostServerList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetHostList("DbGetHostList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetServerList("DbGetServerList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetClassPropertyList("DbGetClassPropertyList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDevicePropertyList("DbGetDevicePropertyList",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceAliasList("DbGetDeviceAliasList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceMemberList("DbGetDeviceMemberList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceFamilyList("DbGetDeviceFamilyList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceDomainList("DbGetDeviceDomainList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbInfo("DbInfo",
		Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceList("DbGetDeviceList",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetClassList("DbGetClassList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceClassList("DbGetDeviceClassList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceProperty("DbGetDeviceProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbPutDeviceProperty("DbPutDeviceProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbDeleteDeviceProperty("DbDeleteDeviceProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbGetDeviceAttributeProperty("DbGetDeviceAttributeProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbPutDeviceAttributeProperty("DbPutDeviceAttributeProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbGetClassAttributeProperty("DbGetClassAttributeProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbPutClassAttributeProperty("DbPutClassAttributeProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbGetClassProperty("DbGetClassProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbPutClassProperty("DbPutClassProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbDeleteClassProperty("DbDeleteClassProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbExportDevice("DbExportDevice",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbImportDevice("DbImportDevice",
		Tango::DEV_STRING, Tango::DEVVAR_LONGSTRINGARRAY,
		"",
		""));
	command_list.push_back(new DbUnExportDevice("DbUnExportDevice",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbUnExportServer("DbUnExportServer",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbAddServer("DbAddServer",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbAddDevice("DbAddDevice",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"",
		""));
	command_list.push_back(new DbGetClassAttributeList("DbGetClassAttributeList",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"",
		""));
	command_list.push_back(new DbGetDeviceAttributeList("DbGetDeviceAttributeList",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"device name",
		"attribute wildcard"));
	command_list.push_back(new DbDeleteDeviceCmd("DbDeleteDevice",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"device name",
		""));
	command_list.push_back(new DbDeleteServerCmd("DbDeleteServer",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"server name",
		""));
	command_list.push_back(new DbDeleteDeviceAttributeCmd("DbDeleteDeviceAttribute",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"device, attribute",
		""));
	command_list.push_back(new DbDeleteDeviceAttributePropertyCmd("DbDeleteDeviceAttributeProperty",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"device, attribute, property",
		""));
	command_list.push_back(new DbGetServerInfoCmd("DbGetServerInfo",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"server name",
		"server info"));
	command_list.push_back(new DbPutServerInfoCmd("DbPutServerInfo",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"server info",
		""));
	command_list.push_back(new DbDeleteServerInfoCmd("DbDeleteServerInfo",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"server name",
		""));
	command_list.push_back(new DbGetDeviceExportedListCmd("DbGetDeviceExportedList",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"filter",
		"list of exported devices"));
}


//+----------------------------------------------------------------------------
//
// method : 		DataBaseClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------

void DataBaseClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{
	
	for (long i = 0;i < devlist_ptr->length();i++)
	{
        	cout << "DataBaseClass::DataBaseClass(): create database device " << DataBase::db_name.c_str() << endl;
        	device_list.push_back(new DataBase(this, DataBase::db_name.c_str(),
                                           "TANGO database device server"));

		//cout4 << "Device name : " << (*devlist_ptr)[i] << endl;
						
		// Export device to the outside world
		//----------------------------------------------------

		export_device(device_list[0],"database");
	}
}

//+----------------------------------------------------------------------------
//
// method :             DeviceClass::create_poa()
//
// description :        Method to create the POA for the Tango database
//                      class. The POA policies are PERSISTANT, USER_ID,
//                      UNIQUE_ID, IMPLICIT_ACTIVATION, USE_ACTIVE_OBJECT_MAP_ONLY,
//                      RETAIN and ORB_CTRL_MODEL. 
//
//-----------------------------------------------------------------------------

/*void DataBaseClass::create_poa()
{	
//
// Retrieve root poa
//

        Tango::Util *tg = Tango::Util::instance();
        PortableServer::POA_var root_poa = tg->get_root_poa();

//
// Build poa name
//

        string poa_name = name;
        poa_name = poa_name + "POA";

//
// Create non default policy
//

        CORBA::PolicyList policies;
        policies.length(2);
        policies[0] = root_poa->create_id_assignment_policy(PortableServer::USER_ID);
        policies[1] = root_poa->create_lifespan_policy(PortableServer::PERSISTENT);

//
// Create poa
//

        try
        {
/*                poa = root_poa->create_POA(poa_name.c_str(),
                                           PortableServer::POAManager::_nil(),
                                           policies);*/
/*                  poa = root_poa->create_POA(poa_name.c_str(),
                                           root_poa->the_POAManager(),
                                           policies);
	}
        catch (const PortableServer::POA::AdapterAlreadyExists &)
        {
                TangoSys_OMemStream o;
                o << "Can't create POA for class " << name << ". It already exists." << ends;
                Tango::Util::throw_exception(o.str(),(const char *)"DeviceClass::create_poa",
                                       DevErr_CantCreateClassPoa,Tango::APILIB);
        }
        catch (const PortableServer::POA::InvalidPolicy &)
        {
                TangoSys_OMemStream o;
                o << "Can't create POA for class " << name << ". CORBA policy(ies) invalid." << ends;
                Tango::Util::throw_exception(o.str(),(const char *)"DeviceClass::create_poa",
                                       DevErr_CantCreateClassPoa,Tango::APILIB);
        }

        assert (!CORBA::is_nil(poa));

//
// Store the POA manager
//

        poa_manager = poa->the_POAManager();
	
//
// Activate the manager
//

	poa_manager->activate();
	
}*/
}
