//=============================================================================
//
// file :        DataBase.h
//
// description : Include for the DataBase class.
//
// project :	TANGO
//
// $Author: goetz $
//
// $Version$
//
// $Log: DataBase.h,v $
// Revision 2.6  2001/03/22 12:56:52  goetz
// fixed bug in DbAddDevice command, device name now unique in device table
//
// Revision 2.5  2001/03/06 12:05:44  goetz
// added DbGetDeviceExportedList; DbExportDevice updates host info in server table
//
// Revision 2.4  2001/03/06 11:01:55  goetz
// added DbGetDeviceExportedList command; DbExportDevice updates host in server table
//
// Revision 2.3  2001/03/05 12:10:52  goetz
// checking in before going to add new command(s)
//
// Revision 2.2  2001/01/03 11:58:28  goetz
// E.Taurel modified version for new TACO exception class
//
// Revision 2.1  2000/11/02 14:35:23  goetz
// added commands for server info
//
// Revision 2.0  2000/10/19 07:31:08  goetz
// changed major version number to 2
//
// Revision 1.16  2000/10/19 07:30:27  goetz
// ported Database to TANGO V2.0
//
// Revision 1.15  2000/10/02 08:37:16  goetz
// going to port to TANGO V2 i.e. OB V4
//
// Revision 1.14  2000/07/31 07:55:51  goetz
// added commands DbDeleteDevice and DbDeleteServer
//
// Revision 1.13  2000/07/29 13:33:04  goetz
// added commands DbDeleteDevice and DbDeleteServer, bug fixes
//
// Revision 1.12  2000/07/27 13:36:17  goetz
// checking in before going to add new commands with pogo
//
// Revision 1.11  2000/06/29 11:38:25  goetz
// intermediate checkin
//
// Revision 1.10  2000/06/06 11:04:56  goetz
// added DbGetDeviceTango::AttributeList; modified DbGetDevicePropertyList; migrated to pogo
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================
#ifndef _DATABASE_H
#define _DATABASE_H

#include <tango.h>
#include <mysql.h>

namespace DataBase {

/**
 * @author	$Author: goetz $
 * @version	$Revision: 2.6 $
 */

/**
 * Class Description:
 * 
 */

/*
 *	Device States Description:
 */


class DataBase: public Tango::DeviceImpl
{
public :
	//	Add your own data members here
	//-----------------------------------------
	static string DataBase::db_name; // current incarnation of database


	//	Here is the Start of the automatic code generation part
	//-------------------------------------------------------------	
/**
 *	@name attributes
 *	Tango::Attributs menmber data.
 */
//@{
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	DataBase(Tango::DeviceClass *,string &);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	DataBase(Tango::DeviceClass *,const char *);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	DataBase(Tango::DeviceClass *,const char *,const char *);
//@}

/**@name Destructor
 * Only one desctructor is defined for this class */
//@{
/**
 * The object desctructor.
 */	
	~DataBase() {};
//@}

	
/**@name Miscellaneous methods */
//@{
/**
 *	Initialize the device
 */
	virtual void init_device();
/**
 *	Read The devive state.
 *	<Br>Command DevState 
 *
 * @return the device state read.
 */
	virtual Tango::DevState dev_state();
/**
 *	Read The devive status.
 *	<Br>Command DevStatus
 *
 * @return A String containing the device state read.
 */
	virtual const char* dev_status();
/**
 *	Always executed method befor execution command method.
 */
	virtual void always_executed_hook();

//@}

/**
 * @name DataBase methods prototypes
 */

//@{
/**
 * DataBase methods prototypes
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_property_list(const Tango::DevVarStringArray *);
/**
 * DataBase methods prototypes
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_put_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_delete_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_host_server_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_host_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_server_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_class_property_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_property_list(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_alias_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_member_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_family_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_domain_list(Tango::DevString);
/**
 * 
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_info();
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_list(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_class_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_class_list(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_put_device_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_delete_device_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_attribute_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_put_device_attribute_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_class_attribute_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_put_class_attribute_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_class_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_put_class_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_delete_class_property(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_export_device(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarLongStringArray	*db_import_device(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_un_export_device(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_un_export_server(Tango::DevString);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_add_server(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@exception DevFailed
 */
	void	db_add_device(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	
 *	@return	
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_class_attribute_list(const Tango::DevVarStringArray *);
/**
 * return list of attributes for device which match the
 *	wildcard
 *	@param	argin	device name
 *	@return	attribute wildcard
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_attribute_list(const Tango::DevVarStringArray *);
/**
 * 
 *	@param	argin	device name
 *	@exception DevFailed
 */
	void	db_delete_device(Tango::DevString);
/**
 * delete server from the database, do not delete device properties
 *	@param	argin	server name
 *	@exception DevFailed
 */
	void	db_delete_server(Tango::DevString);
/**
 * delete a device attribute and all its properties from
 *	the database
 *	@param	argin	device, attribute
 *	@exception DevFailed
 */
	void	db_delete_device_attribute(const Tango::DevVarStringArray *);
/**
 * delete a device attribute property from the database
 *	@param	argin	device, attribute, property
 *	@exception DevFailed
 */
	void	db_delete_device_attribute_property(const Tango::DevVarStringArray *);
/**
 * return info about host, mode and level for specified server
 *	@param	argin	server name
 *	@return	server info
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*dev_get_server_info(Tango::DevString);
/**
 * update server info including host, mode and level
 *	@param	argin	server info
 *	@exception DevFailed
 */
	void	db_put_server_info(const Tango::DevVarStringArray *);
/**
 * delete info related to a server
 *	@param	argin	server name
 *	@exception DevFailed
 */
	void	db_delete_server_info(Tango::DevString);
/**
 * Get a list of exported devices whose names satisfy the filter (wildcard is *).
 *	@param	argin	filter
 *	@return	list of exported devices
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*db_get_device_exported_list(Tango::DevString);

//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	



protected :	
	//	Add your own data members here
	//-----------------------------------------
	MYSQL mysql; 
	bool check_device_name(char **device_name);
	bool device_name_to_dfm(char *device_name, char domain[], char family[], char member[]);
	string replace_wildcard(const char*);
};
}

#define DB_SQLError 			"DB_SQLError"
#define DB_IncorrectArguments		"DB_IncorrectArguments"
#define DB_IncorrectDeviceName		"DB_IncorrectDeviceName"
#define DB_IncorrectServerName		"DB_IncorrectServerName"
#define DB_DeviceNotDefined		"DB_DeviceNotDefined"

#endif	// _DATABASE_H
