static const char *RcsId = "$Header: /segfs/tango/cvsroot/cppserver/dbase/DataBase.cpp,v 2.6 2001/03/22 12:56:52 goetz Exp $";
//+=============================================================================
//
// file :         DataBase.cpp
//
// description :  C++ source for the DataBase and its commands. 
//                The class is derived from Device. It represents the
//                CORBA servant object which will be accessed from the
//                network. All commands which can be executed on the
//                DataBase are implemented in this file.
//
// project :      TANGO Device Server
//
// author(s) :    A.Gotz
//
// $Version$
//
// $Log: DataBase.cpp,v $
// Revision 2.6  2001/03/22 12:56:52  goetz
// fixed bug in DbAddDevice command, device name now unique in device table
//
// Revision 2.5  2001/03/06 12:05:44  goetz
// added DbGetDeviceExportedList; DbExportDevice updates host info in server table
//
// Revision 2.3  2001/03/05 12:10:52  goetz
// checking in before going to add new command(s)
//
// Revision 2.2  2001/01/03 11:58:28  goetz
// E.Taurel modified version for new TACO exception class
//
// Revision 2.1  2000/11/02 14:35:22  goetz
// added commands for server info
//
// Revision 2.0  2000/10/19 07:31:07  goetz
// changed major version number to 2
//
// Revision 1.16  2000/10/19 07:30:27  goetz
// ported Database to TANGO V2.0
//
// Revision 1.15  2000/10/02 08:37:15  goetz
// going to port to TANGO V2 i.e. OB V4
//
// Revision 1.14  2000/07/31 07:55:50  goetz
// added commands DbDeleteDevice and DbDeleteServer
//
// Revision 1.13  2000/07/29 13:33:03  goetz
// added commands DbDeleteDevice and DbDeleteServer, bug fixes
//
// Revision 1.12  2000/07/27 13:36:16  goetz
// checking in before going to add new commands with pogo
//
// Revision 1.11  2000/06/29 11:38:25  goetz
// intermediate checkin
//
// Revision 1.10  2000/06/06 11:04:56  goetz
// added DbGetDeviceAttributeList; modified DbGetDevicePropertyList; migrated to pogo
//
// Revision 1.9  2000/05/31 11:06:33  goetz
// added new commands; wildcard changed to *; servant name = database for all instances
//
// Revision 1.8  2000/05/25 08:32:05  goetz
// added browsing commands for Jive browser
//
// Revision 1.7  2000/05/17 14:41:23  goetz
// get domain, family and member commands converted to use database columns
//
// Revision 1.6  2000/05/16 11:47:09  goetz
// added get commands for alias, domain, family + member
//
// Revision 1.5  2000/03/13 17:36:43  goetz
// fixed bugs in Device Attribute Properties commands
//
// Revision 1.4  2000/02/16 14:12:51  goetz
// added file DataBase.pogo
//
// Revision 1.3  2000/02/16 14:12:02  goetz
// converted DataBaseds to POGO
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//-=============================================================================
//
//  This file has been partially generated by POGO
//
//                     (c) - Pascal Verdier - ESRF
//
//=============================================================================


//===================================================================
//
//	The folowing table gives the correspondance
//	between commands and method's name.
//
//	Command's name	|	Method's name
//	----------------------------------------
//	DevState	|	dev_state()
//	DevStatus	|	dev_status()
//	DbGetPropertyList	|	db_get_property_list()
//	DbGetProperty	|	db_get_property()
//	DbPutProperty	|	db_put_property()
//	DbDeleteProperty	|	db_delete_property()
//	DbGetHostServerList	|	db_get_host_server_list()
//	DbGetHostList	|	db_get_host_list()
//	DbGetServerList	|	db_get_server_list()
//	DbGetClassPropertyList	|	db_get_class_property_list()
//	DbGetDevicePropertyList	|	db_get_device_property_list()
//	DbGetDeviceAliasList	|	db_get_device_alias_list()
//	DbGetDeviceMemberList	|	db_get_device_member_list()
//	DbGetDeviceFamilyList	|	db_get_device_family_list()
//	DbGetDeviceDomainList	|	db_get_device_domain_list()
//	DbInfo	|	db_info()
//	DbGetDeviceList	|	db_get_device_list()
//	DbGetClassList	|	db_get_class_list()
//	DbGetDeviceClassList	|	db_get_device_class_list()
//	DbGetDeviceProperty	|	db_get_device_property()
//	DbPutDeviceProperty	|	db_put_device_property()
//	DbDeleteDeviceProperty	|	db_delete_device_property()
//	DbGetDeviceAttributeProperty	|	db_get_device_attribute_property()
//	DbPutDeviceAttributeProperty	|	db_put_device_attribute_property()
//	DbGetClassAttributeProperty	|	db_get_class_attribute_property()
//	DbPutClassAttributeProperty	|	db_put_class_attribute_property()
//	DbGetClassProperty	|	db_get_class_property()
//	DbPutClassProperty	|	db_put_class_property()
//	DbDeleteClassProperty	|	db_delete_class_property()
//	DbExportDevice	|	db_export_device()
//	DbImportDevice	|	db_import_device()
//	DbUnExportDevice	|	db_un_export_device()
//	DbUnExportServer	|	db_un_export_server()
//	DbAddServer	|	db_add_server()
//	DbAddDevice	|	db_add_device()
//	DbGetClassAttributeList	|	db_get_class_attribute_list()
//	DbGetDeviceAttributeList	|	db_get_device_attribute_list()
//	DbDeleteDevice	|	db_delete_device()
//	DbDeleteServer	|	db_delete_server()
//	DbDeleteDeviceAttribute	|	db_delete_device_attribute()
//	DbDeleteDeviceAttributeProperty	|	db_delete_device_attribute_property()
//	DbGetServerInfo	|	dev_get_server_info()
//	DbPutServerInfo	|	db_put_server_info()
//	DbDeleteServerInfo	|	db_delete_server_info()
//	DbGetDeviceExportedList	|	db_get_device_exported_list()
//
//===================================================================



#include <tango.h>
#include <DataBase.h>
#include <mysql.h>
#include <stdio.h>
using namespace std;

namespace DataBase {

string DataBase::db_name("sys/database/1");

//+----------------------------------------------------------------------------
//
// method : 		DataBase::DataBase(string &s)
// 
// description : 	constructors for TANGO Database device server
//
// in : - cl : Pointer to the DeviceClass object
//      - s : Device name 
//
//-----------------------------------------------------------------------------
DataBase::DataBase(Tango::DeviceClass *cl,string &s):DeviceImpl(cl,s.c_str())
{
	init_device();
}

DataBase::DataBase(Tango::DeviceClass *cl,const char *s):DeviceImpl(cl,s)
{
	init_device();
}

DataBase::DataBase(Tango::DeviceClass *cl,const char *s,const char *d)
:DeviceImpl(cl,s,d)
{
	init_device();
}

void DataBase::init_device()
{
        char *database = "tango";

        cout << "DataBase::DataBase() create database device " << device_name << endl;

// Initialise mysql database structure and connect to TANGO database

        mysql_init(&mysql);

        if (!mysql_real_connect(&mysql,NULL,NULL,NULL,database,0,NULL,0))
        {
           cout << "DataBase::init_device(): failed to connect to TANGO database
 (error = " ;
           cout << mysql_error(&mysql) << endl;
        }
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::always_executed_hook()
// 
// description : 	method always executed before any command is executed
//
//-----------------------------------------------------------------------------
void DataBase::always_executed_hook()
{

	cout2 << "In always_executed_hook method" << endl;
	
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::state_cmd()
// 
// description : 	command to read the device state
//
// out :		device state
//
//-----------------------------------------------------------------------------
Tango::DevState DataBase::dev_state()
{

	cout2 << "In DataBase state command" << endl;
	
	return device_state;
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::status_cmd()
// 
// description : 	command to read the device status
//
// out :		device status
//
//-----------------------------------------------------------------------------
const char* DataBase::dev_status()
{

	cout2 << "In DataBase status command" << endl;

	return device_status.c_str();
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_property_list
 *
 *	description:	method to execute "DbGetPropertyList"
 *	DataBase methods prototypes
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_property_list(const Tango::DevVarStringArray *object_wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;
	const char *object, *wildcard;
	string tmp_wildcard;

	object = (*object_wildcard)[0];
	wildcard = (*object_wildcard)[1];

	cout1 << "DataBase::db_get_property_list(): object " << object << endl;

	if (object == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT name FROM property WHERE object LIKE \"%\" ORDER BY name");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT name FROM property WHERE object LIKE \"%s\" AND name LIKE \"%s\" ORDER BY name",
	        object, tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_property_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_property_list(): failed to query TANGO database for list of properties";
	   cout << object << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of properties (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_property_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_property_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_property_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_property_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   property_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_property_list(): property[ "<< i << "] property " << row[0] << endl;
	         (*property_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_property
 *
 *	description:	method to execute "DbGetProperty"
 *	DataBase methods prototypes
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_property(const Tango::DevVarStringArray *property_names)
{
	static char sql_query[256];
	static char error_mess[256];
	static char n_properties_str[256];
	static char n_rows_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, n_props=0, i, j;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
	const char *tmp_object;
	string tmp_name;

	cout1 << "DataBase::db_get_property(): get " << property_names->length()-1 << " properties for object " << (*property_names)[0] << endl;

	tmp_object = (*property_names)[0];
	sprintf(n_properties_str, "%d", property_names->length()-1);
	property_list->length(2);
	(*property_list)[0] = CORBA::string_dup(tmp_object);
	(*property_list)[1] = CORBA::string_dup(n_properties_str);
        n_props = 2;

	for (i=1; i<property_names->length(); i++)
	{
	   tmp_name = replace_wildcard((*property_names)[i]);
	   sprintf(sql_query,"SELECT count,value,name FROM property WHERE object = \"%s\" AND name LIKE \"%s\" ORDER BY count",
	           tmp_object, tmp_name.c_str());
	   cout4 << "DataBase::db_get_property(): sql_query " << sql_query << endl;

	   if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	   {
	      cout << "DataBase::db_get_property(): failed to query TANGO database for list of properties ";
	      cout << "for " << (*property_names)[0] << "/" << (*property_names)[i] << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of properties for %s/%s (error=%s)",tmp_object,tmp_name.c_str(),mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::db_get_property()");
	   }

	   if ((result = mysql_store_result(&mysql)) == NULL)
	   {
	      cout << "DataBase::db_get_property(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::db_get_property()");
	   }

	   n_rows = mysql_num_rows(result);
	   cout4 << "DataBase::db_get_property(): mysql_num_rows() " << n_rows << endl;
	   sprintf(n_rows_str,"%d",n_rows);
	   n_props = n_props+2;
	   property_list->length(n_props);
	   (*property_list)[n_props-2] = CORBA::string_dup(tmp_name.c_str());
           (*property_list)[n_props-1] = CORBA::string_dup(n_rows_str);
	   if (n_rows > 0)
	   {
	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::db_get_property(): property[ "<< i << "] count " << row[0] << " value " << row[1] << endl;
		    n_props++;
	   	    property_list->length(n_props);
	            (*property_list)[n_props-1] = CORBA::string_dup(row[1]);
	         }
	      }
	      n_properties += n_rows;
	   }
	   else
	   {
	      n_props++;
	      property_list->length(n_props);
	      (*property_list)[n_props-1] = CORBA::string_dup(" ");
	   }
	   mysql_free_result(result);
	}

	cout4 << "DataBase::db_get_property(): property_list->length() "<< property_list->length() << endl;

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_property
 *
 *	description:	method to execute "DbPutProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, i, j, k;
	const char *tmp_object, *tmp_value, *tmp_count;
	string tmp_name;

	sscanf((*property_list)[1],"%d",&n_properties);
	cout1 << "DataBase::db_put_property(): put " << n_properties << " properties for object " << (*property_list)[0] << endl;

	k = 2;
	for (i=0; i<n_properties; i++)
	{
	   tmp_count = 0;
	   sscanf((*property_list)[k+1], "%d", &n_rows);
	   for (j=k+2; j<k+n_rows+2; j++)
	   {
	      tmp_object = (*property_list)[0];
//	      tmp_name = replace_wildcard((*property_list)[k]);
	      tmp_name = (*property_list)[k];
	      tmp_value = (*property_list)[j];
	      tmp_count++; sprintf(tmp_count_str, "%d", tmp_count);

// first delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property WHERE object=\"%s\" AND name=\"%s\" AND count=\"%s\"",
	              tmp_object, tmp_name.c_str(), tmp_count_str);
	      cout4 << "DataBase::db_put_property(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::db_put_property(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_object << "/" << tmp_name.c_str() << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_object,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::db_put_property()");
	      }

// then insert the new value for this tuple

	      sprintf(sql_query,"INSERT INTO property SET object=\'%s\',name=\'%s\',count=\'%s\',value=\'%s\',updated=NULL,accessed=NULL",
	              tmp_object, tmp_name.c_str(), tmp_count_str, tmp_value);
	      cout4 << "DataBase::db_put_property(): sql_query " << sql_query << endl;

	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::db_put_property(): failed to insert property into TANGO database ";
	         cout << "for " << tmp_object << "/" << tmp_name.c_str() << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to insert property into TANGO database  for %s/%s (error=%s)",tmp_object,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::db_put_property()");
	      }
	   }
	   k = k+n_rows+2;
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_property
 *
 *	description:	method to execute "DbDeleteProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, i;
	const char *tmp_object;
	string tmp_name;

	n_properties = property_list->length() - 1;
	cout1 << "DataBase::db_delete_property(): put " << n_properties << " properties for device " << (*property_list)[0] << endl;

	for (i=0; i<n_properties; i++)
	{
	      tmp_object = (*property_list)[0];
	      tmp_name = replace_wildcard((*property_list)[i+1]);

// delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property WHERE object=\"%s\" AND name LIKE \"%s\"",
	              tmp_object, tmp_name.c_str());
	      cout4 << "DataBase::db_delete_property(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::db_delete_property(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_object << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_object,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::db_delete_property()");
	      }

	}

	return;
}
//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_host_server_list
 *
 *	description:	method to execute "DbGetHostServerList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_host_server_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_host_server_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT server FROM device WHERE host LIKE \"%\" ORDER BY server");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT server FROM device WHERE host LIKE \"%s\" ORDER BY server",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_host_server_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_host_server_list(): failed to query TANGO database for list of servers";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of servers (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_host_server_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_host_server_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_host_server_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_host_server_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *server_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   server_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_host_server_list(): row[ "<< i << "] alias " << row[0] << endl;
	         (*server_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(server_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_host_list
 *
 *	description:	method to execute "DbGetHostList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_host_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_host_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT host FROM device WHERE host LIKE \"%\" ORDER BY host");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT host FROM device WHERE host LIKE \"%s\" ORDER BY host",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_host_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_host_list(): failed to query TANGO database for list of hosts";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of hosts (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_host_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_host_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_host_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_host_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *host_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   host_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_host_list(): host[ "<< i << "] alias " << row[0] << endl;
	         (*host_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(host_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_server_list
 *
 *	description:	method to execute "DbGetServerList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_server_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_server_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT server FROM device WHERE server LIKE \"%\" ORDER BY server");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT server FROM device WHERE server LIKE \"%s\" ORDER BY server",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_server_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_server_list(): failed to query TANGO database for list of servers";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of servers (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_server_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_server_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_server_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_server_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *server_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   server_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_server_list(): server[ "<< i << "] alias " << row[0] << endl;
	         (*server_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(server_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_property_list
 *
 *	description:	method to execute "DbGetDevicePropertyList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_property_list(const Tango::DevVarStringArray *device_wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;
	const char *device,*wildcard;
	string tmp_wildcard;

	device = (*device_wildcard)[0];
	wildcard = (*device_wildcard)[1];
	cout1 << "DataBase::db_get_device_property_list(): device " << device ;
	cout1 << " wildcard " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT name FROM property_device WHERE device=\"%s\" AND name LIKE \"%\" ORDER BY name",device);
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT name FROM property_device WHERE device=\"%s\" AND name LIKE \"%s\" ORDER BY name",
	        device,tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_property_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_property_list(): failed to query TANGO database for list of properties";
	   cout << device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of properties (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_property_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_property_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_property_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_property_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   property_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_property_list(): property[ "<< i << "] alias " << row[0] << endl;
	         (*property_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_class_property_list
 *
 *	description:	method to execute "DbGetClassPropertyList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_class_property_list(Tango::DevString class_name)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_class_property_list(): class " << class_name << endl;

	if (class_name == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT name FROM property_class WHERE class LIKE \"%\" ORDER BY name");
	}
	else
	{
		sprintf(sql_query,"SELECT DISTINCT name FROM property_class WHERE class LIKE \"%s\" ORDER BY name",
	        class_name);
	}
	cout4 << "DataBase::db_get_class_property_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_class_property_list(): failed to query TANGO database for list of properties";
	   cout << class_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of properties (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_class_property_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_class_property_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_class_property_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_class_property_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   property_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_class_property_list(): property[ "<< i << "] alias " << row[0] << endl;
	         (*property_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_alias_list
 *
 *	description:	method to execute "DbGetDeviceAliasList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_alias_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_device_alias_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT alias FROM device WHERE alias LIKE \"%\" ORDER BY alias");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT alias FROM device WHERE alias LIKE \"%s\" ORDER BY alias",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_alias_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_alias_list(): failed to query TANGO database for list of aliases";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of aliases (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_alias_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_alias_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_alias_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_alias_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *alias_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   alias_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_alias_list(): row[ "<< i << "] alias " << row[0] << endl;
	         (*alias_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(alias_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_member_list
 *
 *	description:	method to execute "DbGetDeviceMemberList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_member_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_device_member_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT member FROM device WHERE name LIKE \"%\" ORDER BY member");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT member FROM device WHERE name LIKE \"%s\" ORDER BY member",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_member_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_member_list(): failed to query TANGO database for list of member names";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of member names (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_member_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_member_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_member_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_member_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *member_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   member_list->length(n_rows);
	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_member_list(): member[ "<< i << "] " << row[0] << endl;
	         (*member_list)[i] = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(member_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_family_list
 *
 *	description:	method to execute "DbGetDeviceFamilyList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_family_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_device_family_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT family FROM device WHERE name LIKE \"%\" ORDER BY family");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT family FROM device WHERE name LIKE \"%s\" ORDER BY family",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_family_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_family_list(): failed to query TANGO database for list of member names";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of family names (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_family_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_family_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_family_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_family_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *family_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   family_list->length(n_rows);
	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_family_list(): family[ "<< i << "] " << row[0] << endl;
	         (*family_list)[i] = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(family_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_domain_list
 *
 *	description:	method to execute "DbGetDeviceDomainList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_domain_list(Tango::DevString wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_device_domain_list(): wild card " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT domain FROM device WHERE name LIKE \"%\" ORDER BY domain");
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT domain FROM device WHERE name LIKE \"%s\" ORDER BY domain",
	        tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_domain_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_domain_list(): failed to query TANGO database for list of domain names";
	   cout << wildcard << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of domain names (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_domain_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_domain_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_domain_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_domain_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *domain_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   domain_list->length(n_rows);
	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_domain_list(): domain[ "<< i << "] " << row[0] << endl;
	         (*domain_list)[i] = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(domain_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_info
 *
 *	description:	method to execute "DbInfo"
 *
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_info()
{

	static char sql_query[256];
	static char error_mess[256];
	static char info_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows=0, n_infos=0, i, j;
	Tango::DevVarStringArray *info_list = new Tango::DevVarStringArray;

	cout1 << "DataBase::db_info(): get general database infos" << endl;

	sprintf(info_str,"TANGO Database %s",DataBase::db_name.c_str());
	n_infos = 1;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// newline

	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(" ");

// get start time of database

	sprintf(sql_query,"SELECT started FROM device WHERE name = \"%s\" ",DataBase::db_name.c_str());
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for start time " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database start time (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Running since ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): database started " << row[0] << endl;
	      sprintf(info_str,"Running since %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// newline

	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(" ");

// get number of devices defined

	sprintf(sql_query,"SELECT COUNT(*) FROM device ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of devices " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of devices (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Devices defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of devices " << row[0] << endl;
	      sprintf(info_str,"Devices defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// get number of devices exported

	sprintf(sql_query,"SELECT COUNT(*) FROM device WHERE exported = 1 ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of devices exported" ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of devices exported (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Devices exported ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of devices exported " << row[0] << endl;
	      sprintf(info_str,"Devices exported  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// get number of devices servers defined

	sprintf(sql_query,"SELECT COUNT(*) FROM device WHERE class = \"DServer\" ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of device servers " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of device servers (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Device servers defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of device servers defined " << row[0] << endl;
	      sprintf(info_str,"Device servers defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// get number of devices servers exported

	sprintf(sql_query,"SELECT COUNT(*) FROM device WHERE class = \"DServer\" AND exported = 1 ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of device servers exported " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of device servers exported (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   			  	  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Device servers exported ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of device servers exported " << row[0] << endl;
	      sprintf(info_str,"Device servers exported  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// newline

	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(" ");

// get number of class properties 

	sprintf(sql_query,"SELECT COUNT(*) FROM property_class ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of class properties defined " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of class properties defined (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Class properties defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of class properties defined " << row[0] << endl;
	      sprintf(info_str,"Class properties defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);
// get number of devices properties 

	sprintf(sql_query,"SELECT COUNT(*) FROM property_device ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of device properties " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of device properties (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Device Properties defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of device properties defined " << row[0] << endl;
	      sprintf(info_str,"Device properties defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// get number of class attribute properties 

	sprintf(sql_query,"SELECT COUNT(*) FROM property_attribute_class ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of class attribute properties defined " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of class attribute properties defined (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Class Attribute properties defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of class attribute properties defined " << row[0] << endl;
	      sprintf(info_str,"Class attribute properties defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

// get number of device attribute properties 

	sprintf(sql_query,"SELECT COUNT(*) FROM property_attribute_device ");
//	cout4 << "DataBase::db_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_info(): failed to query TANGO database for no. of device attribute properties defined " ;
	   cout << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for no. of device attribute properties defined (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char*)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_info()");
	}

	sprintf(info_str,"Device Attribute properties defined ...");
	n_rows = mysql_num_rows(result);
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_info(): no. of device attribute properties defined " << row[0] << endl;
	      sprintf(info_str,"Device attribute properties defined  = %s",row[0]);
	   }
	}
	mysql_free_result(result);
	n_infos++;
	info_list->length(n_infos);
	(*info_list)[n_infos-1] = CORBA::string_dup(info_str);

	cout4 << "DataBase::db_info(): info_list->length() "<< info_list->length() << endl;

	return(info_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_list
 *
 *	description:	method to execute "DbGetDeviceList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_list(const Tango::DevVarStringArray *server_class)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;
	const char *tmp_server, *tmp_class;

	if (server_class->length() != 2)
	{
	   cout << "DataBase::db_get_device_list(): incorrect number of input arguments " << endl;
	   sprintf(error_mess,"incorrect no. of input arguments, needs 2 (server,class)");
	   Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceList()");
	}
		
	tmp_server = (*server_class)[0];
	tmp_class = (*server_class)[1];

	cout1 << "DataBase::GetClassList(): server " << tmp_server << endl;

	sprintf(sql_query,"SELECT DISTINCT name FROM device WHERE server = \"%s\" AND class = \"%s\" ORDER BY name",
	        tmp_server, tmp_class);
	cout4 << "DataBase::GetDeviceList(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::GetDeviceList(): failed to query TANGO database for list of classes for server ";
	   cout << server_class << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of classes for server (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceList()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::GetDeviceList(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceList()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::GetDeviceList(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *device_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   device_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::GetdeviceList(): row[ "<< i << "] name " << row[0] << endl;
	         (*device_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(device_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_class_list
 *
 *	description:	method to execute "DbGetClassList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_class_list(Tango::DevString server)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_class_list(): server " << server << endl;

	sprintf(sql_query,"SELECT DISTINCT class FROM device WHERE server = \"%s\" ORDER BY class",
	        server);
	cout4 << "DataBase::db_get_class_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_class_list(): failed to query TANGO database for list of classes for server ";
	   cout << server << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of classes for server (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_class_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_class_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_class_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_class_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *class_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   class_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_class_list(): row[ "<< i << "] class " << row[0] << endl;
	         (*class_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(class_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_class_list
 *
 *	description:	method to execute "DbGetDeviceClassList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_class_list(Tango::DevString server)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::GetDeviceClassList(): server " << server << endl;

	sprintf(sql_query,"SELECT name,class FROM device WHERE server = \"%s\" ORDER BY name",
	        server);
	cout4 << "DataBase::GetDeviceClassList(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::GetDeviceClassList(): failed to query TANGO database for list of devices for server ";
	   cout << server << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of devices for server (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceClassList()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::GetDeviceClassList(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceClassList()");
	}

	n_rows = mysql_num_rows(result);
	cout1 << "DataBase::GetDeviceClassList(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *device_class_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   device_class_list->length(n_rows*2);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::GetDeviceClassList(): row[ "<< i << "] name " << row[0] << " class " << row[1] << endl;
	         (*device_class_list)[i*2]   = CORBA::string_dup(row[0]);
	         (*device_class_list)[i*2+1] = CORBA::string_dup(row[1]);
	      }
	   }
	}
	mysql_free_result(result);

	return(device_class_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_property
 *
 *	description:	method to execute "DbGetDeviceProperty"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_property(const Tango::DevVarStringArray *property_names)
{
	static char sql_query[256];
	static char error_mess[256];
	static char n_properties_str[256];
	static char n_rows_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, n_props=0, i, j;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
	const char *tmp_device;
	string tmp_name;

	if (property_names->length() < 2)
	{
	   cout << "DataBase::GetDeviceProperty(): incorrect number of input arguments " << endl;
	   sprintf(error_mess,"incorrect no. of input arguments, needs at least 2 (device,property)");
	   Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::GetDeviceProperty()");
	}

	cout1 << "DataBase::GetDeviceProperty(): get " << property_names->length()-1 << " properties for device " << (*property_names)[0] << endl;

	tmp_device = (*property_names)[0];
	sprintf(n_properties_str, "%d", property_names->length()-1);
	n_props = 2;
	property_list->length(n_props);
	(*property_list)[0] = CORBA::string_dup(tmp_device);
	(*property_list)[1] = CORBA::string_dup(n_properties_str);

	for (i=1; i<property_names->length(); i++)
	{
	   tmp_name = replace_wildcard((*property_names)[i]);
	   sprintf(sql_query,"SELECT count,value,name FROM property_device WHERE device = \"%s\" AND name LIKE \"%s\" ORDER BY count",
	           tmp_device, tmp_name.c_str());
	   cout4 << "DataBase::GetDeviceList(): sql_query " << sql_query << endl;

	   if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	   {
	      cout << "DataBase::GetDeviceProperty(): failed to query TANGO database for list of properties ";
	      cout << "for " << (*property_names)[0] << "/" << (*property_names)[i] << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of properties for %s/%s (error=%s)",tmp_device,tmp_name.c_str(),mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetDeviceList()");
	   }

	   if ((result = mysql_store_result(&mysql)) == NULL)
	   {
	      cout << "DataBase::GetDeviceProperty(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetDeviceProperty()");
	   }

	   n_rows = mysql_num_rows(result);
	   cout4 << "DataBase::GetDeviceProperty(): mysql_num_rows() " << n_rows << endl;
	   sprintf(n_rows_str,"%d",n_rows);
	   n_props = n_props+2;
	   property_list->length(n_props);
	   (*property_list)[n_props-2] = CORBA::string_dup(tmp_name.c_str());
           (*property_list)[n_props-1] = CORBA::string_dup(n_rows_str);
	   if (n_rows > 0)
	   {

	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::GetDeviceProperty(): property[ "<< i << "] count " << row[0] << " value " << row[1] << endl;
		    n_props++;
		    property_list->length(n_props);
	            (*property_list)[n_props-1] = CORBA::string_dup(row[1]);
	         }
	      }
	      n_properties += n_rows;
	   }
	   else
	   {
	      n_props++;
	      property_list->length(n_props);
	      (*property_list)[n_props-1] = CORBA::string_dup(" ");
	   }
	   mysql_free_result(result);
	}

	cout4 << "DataBase::GetDeviceProperty(): property_list->length() "<< property_list->length() << endl;

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_device_property
 *
 *	description:	method to execute "DbPutDeviceProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_device_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, i, j, k;
	const char *tmp_device, *tmp_value, *tmp_count;
	string tmp_name;

	sscanf((*property_list)[1],"%d",&n_properties);
	cout1 << "DataBase::PutDeviceProperty(): put " << n_properties << " properties for device " << (*property_list)[0] << endl;

	k = 2;
	for (i=0; i<n_properties; i++)
	{
	   tmp_count = 0;
	   sscanf((*property_list)[k+1], "%d", &n_rows);
	   for (j=k+2; j<k+n_rows+2; j++)
	   {
	      tmp_device = (*property_list)[0];
//	      tmp_name = replace_wildcard((*property_list)[k]);
	      tmp_name = (*property_list)[k];
	      tmp_value = (*property_list)[j];
	      tmp_count++; sprintf(tmp_count_str, "%d", tmp_count);

// first delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_device WHERE device=\"%s\" AND name=\"%s\" AND count=\"%s\"",
	              tmp_device, tmp_name.c_str(), tmp_count_str);
	      cout4 << "DataBase::PutDeviceProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutDeviceProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_device << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_device,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutDeviceProperty()");
	      }

// then insert the new value for this tuple

	      sprintf(sql_query,"INSERT INTO property_device SET device=\'%s\',name=\'%s\',count=\'%s\',value=\'%s\',updated=NULL,accessed=NULL",
	              tmp_device, tmp_name.c_str(), tmp_count_str, tmp_value);
	      cout4 << "DataBase::PutDeviceProperty(): sql_query " << sql_query << endl;

	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutDeviceProperty(): failed to insert property into TANGO database ";
	         cout << "for " << tmp_device << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to insert property into TANGO database  for %s/%s (error=%s)",tmp_device,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutDeviceProperty()");
	      }
	   }
	   k = k+n_rows+2;
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_device_property
 *
 *	description:	method to execute "DbDeleteDeviceProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_device_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, i;
	const char *tmp_device;
	string tmp_name;

	n_properties = property_list->length() - 1;
	cout1 << "DataBase::PutDeviceProperty(): put " << n_properties << " properties for device " << (*property_list)[0] << endl;

	for (i=0; i<n_properties; i++)
	{
	      tmp_device = (*property_list)[0];
	      tmp_name = replace_wildcard((*property_list)[i+1]);

// delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_device WHERE device=\"%s\" AND name LIKE \"%s\"",
	              tmp_device, tmp_name.c_str());
	      cout4 << "DataBase::DeleteDeviceProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::DeleteDeviceProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_device << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_device,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::DeleteDeviceProperty()");
	      }

	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_attribute_property
 *
 *	description:	method to execute "DbGetDeviceAttributeProperty"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_attribute_property(const Tango::DevVarStringArray *property_names)
{
	static char sql_query[256];
	static char error_mess[256];
	static char n_attributes_str[256];
	static char n_rows_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_attributes=0, n_rows=0, n_props=0, i, j;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
	const char *tmp_device, *tmp_attribute, *tmp_name;

	cout1 << "DataBase::GetAttributeProperty(): get " << property_names->length()-1 << " properties for device " << (*property_names)[0] << endl;

	tmp_device = (*property_names)[0];
	sprintf(n_attributes_str, "%d", property_names->length()-1);
	n_props = 2;
	property_list->length(n_props);
	(*property_list)[n_props-2] = CORBA::string_dup(tmp_device);
	(*property_list)[n_props-1] = CORBA::string_dup(n_attributes_str);

	for (i=1; i<property_names->length(); i++)
	{
	   tmp_attribute = (*property_names)[i];
	   sprintf(sql_query,"SELECT name,value FROM property_attribute_device WHERE device = \"%s\" AND attribute LIKE \"%s\" ",
	           tmp_device, tmp_attribute);
	   cout4 << "DataBase::GetAttributeProperty(): sql_query " << sql_query << endl;

	   if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	   {
	      cout << "DataBase::GetAttributeProperty(): failed to query TANGO database for list of properties ";
	      cout << "for " << (*property_names)[0] << "/" << (*property_names)[i] << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of properties for %s/%s (error=%s)",tmp_device,tmp_attribute,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetAttributeProperty()");
	   }

	   if ((result = mysql_store_result(&mysql)) == NULL)
	   {
	      cout << "DataBase::GetAttributeProperty(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetAttributeProperty()");
	   }

	   n_rows = mysql_num_rows(result);
	   cout4 << "DataBase::GetAttributeProperty(): mysql_num_rows() " << n_rows << endl;
	   sprintf(n_rows_str,"%d",n_rows);
	   n_props = n_props+2;
	   property_list->length(n_props);
	   (*property_list)[n_props-2] = CORBA::string_dup(tmp_attribute);
           (*property_list)[n_props-1] = CORBA::string_dup(n_rows_str);
	   if (n_rows > 0)
	   {

	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::GetAttributeProperty(): property[ "<< i << "] count " << row[0] << " value " << row[1] << endl;
	   	    n_props = n_props+2;
	   	    property_list->length(n_props);
	            (*property_list)[n_props-2] = CORBA::string_dup(row[0]);
	            (*property_list)[n_props-1] = CORBA::string_dup(row[1]);
	         }
	      }
	      n_attributes += n_rows;
	   }
	   mysql_free_result(result);
	}

	cout4 << "DataBase::GetDeviceProperty(): property_list->length() "<< property_list->length() << endl;

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_device_attribute_property
 *
 *	description:	method to execute "DbPutDeviceAttributeProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_device_attribute_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_attributes, n_properties=0, n_rows=0, i, j, k;
	const char *tmp_device, *tmp_attribute, *tmp_name, *tmp_value, *tmp_count;

	sscanf((*property_list)[1],"%d",&n_attributes);
	cout1 << "DataBase::PutAttributeProperty(): put " << n_attributes << " attributes for device " << (*property_list)[0] << endl;

	k = 2;
	for (i=0; i<n_attributes; i++)
	{
	   tmp_device = (*property_list)[0];
	   tmp_attribute = (*property_list)[k];
	   sscanf((*property_list)[k+1], "%d", &n_properties);
	   for (j=k+2; j<k+n_properties*2+2; j=j+2)
	   {
	      tmp_name = (*property_list)[j];
	      tmp_value = (*property_list)[j+1];

// first delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_attribute_device WHERE device=\"%s\" AND attribute=\"%s\" AND name=\"%s\" ",
	              tmp_device, tmp_attribute, tmp_name);
	      cout4 << "DataBase::PutAttributeProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutAttributeProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_device << "/" << tmp_attribute << "." << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s.%s (error=%s)",tmp_device,tmp_attribute,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutAttributeProperty()");
	      }

// then insert the new value for this tuple

	      sprintf(sql_query,"INSERT INTO property_attribute_device SET device=\'%s\',attribute=\'%s\',name=\'%s\',count=\'1\',value=\'%s\',updated=NULL,accessed=NULL",
	              tmp_device, tmp_attribute, tmp_name, tmp_value);
	      cout4 << "DataBase::PutAttributeProperty(): sql_query " << sql_query << endl;

	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutAttributeProperty(): failed to insert property into TANGO database ";
	         cout << "for " << tmp_device << "/" << tmp_attribute << "." << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to insert property into TANGO database  for %s/%s.%s (error=%s)",tmp_device,tmp_attribute,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutAttributeProperty()");
	      }
	   }
	   k = k+n_properties*2+2;
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_class_attribute_property
 *
 *	description:	method to execute "DbGetClassAttributeProperty"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_class_attribute_property(const Tango::DevVarStringArray *property_names)
{
	static char sql_query[256];
	static char error_mess[256];
	static char n_attributes_str[256];
	static char n_rows_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_attributes=0, n_rows=0, n_props=0, i, j;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
	const char *tmp_class, *tmp_attribute, *tmp_name;

	cout1 << "DataBase::GetAttributeProperty(): get " << property_names->length()-1 << " attributes for class " << (*property_names)[0] << endl;

	tmp_class = (*property_names)[0];
	sprintf(n_attributes_str, "%d", property_names->length()-1);
	n_props = 2;
	property_list->length(n_props);
	(*property_list)[n_props-2] = CORBA::string_dup(tmp_class);
	(*property_list)[n_props-1] = CORBA::string_dup(n_attributes_str);

	for (i=1; i<property_names->length(); i++)
	{
	   tmp_attribute = (*property_names)[i];
	   sprintf(sql_query,"SELECT name,value FROM property_attribute_class WHERE class = \"%s\" AND attribute LIKE \"%s\" ",
	           tmp_class, tmp_attribute);
	   cout4 << "DataBase::GetAttributeProperty(): sql_query " << sql_query << endl;

	   if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	   {
	      cout << "DataBase::GetAttributeProperty(): failed to query TANGO database for list of properties ";
	      cout << "for " << (*property_names)[0] << "/" << (*property_names)[i] << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of properties for %s/%s (error=%s)",tmp_class,tmp_attribute,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetAttributeProperty()");
	   }

	   if ((result = mysql_store_result(&mysql)) == NULL)
	   {
	      cout << "DataBase::GetAttributeProperty(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetAttributeProperty()");
	   }

	   n_rows = mysql_num_rows(result);
	   cout4 << "DataBase::GetAttributeProperty(): mysql_num_rows() " << n_rows << endl;
	   sprintf(n_rows_str,"%d",n_rows);
	   n_props = n_props+2;
	   property_list->length(n_props);
	   (*property_list)[n_props-2] = CORBA::string_dup(tmp_attribute);
           (*property_list)[n_props-1] = CORBA::string_dup(n_rows_str);
	   if (n_rows > 0)
	   {

	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::GetAttributeProperty(): property[ "<< i << "] count " << row[0] << " value " << row[1] << endl;
	            n_props = n_props+2;
	            property_list->length(n_props);
	            (*property_list)[n_props-2] = CORBA::string_dup(row[0]);
	            (*property_list)[n_props-1] = CORBA::string_dup(row[1]);
	         }
	      }
	      n_attributes += n_rows;
	   }
	   mysql_free_result(result);
	}

	cout4 << "DataBase::GetClassProperty(): property_list->length() "<< property_list->length() << endl;

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_class_attribute_property
 *
 *	description:	method to execute "DbPutClassAttributeProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_class_attribute_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_attributes, n_properties=0, n_rows=0, i, j, k;
	const char *tmp_class, *tmp_attribute, *tmp_name, *tmp_value, *tmp_count;

	sscanf((*property_list)[1],"%d",&n_attributes);
	cout1 << "DataBase::PutAttributeProperty(): put " << n_attributes << " attributes for device " << (*property_list)[0] << endl;

	k = 2;
	for (i=0; i<n_attributes; i++)
	{
	   tmp_class = (*property_list)[0];
	   tmp_attribute = (*property_list)[k];
	   sscanf((*property_list)[k+1], "%d", &n_properties);
	   for (j=k+2; j<k+n_properties*2+2; j=j+2)
	   {
	      tmp_name = (*property_list)[j];
	      tmp_value = (*property_list)[j+1];

// first delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_attribute_class WHERE class=\"%s\" AND attribute=\"%s\" AND name=\"%s\" ",
	              tmp_class, tmp_attribute, tmp_name);
	      cout4 << "DataBase::PutAttributeProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutAttributeProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_class << "/" << tmp_attribute << "." << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s.%s (error=%s)",tmp_class,tmp_attribute,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutAttributeProperty()");
	      }

// then insert the new value for this tuple

	      sprintf(sql_query,"INSERT INTO property_attribute_class SET class=\'%s\',attribute=\'%s\',name=\'%s\',count=\'1\',value=\'%s\',updated=NULL,accessed=NULL",
	              tmp_class, tmp_attribute, tmp_name, tmp_value);
	      cout4 << "DataBase::PutAttributeProperty(): sql_query " << sql_query << endl;

	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutAttributeProperty(): failed to insert property into TANGO database ";
	         cout << "for " << tmp_class << "/" << tmp_attribute << "." << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to insert property into TANGO database  for %s/%s.%s (error=%s)",tmp_class,tmp_attribute,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutAttributeProperty()");
	      }
	   }
	   k = k+n_properties*2+2;
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_class_attribute_list
 *
 *	description:	method to execute "DbGetClassAttributeList"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_class_attribute_list(const Tango::DevVarStringArray *class_wildcard)
{

	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_attributes=0, n_rows=0, n_attrs=0, i, j;
	Tango::DevVarStringArray *attribute_list = new Tango::DevVarStringArray;
	const char *class_name, *wildcard;
	string tmp_wildcard;

	cout1 << "DataBase::db_get_class_attribute(): get attributes for class " << class_name << endl;

	class_name = (*class_wildcard)[0];	
	wildcard = (*class_wildcard)[1];	
	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT attribute FROM property_attribute_class WHERE class = \"%s\"  AND name like \"\%\"",
	           class_name);
	}
	else
	{
		tmp_wildcard = replace_wildcard(wildcard);
		sprintf(sql_query,"SELECT DISTINCT attribute FROM property_attribute_class WHERE class = \"%s\"  AND name like \"%s\"",
	           class_name, tmp_wildcard.c_str());
	}
	cout4 << "DataBase::GetClassAttributeList(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	      cout << "DataBase::GetClassAttributeList(): failed to query TANGO database for list of attribute ";
	      cout << "for " << class_name << "(error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of attributes for %s (error=%s)",class_name,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetClassAttribute()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	      cout << "DataBase::GetClassAttributeList(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetClassAttributeList()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::GetClassAttributeList(): num_rows() " << n_rows << endl;
	if (n_rows > 0)
	{

	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::GetClassAttributeList(): attribute[ "<< i << "] " << row[0] << endl;
		    n_attrs++;
		    attribute_list->length(n_attrs);
	            (*attribute_list)[n_attrs-1] = CORBA::string_dup(row[0]);
	         }
	      }
	}
	mysql_free_result(result);

	cout4 << "DataBase::GetClassAttributeList(): attribute_list->length() "<< attribute_list->length() << endl;

	return(attribute_list);
}
//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_class_property
 *
 *	description:	method to execute "DbGetClassProperty"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_class_property(const Tango::DevVarStringArray *property_names)
{
	static char sql_query[256];
	static char error_mess[256];
	static char n_properties_str[256];
	static char n_rows_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, n_props=0, i, j;
	Tango::DevVarStringArray *property_list = new Tango::DevVarStringArray;
	const char *tmp_class, *tmp_name;

	cout1 << "DataBase::GetClassProperty(): get " << property_names->length()-1 << " properties for device " << (*property_names)[0] << endl;

	tmp_class = (*property_names)[0];
	sprintf(n_properties_str, "%d", property_names->length()-1);
	n_props = 2;
	property_list->length(n_props);
	(*property_list)[0] = CORBA::string_dup(tmp_class);
	(*property_list)[1] = CORBA::string_dup(n_properties_str);

	for (i=1; i<property_names->length(); i++)
	{
	   tmp_name = (*property_names)[i];
	   sprintf(sql_query,"SELECT count,value FROM property_class WHERE class = \"%s\" AND name LIKE \"%s\" ORDER BY count",
	           tmp_class, tmp_name);
	   cout4 << "DataBase::GetClassProperty(): sql_query " << sql_query << endl;

	   if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	   {
	      cout << "DataBase::GetClassProperty(): failed to query TANGO database for list of properties ";
	      cout << "for " << (*property_names)[0] << "/" << (*property_names)[i] << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to query TANGO database for list of properties for %s/%s (error=%s)",tmp_class,tmp_name,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetClassProperty()");
	   }

	   if ((result = mysql_store_result(&mysql)) == NULL)
	   {
	      cout << "DataBase::GetClassProperty(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::GetClassProperty()");
	   }

	   n_rows = mysql_num_rows(result);
	   cout4 << "DataBase::GetClassProperty(): mysql_num_rows() " << n_rows << endl;
	   sprintf(n_rows_str,"%d",n_rows);
	   n_props = n_props+2;
	   property_list->length(n_props);
	   (*property_list)[n_props-2] = CORBA::string_dup(tmp_name);
           (*property_list)[n_props-1] = CORBA::string_dup(n_rows_str);
	   if (n_rows > 0)
	   {

	      for (j=0; j<n_rows; j++)
	      {
	         if ((row = mysql_fetch_row(result)) != NULL)
	         {
	            cout4 << "DataBase::GetClassProperty(): property[ "<< i << "] count " << row[0] << " value " << row[1] << endl;
		    n_props++;
		    property_list->length(n_props);
	            (*property_list)[n_props-1] = CORBA::string_dup(row[1]);
	         }
	      }
	      n_properties += n_rows;
	   }
	   mysql_free_result(result);
	}

	cout4 << "DataBase::GetClassProperty(): property_list->length() "<< property_list->length() << endl;

	return(property_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_class_property
 *
 *	description:	method to execute "DbPutClassProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_class_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, n_rows=0, i, j, k;
	const char *tmp_class, *tmp_name, *tmp_value, *tmp_count;

	sscanf((*property_list)[1],"%d",&n_properties);
	cout1 << "DataBase::PutClassProperty(): put " << n_properties << " properties for device " << (*property_list)[0] << endl;

	k = 2;
	tmp_class = (*property_list)[0];
	for (i=0; i<n_properties; i++)
	{
	   tmp_count = 0;
	   tmp_name = (*property_list)[k];
	   sscanf((*property_list)[k+1], "%d", &n_rows);
	   for (j=k+2; j<k+n_rows+2; j++)
	   {
	      tmp_value = (*property_list)[j];
	      tmp_count++; sprintf(tmp_count_str, "%d", tmp_count);

// first delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_class WHERE class=\"%s\" AND name=\"%s\" AND count=\"%s\"",
	              tmp_class, tmp_name, tmp_count_str);
	      cout4 << "DataBase::PutClassProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutClassProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_class << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_class,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutClassProperty()");
	      }

// then insert the new value for this tuple

	      sprintf(sql_query,"INSERT INTO property_class SET class=\'%s\',name=\'%s\',count=\'%s\',value=\'%s\',updated=NULL,accessed=NULL",
	              tmp_class, tmp_name, tmp_count_str, tmp_value);
	      cout4 << "DataBase::PutClassProperty(): sql_query " << sql_query << endl;

	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::PutClassProperty(): failed to insert property into TANGO database ";
	         cout << "for " << tmp_class << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to insert property into TANGO database  for %s/%s (error=%s)",tmp_class,tmp_name,mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::PutClassProperty()");
	      }
	   }
	   k = k+n_rows+2;
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_class_property
 *
 *	description:	method to execute "DbDeleteClassProperty"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_class_property(const Tango::DevVarStringArray *property_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_properties=0, i;
	const char *tmp_class;
	string tmp_name;

	n_properties = property_list->length() - 1;
	cout1 << "DataBase::DeleteClassProperty(): delete " << n_properties << " properties for class " << (*property_list)[0] << endl;

	for (i=0; i<n_properties; i++)
	{
	      tmp_class = (*property_list)[0];
	      tmp_name = replace_wildcard((*property_list)[i+1]);

// delete the tuple (device,name,count) from the property table

	      sprintf(sql_query,"DELETE FROM property_class WHERE class=\"%s\" AND name LIKE \"%s\"",
	              tmp_class, tmp_name.c_str());
	      cout4 << "DataBase::DeleteClassProperty(): sql_query " << sql_query << endl;
	      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	      {
	         cout << "DataBase::DeleteClassProperty(): failed to delete property from TANGO database ";
	         cout << "for " << tmp_class << "/" << tmp_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	         sprintf(error_mess,"failed to delete property from TANGO database  for %s/%s (error=%s)",tmp_class,tmp_name.c_str(),mysql_error(&mysql));
	         Tango::Except::throw_exception((const char *)DB_SQLError,
		 				(const char *)error_mess,
						(const char *)"DataBase::DeleteClassProperty()");
	      }

	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_export_device
 *
 *	description:	method to execute "DbExportDevice"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_export_device(const Tango::DevVarStringArray *export_info)
{
	static char sql_query[4096];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	long n_rows=0, i, j;
	const char *tmp_ior, *tmp_host, *tmp_pid, *tmp_version;
	string tmp_device, tmp_server;


	if (export_info->length() < 5) {
   		cout << "DataBase::DbExportDevice(): insufficient export info for device ";
   		cout << tmp_device << endl;
   		sprintf(error_mess,"insufficient export info for device %s",tmp_device.c_str());
   		Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
					       (const char *)error_mess,
					       (const char *)"DataBase::DbExportDevice()");
	}
	
	cout1 << "DataBase::ExportDevice(): put " << export_info->length()-1 << " export info for device " << (*export_info)[0] << endl;

	tmp_device = (*export_info)[0];
	for (i=0; i<tmp_device.length(); i++) { 
		tmp_device[i] = tolower(tmp_device[i]);
	}
	tmp_ior = (*export_info)[1];
	tmp_host = (*export_info)[2];
	tmp_pid = (*export_info)[3];
	tmp_version = (*export_info)[4];

//
// check if device is defined and if so get server name in order to
// update server table 
//
	sprintf(sql_query,"SELECT server FROM device WHERE name LIKE \"%s\" ",
	        tmp_device.c_str());
	cout4 << "DataBase::ExportDevice(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::ExportDevice(): failed to query TANGO database for server name ";
	   cout << "for device " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for server name of device for %s (error=%s)",tmp_device.c_str(),mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::ExportDevice()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::ExportDevice(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::ExportDevice()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::ExportDevice(): mysql_num_rows() " << n_rows << endl;

	if (n_rows > 0)
	{

	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::ExportDevice(): device "<< tmp_device << " server name " << row[0] << endl;
	      tmp_server = row[0];
	   }
	}
	else {
	     cout << "DataBase::ExportDevice(): device not defined !" << endl;
	     sprintf(error_mess,"device %s not defined in the database !",tmp_device.c_str());
	     mysql_free_result(result);
	     Tango::Except::throw_exception((const char *)DB_DeviceNotDefined,
	     				    (const char *)error_mess,
					    (const char *)"DataBase::ExportDevice()");
	}
	mysql_free_result(result);

// update the new value for this tuple

	sprintf(sql_query,"UPDATE device set exported=1,ior=\'%s\',host=\'%s\',pid=\'%s\',version=\'%s\',started=NOW() where name LIKE \'%s\'",
        	tmp_ior, tmp_host, tmp_pid, tmp_version, tmp_device.c_str());
	cout4 << "DataBase::ExportDevice(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
   		cout << "DataBase::DbExportDevice(): failed to export device to TANGO database ";
   		cout << "for " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
   		sprintf(error_mess,"failed to insert export info into TANGO database for %s",tmp_device.c_str());
   		Tango::Except::throw_exception((const char *)DB_SQLError,
					       (const char *)error_mess,
					       (const char *)"DataBase::DbExportDevice()");
	}

// update host name in server table

        sprintf(sql_query,"UPDATE server set host=\'%s\' where name LIKE \'%s\'",
                tmp_host, tmp_server.c_str());
        cout4 << "DataBase::ExportDevice(): sql_query " << sql_query << endl;
 
        if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
        {
                cout << "DataBase::DbExportDevice(): failed to update host name in server table";
                cout << "for " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
                sprintf(error_mess,"failed to update host name in server table for %s",tmp_device.c_str());
                Tango::Except::throw_exception((const char *)DB_SQLError,
                                               (const char *)error_mess,
                                               (const char *)"DataBase::DbExportDevice()");
        }              

	return;
}
//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_un_export_device
 *
 *	description:	method to execute "DbUnExportDevice"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_un_export_device(Tango::DevString device_name)
{
	static char sql_query[4096];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	long n_rows=0, i, j;
	char *tmp_device;

	cout1 << "DataBase::UnExportDevice(): un-export " << device_name << " device " << endl;

	tmp_device = (char*)malloc(strlen(device_name)+1);
	sprintf(tmp_device,"%s",device_name);
	for (i=0; i<strlen(tmp_device); i++) { 
		tmp_device[i] = tolower(tmp_device[i]);
	}

// un-export device from database by seting ior="not exported"

	sprintf(sql_query,"UPDATE device SET exported=0,stopped=NOW() WHERE name like \"%s\"",
	        tmp_device);
	cout4 << "DataBase::UnExportDevice(): sql_query " << sql_query << endl;
	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
   		cout << "DataBase::UnExportDevice(): failed to unexport device from TANGO database ";
   		cout << "for " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
   		sprintf(error_mess,"failed to un-export device %s from TANGO database  (error=%s)",tmp_device,mysql_error(&mysql));
   		Tango::Except::throw_exception((const char *)DB_SQLError,
					       (const char *)error_mess,
					       (const char *)"DataBase::UnExportDevice()");
	}

	free(tmp_device);

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_un_export_server
 *
 *	description:	method to execute "DbUnExportServer"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_un_export_server(Tango::DevString server_name)
{
	static char sql_query[4096];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	long n_rows=0, i, j;
	char *tmp_server;

	cout1 << "DataBase::UnExportServer(): un-export all device(s) from server " << server_name << " device " << endl;

	tmp_server = (char*)malloc(strlen(server_name)+1);
	sprintf(tmp_server,"%s",server_name);
	for (i=0; i<strlen(tmp_server); i++) { 
		tmp_server[i] = tolower(tmp_server[i]);
	}

// un-export all devices belonging to this server from database by setting exported="false"

	sprintf(sql_query,"UPDATE device SET exported=0,stopped=NOW() WHERE server like \"%s\"",
	        tmp_server);
	cout4 << "DataBase::UnExportServer(): sql_query " << sql_query << endl;
	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
   		cout << "DataBase::UnExportServer(): failed to unexport devices from TANGO database ";
   		cout << "for " << tmp_server << " (mysql_error=" << mysql_error(&mysql) << ")" << endl;
   		sprintf(error_mess,"failed to un-export devices %s from TANGO database  (error=%s)",tmp_server,mysql_error(&mysql));
   		Tango::Except::throw_exception((const char *)DB_SQLError,
					       (const char *)error_mess,
					       (const char *)"DataBase::UnExportServer()");
	}

	free(tmp_server);

	return;
}
//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_import_device
 *
 *	description:	method to execute "DbImportDevice"
 *
 * @param	argin	
 * @return	
 *
 */
//+------------------------------------------------------------------
Tango::DevVarLongStringArray *DataBase::db_import_device(Tango::DevString device_name)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_devices=0, n_rows=0, n_svalues=0, n_lvalues=0, i, j, exported;
	char *tmp_device;
	Tango::DevVarLongStringArray *import_info = new Tango::DevVarLongStringArray;

	cout1 << "DataBase::ImportDevice(): get import info for " << device_name << " device " << endl;

	tmp_device = (char*)malloc(strlen(device_name)+1);
	sprintf(tmp_device,"%s",device_name);
	for (i=0; i<strlen(tmp_device); i++) { 
		tmp_device[i] = tolower(tmp_device[i]);
	}

	sprintf(sql_query,"SELECT exported,ior,version FROM device WHERE name = \"%s\" ",
	        tmp_device);
	cout4 << "DataBase::ImportDevice(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::ImportDeviceList(): failed to query TANGO database for list of properties ";
	   cout << "for import info for device " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for import info of device for %s (error=%s)",tmp_device,mysql_error(&mysql));
	   free(tmp_device);
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::ImportDevice()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::ImportDeviceList(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   free(tmp_device);
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::ImportDevice()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::ImportDeviceList(): mysql_num_rows() " << n_rows << endl;

	if (n_rows > 0)
	{

	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::ImportDeviceList(): device[ "<< i << "] exported " << row[0] << " IOR  " << row[1] << " version " << row[2] << endl;
	      n_svalues = n_svalues+3;
	      (import_info->svalue).length(n_svalues);
	      (import_info->svalue)[n_svalues-3] = CORBA::string_dup(tmp_device);
	      (import_info->svalue)[n_svalues-2] = CORBA::string_dup(row[1]);
	      (import_info->svalue)[n_svalues-1] = CORBA::string_dup(row[2]);
	      exported = -1;
	      if (row[0] != NULL) sscanf(row[0],"%d",&exported);
	      n_lvalues++;
	      (import_info->lvalue).length(n_lvalues);
	      (import_info->lvalue)[n_lvalues-1] = exported;
	   }
	}
	else {
	     cout << "DataBase::ImportDevice(): device not defined !" << endl;
	     sprintf(error_mess,"device %s not defined in the database !",tmp_device);
	     mysql_free_result(result);
	     free(tmp_device);
	     Tango::Except::throw_exception((const char *)DB_DeviceNotDefined,
	     				    (const char *)error_mess,
					    (const char *)"DataBase::ImportDevice()");
	}
	mysql_free_result(result);
	free(tmp_device);

	return(import_info);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_add_server
 *
 *	description:	method to execute "DbAddServer"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_add_server(const Tango::DevVarStringArray *server_device_list)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
	char domain[256], family[256], member[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows=0, n_devices;
	const char *tmp_server, *tmp_class;
	char *tmp_device;

	if (server_device_list->length() < 3)
	{
	   cout << "DataBase::AddServer(): incorrect number of input arguments " << endl;
	   sprintf(error_mess,"incorrect no. of input arguments, needs at least 3 (server,device,class)");
	   Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::AddServer()");
	}
		
	cout1 << "DataBase::AddServer(): insert " << (*server_device_list)[0] << " server with device " << (*server_device_list)[1] << endl;
	tmp_server = (*server_device_list)[0];
	for (int i=0; i<(server_device_list->length()-1)/2; i++)
	{
		tmp_device = (char*)(*server_device_list)[i*2+1];
		tmp_class = (*server_device_list)[i*2+2];
		if (!check_device_name(&tmp_device))
		{
	   		sprintf(error_mess,"device name (%s) syntax error (should be [tango:][//instance/]domain/family/member)",tmp_device);
	   		Tango::Except::throw_exception((const char *)DB_IncorrectDeviceName,
						       (const char *)error_mess,
						       (const char *)"DataBase::AddServer()");
		}
		device_name_to_dfm(tmp_device, domain, family, member);

// first delete the tuple (device,name,count) from the property table

		sprintf(sql_query,"DELETE FROM device WHERE server=\"%s\" AND name=\"%s\" ",
	              	tmp_server,tmp_device);
		cout4 << "DataBase::AddServer(): sql_query " << sql_query << endl;
		if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
		{
	   		cout << "DataBase::AddServer(): failed to delete server from TANGO database ";
	   		cout << "for " << tmp_server << " " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   		sprintf(error_mess,"failed to delete server from TANGO database  for %s %s (error=%s)",tmp_server,tmp_device,mysql_error(&mysql));
	   		Tango::Except::throw_exception((const char *)DB_SQLError,
						       (const char *)error_mess,
						       (const char *)"DataBase::AddServer()");
		}

// then insert the new value for this tuple

		sprintf(sql_query,"INSERT INTO device SET name=\"%s\",domain=\"%s\",family=\"%s\",member=\"%s\",exported=0,ior=\"nada\",host=\"nada\",server=\"%s\",pid=0,class=\"nada\",version=0,started=NULL,stopped=NULL",
	         	tmp_device, domain, family, member, tmp_server);
		cout4 << "DataBase::AddServer(): sql_query " << sql_query << endl;

		if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
		{
	      		cout << "DataBase::AddServer(): failed to insert server into TANGO database ";
	      		cout << "for " << tmp_server << " " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	      		sprintf(error_mess,"failed to insert server into TANGO database  for %s/%s (error=%s)",tmp_server,tmp_device,mysql_error(&mysql));
	      		Tango::Except::throw_exception((const char *)DB_SQLError,
						       (const char *)error_mess,
						       (const char *)"DataBase::AddServer()");
		}
	}

	return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_add_device
 *
 *	description:	method to execute "DbAddDevice"
 *
 * @param	argin	
 *
 */
//+------------------------------------------------------------------
void DataBase::db_add_device(const Tango::DevVarStringArray *server_device)
{
	static char sql_query[512];
	static char error_mess[256];
	static char tmp_count_str[256];
 	static char domain[256], family[256], member[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows=0;
	const char *tmp_server, *tmp_class;
	char *tmp_device;

	if (server_device->length() != 3)
	{
	   cout << "DataBase::AddServer(): incorrect number of input arguments " << endl;
	   sprintf(error_mess,"incorrect no. of input arguments, needs 3 (server,device,class)");
	   Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::AddServer()");
	}
		
	cout1 << "DataBase::AddDevice(): insert " << (*server_device)[0] << " server with device " << (*server_device)[1] << endl;
	tmp_server = (*server_device)[0];
	tmp_device = (char*)(*server_device)[1];
	tmp_class = (*server_device)[2];
	if (!check_device_name(&tmp_device))
	{
	   sprintf(error_mess,"device name (%s) syntax error (should be [tango:][//instance/]domain/family/member)",tmp_device);
	   Tango::Except::throw_exception((const char *)DB_IncorrectDeviceName,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::AddDevice()");
	}
	device_name_to_dfm(tmp_device, domain, family, member);

// first delete the tuple (device,name) from the device table

	sprintf(sql_query,"DELETE FROM device WHERE name LIKE \"%s\"",
	              tmp_device);
	cout4 << "DataBase::AddDevice(): sql_query " << sql_query << endl;
	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::AddDevice(): failed to delete device from TANGO database ";
	   cout << "for " << tmp_server << " " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to delete device from TANGO database  for %s %s (error=%s)",tmp_server,tmp_device,mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::AddDevice()");
	}

// then insert the new value for this tuple

	sprintf(sql_query,"INSERT INTO device SET name=\"%s\",domain=\"%s\",family=\"%s\",member=\"%s\",exported=0,ior=\"nada\",host=\"nada\",server=\"%s\",pid=0,class=\"%s\",version=\"0\",started=NULL,stopped=NULL",
	tmp_device, domain, family, member, tmp_server,tmp_class);
	cout4 << "DataBase::AddServer(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	      cout << "DataBase::AddDevice(): failed to insert device into TANGO database ";
	      cout << "for " << tmp_server << " " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to insert device into TANGO database  for %s/%s (error=%s)",tmp_server,tmp_device,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::AddDevice()");
	}

// make sure the device server has an DServer device entry

	sprintf(sql_query,"DELETE FROM device WHERE server LIKE \"%s\" AND class LIKE \"DServer\"",
	              tmp_server);
	cout4 << "DataBase::AddDevice(): sql_query " << sql_query << endl;
	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::AddDevice(): failed to delete DServer from TANGO database ";
	   cout << "for " << tmp_server << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to delete DServer from TANGO database  for %s (error=%s)",tmp_server,mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::AddDevice()");
	}
	sprintf(sql_query,"INSERT INTO device SET name=\"dserver/%s\",domain=\"%s\",family=\"%s\",member=\"%s\",exported=0,ior=\"nada\",host=\"nada\",server=\"%s\",pid=0,class=\"DServer\",version=\"0\",started=NULL,stopped=NULL",
	tmp_server, domain, family, member, tmp_server,tmp_class);
	cout4 << "DataBase::AddServer(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	      cout << "DataBase::AddDevice(): failed to insert DServer into TANGO database ";
	      cout << "for " << tmp_server << " (error=" << mysql_error(&mysql) << ")" << endl;
	      sprintf(error_mess,"failed to insert DServer into TANGO database  for %s (error=%s)",tmp_server,mysql_error(&mysql));
	      Tango::Except::throw_exception((const char *)DB_SQLError,
	      				     (const char *)error_mess,
					     (const char *)"DataBase::AddDevice()");
	}

	return;
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::check_device_name(string *device_name)
// 
// description : 	utility function to check whether device name conforms
//			to the TANGO naming convention of 
//
//			[tango!taco:][//instance/]domain/family/member
//
// in :			string *device_name - device name
//
// out :		bool - true or false
//
//-----------------------------------------------------------------------------

bool DataBase::check_device_name(char **device_name_c_str)
{
	string device_name(*device_name_c_str);
	string::size_type index, index2;

	cout4 << "DataBase::check_device_name(): device_name in " << device_name << endl;

// check there are no special characters which could be interpreted
// as wildcards or which are otherwise excluded

	if (device_name.find('*') != string::npos) return false;

// check protocol - "tango:" | "taco:"
	
	if (device_name.substr(0,6) == "tango:")
	{
		device_name.erase(0,6);
	}
	else
	{
		if (device_name.substr(0,5) == "taco:")
		{
			device_name.erase(0,5);
		}
	}

// check instance - "//instance/"

	if (device_name.substr(0,2) == "//")
	{
		index = device_name.find('/',(string::size_type)2);
		if (index == 0 || index == string::npos)		
		{
			return false;
			
		}
		device_name.erase(0,index+1);
	}

// check name conforms to "D/F/M"

	index = device_name.find('/');
	index2 = device_name.find('/',index+1);

	if (index == 0 || index == string::npos || index2 == string::npos ||
	    index2-index <= 0 || device_name.length() - index2 <= 0)
	{
		return false;
	}

	*device_name_c_str = (char*)malloc(device_name.length()+1);
	device_name.copy(*device_name_c_str,device_name.length());
	(*device_name_c_str)[device_name.length()] = '\0';

	cout4 << "DataBase::check_device_name(): device_name out " << *device_name_c_str << endl;

	return true;
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::device_name_to_dfm(char *device_name,
//			          char **domain, char **family, char **member)
// 
// description : 	utility function to return domain, family and member
//			from device name. Assumes device name has (optional)
//			protocol and instance stripped off i.e. conforms
//			to domain/family/member
//
// in :			char *device_name - device name
//
// out :		bool - true or false
//
//-----------------------------------------------------------------------------

bool DataBase::device_name_to_dfm(char *device_name_c_str, char domain[], char family[], char member[])
{
	string device_name(device_name_c_str);
	string::size_type index, index2;

	cout4 << "DataBase::device_name_to_dfm() device name in " << device_name << endl;

	index = device_name.find('/');
	index2 = device_name.find('/', index+1);

	(device_name.substr(0,index)).copy(domain,index);
	domain[index] = '\0';

	(device_name.substr(index+1,index2-index)).copy(family,index2-index);
	family[index2-index-1] = '\0';

	(device_name.substr(index2+1)).copy(member,device_name.length()-index2);
	member[device_name.length()-index2-1] = '\0';

	cout4 << "DataBase::device_name_to_dfm() domain/family/member out " << domain << "/" << family << "/" << member << endl;

	return true;
}

//+----------------------------------------------------------------------------
//
// method : 		DataBase::replace_wildcard(char *wildcard_c_str)
// 
// description : 	utility method to replace all occurrences of
//			wildcards (*) with SQL wildcards % and to escape
//			all occurrences	of % and _ with \
//
// in :			string **wildcard_c_str - wildcard C string
//
// out :		void - nothing
//
//-----------------------------------------------------------------------------

string DataBase::replace_wildcard(const char *wildcard_c_str)
{
	string wildcard(wildcard_c_str);
	string::size_type index;

	cout4 << "DataBase::replace_wildcard() wildcard in " << wildcard << endl;
// escape %

	index = 0;
	while ((index = wildcard.find('%',index)) != string::npos)
	{
		wildcard.insert(index, 1, '\\');
		index = index+2;
	}

// escape _

	index = 0;
	while ((index = wildcard.find('_',index)) != string::npos)
	{
		wildcard.insert(index, 1, '\\');
		index = index+2;
	}

// replace wildcard * with %

	while ((index = wildcard.find('*')) != string::npos)
	{
		wildcard.replace(index, 1, 1, '%');
	}

	cout4 << "DataBase::replace_wildcard() wildcard out " << wildcard << endl;
	return wildcard;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_attribute_list
 *
 *	description:	method to execute "DbGetDeviceAttributeList"
 *	return list of attributes for device which match the
 *	wildcard
 *
 * @param	argin	device name
 * @return	attribute wildcard
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_attribute_list(const Tango::DevVarStringArray *device_wildcard)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_wildcard;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;
	const char *device, *wildcard;

	device = (*device_wildcard)[0];
	wildcard = (*device_wildcard)[1];
	cout1 << "DataBase::db_get_device_attribute_list(): device " << device;
	cout << " wildcard " << wildcard << endl;

	if (wildcard == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT attribute FROM property_attribute_device WHERE device=\"%s\" AND attribute LIKE \"%\" ORDER BY attribute",device);
	}
	else
	{
		tmp_wildcard = replace_wildcard (wildcard);
		sprintf(sql_query,"SELECT DISTINCT attribute FROM property_attribute_device WHERE device=\"%s\" AND attribute LIKE \"%s\" ORDER BY attribute",
	        device,tmp_wildcard.c_str());
	}
	cout4 << "DataBase::db_get_device_attrribute_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_attribute_list(): failed to query TANGO database for list of properties";
	   cout << device << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of properties (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_attribute_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_attribute_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_attribute_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_attribute_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *attribute_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   attribute_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_attribute_list(): attribute[ "<< i << "] attribute " << row[0] << endl;
	         (*attribute_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(attribute_list);
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_server
 *
 *	description:	method to execute "DbDeleteServer"
 *	delete server from the database, do not delete device properties
 *
 * @param	argin	server name
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_server(Tango::DevString server)
{
	static char sql_query[512];
	static char error_mess[256];

	cout1 << "DataBase::db_delete_server(): delete server " << server << " from database" << endl;

// first check the server name that it has no wildcard '*' and
// that it has at least one slash in it

	string tmp_server = string(server);

	if ((tmp_server.find('*') != string::npos) || 
	    (tmp_server.find('%') != string::npos) ||
	    (tmp_server.find('/') == string::npos))
	{
         	cout << "DataBase::db_delete_server(): server name  " << server << "incorrect ";
         	cout << endl;
         	sprintf(error_mess,"failed to delete server, server name incorrect %s",server);
         	Tango::Except::throw_exception((const char *)DB_IncorrectServerName,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_server()");
	}

	tmp_server = replace_wildcard(server);

// then delete the device from the device table

      sprintf(sql_query,"DELETE FROM device WHERE server LIKE \"%s\"",
              tmp_server.c_str());
      cout4 << "DataBase::db_delete_server(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_server(): failed to delete server from TANGO database ";
         cout << "for " << server << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete server from TANGO database  for %s (error=%s)",server,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_server()");
      }

}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_device
 *
 *	description:	method to execute "DbDeleteDevice"
 *
 * @param	argin	device name
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_device(Tango::DevString device)
{
	static char sql_query[512];
	static char error_mess[256];
	char *tmp_device;

	cout1 << "DataBase::db_delete_device(): delete " << device << " from database" << endl;

// first check the device name

	tmp_device = (char*)device;
	if (!check_device_name(&tmp_device))
	{
         	cout << "DataBase::db_delete_device(): device name  " << device << " incorrect ";
         	cout << endl;
         	sprintf(error_mess,"failed to delete device, device name incorrect %s",tmp_device);
         	Tango::Except::throw_exception((const char *)DB_IncorrectDeviceName,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_device()");
	}

// replace database wildcards (% and _)

	string tmp_wildcard = replace_wildcard(tmp_device);

// then delete the device from the device table

      sprintf(sql_query,"DELETE FROM device WHERE name LIKE \"%s\"",
              tmp_wildcard.c_str());
      cout4 << "DataBase::db_delete_device(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_device(): failed to delete property from TANGO database ";
         cout << "for " << device << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete property from TANGO database  for %s (error=%s)",device,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_device()");
      }

// then delete device from the property_device table

      sprintf(sql_query,"DELETE FROM property_device WHERE device LIKE \"%s\"",
              tmp_wildcard.c_str());
      cout4 << "DataBase::db_delete_device(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_device(): failed to delete property from TANGO database ";
         cout << "for " << device << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete property from TANGO database  for %s (error=%s)",device,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_device()");
      }

// then delete device from the property_attribute_device table

      sprintf(sql_query,"DELETE FROM property_attribute_device WHERE device LIKE \"%s\"",
              tmp_wildcard.c_str());
      cout4 << "DataBase::db_delete_device(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_device(): failed to delete property from TANGO database ";
         cout << "for " << device << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete property from TANGO database  for %s (error=%s)",device,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_device()");
      }

      return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_device_attribute
 *
 *	description:	method to execute "DbDeleteDeviceAttribute"
 *	delete a device attribute and all its properties from
 *	the database
 *
 * @param	argin	device, attribute
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_device_attribute(const Tango::DevVarStringArray *argin)
{
	const char *attribute;
	char *tmp_device;
	static char sql_query[512];
	static char error_mess[256];

	if (argin->length() < 2) {
   		cout << "DataBase::db_delete_device_attribute(): insufficient number of arguments ";
   		cout << endl;
   		sprintf(error_mess,"insufficient number of arguments to delete device attribute");
   		Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_device_attribute()");
	}

	tmp_device = (char*)(*argin)[0];
	attribute = (*argin)[1];

	cout1 << "DataBase::db_delete_device(): delete " << tmp_device << " from database" << endl;

// first check the device name

	if (!check_device_name(&tmp_device))
	{
         	cout << "DataBase::db_delete_device_attribute(): device name  " << tmp_device << " incorrect ";
         	cout << endl;
         	sprintf(error_mess,"failed to delete device attribute, device name incorrect %s",tmp_device);
         	Tango::Except::throw_exception((const char *)DB_IncorrectDeviceName,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_device_attribute()");
	}

// replace database wildcards (% and _)

	string tmp_wildcard = replace_wildcard(tmp_device);

// then delete device from the property_attribute_device table

      sprintf(sql_query,"DELETE FROM property_attribute_device WHERE device LIKE \"%s\" AND attribute LIKE \"%s\" ",
              tmp_wildcard.c_str(),attribute);
      cout4 << "DataBase::db_delete_device_attribute(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_device_attribute(): failed to delete attribute from TANGO database ";
         cout << "for " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete attribute from TANGO database  for %s (error=%s)",tmp_device,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_device_attribute()");
      }

      return;

}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_device_attribute_property
 *
 *	description:	method to execute "DbDeleteDeviceAttributeProperty"
 *	delete a device attribute property from the database
 *
 * @param	argin	device, attribute, property
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_device_attribute_property(const Tango::DevVarStringArray *argin)
{
	const char *attribute, *property;
	char *tmp_device;
	static char sql_query[512];
	static char error_mess[256];

	if (argin->length() < 3) {
   		cout << "DataBase::db_delete_device_attribute_property(): insufficient number of arguments ";
   		cout << endl;
   		sprintf(error_mess,"insufficient number of arguments to delete device attribute property");
   		Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_device_attribute_property()");
	}

	tmp_device = (char*)(*argin)[0];
	attribute = (*argin)[1];
	property = (*argin)[2];

	cout1 << "DataBase::db_delete_device_attribute_property(): delete device " << tmp_device ;
	cout1 << " attribute " << attribute << " property " << property << " from database" << endl;

// first check the device name

	if (!check_device_name(&tmp_device))
	{
         	cout << "DataBase::db_delete_device_attribute(): device name  " << tmp_device << " incorrect ";
         	cout << endl;
         	sprintf(error_mess,"failed to delete device attribute, device name incorrect %s",tmp_device);
         	Tango::Except::throw_exception((const char *)DB_IncorrectDeviceName,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_delete_device_attribute()");
	}

// replace database wildcards (% and _)

	string tmp_wildcard = replace_wildcard(tmp_device);

// then delete device from the property_attribute_device table

      sprintf(sql_query,"DELETE FROM property_attribute_device WHERE device LIKE \"%s\" AND attribute LIKE \"%s\" AND name LIKE \"%s\" ",
              tmp_wildcard.c_str(),attribute,property);
      cout4 << "DataBase::db_delete_device_attribute_property(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_device_attribute_property(): failed to delete attribute property from TANGO database ";
         cout << "for " << tmp_device << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete attribute property from TANGO database  for %s (error=%s)",tmp_device,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_device_attribute_property()");
      }

      return;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::dev_get_server_info
 *
 *	description:	method to execute "DbGetServerInfo"
 *	return info about host, mode and level for specified server
 *
 * @param	argin	server name
 * @return	server info
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::dev_get_server_info(Tango::DevString server_name)
{
	static char sql_query[256];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows=0, i;
	Tango::DevVarStringArray *server_info = new Tango::DevVarStringArray;
	const char *tmp_object;
	string tmp_name;

	cout1 << "DataBase::db_get_server_info(): server " << server_name << endl;

	server_info->length(4);
	(*server_info)[0] = CORBA::string_dup(server_name);

	tmp_name = replace_wildcard(server_name);
	sprintf(sql_query,"SELECT host,mode,level FROM server WHERE name LIKE \"%s\"",
	        tmp_name.c_str());
	cout4 << "DataBase::db_get_server_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   delete (*server_info)[0];
	   delete server_info;
	   cout << "DataBase::db_get_server_info(): failed to query TANGO database for server info";
	   cout << "for " << server_name << "/" << server_name << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for server info for %s (error=%s)",tmp_name.c_str(),mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_server_info()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   delete (*server_info)[0];
	   delete server_info;
	   cout << "DataBase::db_get_server_info(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_server_info()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_server_info(): mysql_num_rows() " << n_rows << endl;
	if (n_rows > 0)
	{
	   if ((row = mysql_fetch_row(result)) != NULL)
	   {
	      cout4 << "DataBase::db_get_server_info(): host "<< row[0] << " mode " << row[1] << " level " << row[2] << endl;
	      (*server_info)[1] = CORBA::string_dup(row[0]);
	      (*server_info)[2] = CORBA::string_dup(row[1]);
	      (*server_info)[3] = CORBA::string_dup(row[2]);
	   }
	}
	else
	{
	   (*server_info)[1] = CORBA::string_dup(" ");
	   (*server_info)[2] = CORBA::string_dup(" ");
	   (*server_info)[3] = CORBA::string_dup(" ");
	}
	mysql_free_result(result);

	return server_info;
}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_put_server_info
 *
 *	description:	method to execute "DbPutServerInfo"
 *	update server info including host, mode and level
 *
 * @param	argin	server info
 *
 */
//+------------------------------------------------------------------
void DataBase::db_put_server_info(const Tango::DevVarStringArray *server_info)
{
	static char sql_query[4096];
	static char error_mess[256];
	MYSQL_RES *result;
	MYSQL_ROW row;
	long n_rows=0, i, j;
	const char *tmp_host, *tmp_mode, *tmp_level;
	string tmp_server;


	if (server_info->length() < 4) {
   		cout << "DataBase::db_put_server_info(): insufficient info for server ";
   		cout << endl;
   		sprintf(error_mess,"insufficient server info");
   		Tango::Except::throw_exception((const char *)DB_IncorrectArguments,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_put_server_info()");
	}
	
	cout1 << "DataBase::db_put_server_info(): put " << server_info->length()-1 << " export info for device " << (*server_info)[0] << endl;

	tmp_server = (*server_info)[0];
// replace database wildcards (% and _)
	string tmp_wildcard = replace_wildcard(tmp_server.c_str());
// replace uppercase by lowercase
	for (i=0; i<tmp_server.length(); i++) { 
		tmp_server[i] = tolower(tmp_server[i]);
	}
	tmp_host = (*server_info)[1];
	tmp_mode = (*server_info)[2];
	tmp_level = (*server_info)[3];

// first delete the server from the device table

      sprintf(sql_query,"DELETE FROM server WHERE name LIKE \"%s\"",
              tmp_wildcard.c_str());
      cout4 << "DataBase::db_put_server_info(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_put_server_info(): failed to delete property from TANGO database ";
         cout << "for " << tmp_server << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete server from TANGO database  for %s (error=%s)",tmp_server.c_str(),mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_put_server_info()");
      }

// insert the new info for this server

	sprintf(sql_query,"INSERT INTO server SET name=\'%s\',host=\'%s\',mode=\'%s\',level=\'%s\'",
        	tmp_wildcard.c_str(),tmp_host, tmp_mode, tmp_level);
	cout4 << "DataBase::db_put_server_info(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
   		cout << "DataBase::db_put_server_info(): failed to insert server info into TANGO database ";
   		cout << "for " << tmp_server << " (error=" << mysql_error(&mysql) << ")" << endl;
   		sprintf(error_mess,"failed to insert server info into TANGO database for %s",tmp_server.c_str());
   		Tango::Except::throw_exception((const char *)DB_SQLError,
					       (const char *)error_mess,
					       (const char *)"DataBase::db_put_server_info()");
	}

	return;

}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_delete_server_info
 *
 *	description:	method to execute "DbDeleteServerInfo"
 *	delete info related to a server
 *
 * @param	argin	server name
 *
 */
//+------------------------------------------------------------------
void DataBase::db_delete_server_info(Tango::DevString server_name)
{
	static char sql_query[512];
	static char error_mess[256];

	cout1 << "DataBase::db_delete_server_info(): delete " << server_name << " from database" << endl;

// replace database wildcards (% and _)

	string tmp_wildcard = replace_wildcard(server_name);

// then delete the device from the device table

      sprintf(sql_query,"DELETE FROM server WHERE name LIKE \"%s\"",
              tmp_wildcard.c_str());
      cout4 << "DataBase::db_delete_server_info(): sql_query " << sql_query << endl;
      if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
      {
         cout << "DataBase::db_delete_server_info(): failed to delete property from TANGO database ";
         cout << "for " << server_name << " (error=" << mysql_error(&mysql) << ")" << endl;
         sprintf(error_mess,"failed to delete property from TANGO database  for %s (error=%s)",server_name,mysql_error(&mysql));
         Tango::Except::throw_exception((const char *)DB_SQLError,
	 				(const char *)error_mess,
					(const char *)"DataBase::db_delete_server_info()");
      }

      return;

}

//+------------------------------------------------------------------
/**
 *	method:	DataBase::db_get_device_exported_list
 *
 *	description:	method to execute "DbGetDeviceExportedList"
 *	Get a list of exported devices whose names satisfy the filter (wildcard is *).
 *
 * @param	argin	filter
 * @return	list of exported devices
 *
 */
//+------------------------------------------------------------------
Tango::DevVarStringArray *DataBase::db_get_device_exported_list(Tango::DevString filter)
{
	static char sql_query[256];
	static char error_mess[256];
	string tmp_filter;
	MYSQL_RES *result;
	MYSQL_ROW row;
	int n_rows, i;

	cout1 << "DataBase::db_get_device_exported_list(): filter " << filter << endl;

	if (filter == NULL)
	{
		sprintf(sql_query,"SELECT DISTINCT name FROM device WHERE name LIKE \"%\" AND exported=1 ORDER BY name");
	}
	else
	{
		tmp_filter = replace_wildcard(filter);
		sprintf(sql_query,"SELECT DISTINCT name FROM device WHERE name LIKE \"%s\" AND exported=1 ORDER BY name",
	        tmp_filter.c_str());
	}
	cout4 << "DataBase::db_get_device_exported_list(): sql_query " << sql_query << endl;

	if (mysql_real_query(&mysql, sql_query, strlen(sql_query)) != 0)
	{
	   cout << "DataBase::db_get_device_exported_list(): failed to query TANGO database for list of exported devices";
	   cout << filter << " (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"failed to query TANGO database for list of exported devices (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_exported_list()");
	}

	if ((result = mysql_store_result(&mysql)) == NULL)
	{
	   cout << "DataBase::db_get_device_exported_list(): mysql_store_result() failed  (error=" << mysql_error(&mysql) << ")" << endl;
	   sprintf(error_mess,"mysql_store_result() failed (error=%s)",mysql_error(&mysql));
	   Tango::Except::throw_exception((const char *)DB_SQLError,
	   				  (const char *)error_mess,
					  (const char *)"DataBase::db_get_device_exported_list()");
	}

	n_rows = mysql_num_rows(result);
	cout4 << "DataBase::db_get_device_exported_list(): mysql_num_rows() " << n_rows << endl;
	Tango::DevVarStringArray *device_list = new Tango::DevVarStringArray;

	if (n_rows > 0)
	{
	   device_list->length(n_rows);

	   for (i=0; i<n_rows; i++)
	   {
	      if ((row = mysql_fetch_row(result)) != NULL)
	      {
	         cout4 << "DataBase::db_get_device_exported_list(): device_list[ "<< i << "] alias " << row[0] << endl;
	         (*device_list)[i]   = CORBA::string_dup(row[0]);
	      }
	   }
	}
	mysql_free_result(result);

	return(device_list);
}
}
