//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/test/RCS/TestDatabase.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: TestDatabase.java,v $
// Revision 1.1  2000/11/09 09:05:54  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================


 

import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;
import TangoApi.*;
import java.io.*;
import java.util.*;

/** 
 *	Class Description:
 *	This class manage Tango device access.
 *
 * @author  verdier
 * @Revision 
 */


public class TestReconnection
{

	private static double[] read_temp()
	{
		double[] temp;
		temp = new double[5];
		for(int i=0 ; i<5 ; i++)
			temp[i] = 30.12345 + i;
		return temp;
	}


	//======================================================
	/**
	 *	Buid a String with DevFailed exception.
	 *
	 *	@param e	DevFailed exception object.
	 *	@return 	the String object buit with reason
	 *					and origin of exception.
	 */
	//======================================================
	private static String getDevFailedString(DevFailed e)
	{
		StringBuffer	sb = new StringBuffer(e.toString() + ":\n");
		
		for (int i=0 ; i<e.errors.length ; i++)
			sb.append(e.errors[i].reason + "\nFrom " + e.errors[i].origin + "\n");

		return sb.toString();
	}

	//===============================================
	/**
	 *	Just a main method to check API methods.
	 */
	//===============================================
	public static void main (String args[])
	{
		PrintStream	out = System.out;
		out.println("Running...");
		try
		{
			DeviceData	data = new DeviceData();
			Database	db = ApiUtil.get_db_obj();
			db.set_timeout(2);

			String	devname = "pv/check/1";
			DeviceProxy	dev = new DeviceProxy(devname);
			while (true)
			{
				try
				{
					DeviceData	argout = dev.command_inout("DevRead");
					System.out.println(argout.extractString());
				}
				catch (DevFailed e)
				{
					System.out.println(getDevFailedString(e));
				}
				try { Thread.sleep(1000);}catch(Exception e){}
			}
		}
		catch (DevFailed e)
		{
			System.out.println(getDevFailedString(e));
			//e.printStackTrace();
		}
	}
}
