//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/test/RCS/TestDatabase.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: TestDatabase.java,v $
// Revision 1.1  2000/11/09 09:05:54  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================


 

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;
import java.io.*;
import java.util.*;

/** 
 *	Class Description:
 *	This class manage Tango device access.
 *
 * @author  verdier
 * @Revision 
 */


public class TestDatabase
{

	public TestDatabase()
	{
	}

	private static double[] read_temp()
	{
		double[] temp;
		temp = new double[5];
		for(int i=0 ; i<5 ; i++)
			temp[i] = 30.12345 + i;
		return temp;
	}


	//======================================================
	/**
	 *	Buid a String with DevFailed exception.
	 *
	 *	@param e	DevFailed exception object.
	 *	@return 	the String object buit with reason
	 *					and origin of exception.
	 */
	//======================================================
	private static String getDevFailedString(DevFailed e)
	{
		StringBuffer	sb = new StringBuffer(e.toString() + ":\n");
		
		for (int i=0 ; i<e.errors.length ; i++)
			sb.append(
			e.errors[i].reason + "\n" + 
			e.errors[i].desc + "\nFrom " +
			e.errors[i].origin + "\n");

		return sb.toString();
	}

	public synchronized void sleep(long ms)
	{
		try
		{
			wait(ms);
		}
		catch(InterruptedException e) {}
	}
	//===============================================
	/**
	 *	Just a main method to check API methods.
	 */
	//===============================================
	public static void main (String args[])
	{
		try
		{
			DeviceData	data = new DeviceData();

			Database	db = ApiUtil.get_db_obj();
			db.set_timeout(1234);
			System.out.println("Connecterd on " + db.get_name());
			System.out.println("	timeout= " +  db.get_timeout());
			
for (int j=0 ; j<1 ; j++)
{
	try
	{
			System.out.println ("get_device_class_list:");
			DbServer	server = new DbServer("OPCserver/premium1");
			String[]	classes = server.get_device_class_list();
			for(int i=0 ; i<classes.length ; i+=2)
				System.out.println (classes[i] + "\t-\t" + classes[i+1]);
			System.out.println("");
	}
	catch (DevFailed e)
	{
		System.out.println(getDevFailedString(e));
	}
	TestDatabase	tst = new TestDatabase();
	tst.sleep(5000);
}

			String[]	hosts = db.get_host_list();
			for(int i=0 ; i<hosts.length ; i++)
				System.out.println("	"+hosts[i]);


			DbClass	_class = new DbClass("Starter");
			String[] class_prop = _class.get_property_list("*");
			System.out.println ("_class.get_property_list():");
			for(int i=0 ; i< class_prop.length ; i++)
				System.out.println("\t"+ class_prop[i]);
			System.out.println ();
			
			DbDatum	datum = _class.get_property("NbStartupLevels");
			if (datum.is_empty()==false)
				System.out.println("For Class Starter\n	NbStartupLevels = " +
										datum.extractShort());

			String		devname = "tango/admin/corvus";
			DeviceProxy	dev = new DeviceProxy(devname,"tango", "20000");

			String[] dev_prop = dev.get_property_list("*");
			System.out.println ("dev.get_property_list():");
			for(int i=0 ; i< dev_prop.length ; i++)
				System.out.println("\t"+ dev_prop[i]);
			System.out.println ();

			datum = dev.get_property("startDsPath");
			if (datum.is_empty()==false)
				System.out.println("	startDsPath = " +
										datum.extractString());


			DevCmdInfo[]	cmd = dev.command_list_query();

			data = dev.command_inout("DevStatus");

			System.out.println("\n\n"+ devname + " "+ data.extractString());
			for(int i=0 ; i<cmd.length ; i++)
				System.out.println("	"+cmd[i].cmd_name+"("+
									cmd[i].in_type + ", " +
									cmd[i].out_type + ")");

			data.insert(true);
			data = dev.command_inout("DevGetRunningServers", data);

			String[]	serv = data.extractStringArray();
			System.out.println("\n\nDevGetRunningServers");
			for(int i=0 ; i<serv.length ; i++)
				System.out.println("	"+serv[i]);

		}
		catch (DevFailed e)
		{
			System.out.println("\nTestDatabase exception catched:");
			System.out.println(getDevFailedString(e));
			//e.printStackTrace();
		}
	}
}
