//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/DeviceProxy.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: DeviceProxy.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Revision 1.2  2000/11/10 13:02:13  verdier
// The TangoApi package is now compatible TANGO 2.
//
// Revision 1.1  2000/11/09 09:10:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import TangoDs.*;


/**
 *	Class Description:
 *	This class manage device connection for Tango objects.
 *	It is an api between user and IDL Device object.
 *
 * @author  verdier
 * @Revision 
 */


public class DeviceProxy extends Connection
{
	/**
	 *	Device name.
	 */
	private String	devname;
	/**
	 *	DbDevice object to make an agregat..
	 */
	private DbDevice	db_dev;

	//===================================================================
	/**
	 *	TangoDevice constructor. It will import the device.
	 *
	 *	@param	devname	name of the device to be imported.
	 */
	//===================================================================
	public DeviceProxy(String devname)	throws DevFailed
	{
		super(devname);
		this.devname = new String(devname);
	}
	//===========================================================
	/**
	 *	return the device name.
	 */
	//===========================================================
	public String name()
	{
		return devname;
	}



	//===========================================================
	//	The following methods are an agrega of DbDevice
	//===========================================================

	//==========================================================================
	/**
	 *	Query the database for the export info of this device.
	 *	@return the information in a DbDevImportInfo.
	 */
	//==========================================================================
	public DbDevImportInfo import_device()
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.import_device();
	}
	//==========================================================================
	/**
	 *	Update the export info for this device in the database.
	 *	@param devinfo	Device information to export.
	 */
	//==========================================================================
	public void export_device(DbDevExportInfo devinfo)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.export_device(devinfo);
	}
	//==========================================================================
	/**
	 *	Add/update this device to the database
	 *	@param devinfo The device name, class and server  specified in object.
	 */
	//==========================================================================
	public void add_device(DbDevInfo devinfo) throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.add_device(devinfo);
	}
	//==========================================================================
	/**
	 *	Delete this device from the database
	 */
	//==========================================================================
	public void delete_device() throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_device();
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device properties for this device.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(String[] propnames)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_property(propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for a device property for this device.
	 *	@param propname property name.
	 *	@retun property in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum get_property(String propname)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_property(propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device properties for this device.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_property(properties);
	}

	//==========================================================================
	/**
	 *	Insert or update a list of properties for this device
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.put_property(properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this device.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_property(String[] propnames)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_property(propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this device.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_property(String propname)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_property(propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this device.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_property(properties);
	}


	//==========================================================================
	/**
	 *	Insert or update a list of properties for this device attribute.
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.put_attribute_property(properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_attribute_property(String[] propnames)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_attribute_property(propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this object.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_attribute_property(String propname)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_attribute_property(propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		db_dev.delete_attribute_property(properties);
	}

	//==========================================================================
	/**
	 *	Query the database for a list of device attribute
	 *	properties for this device.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(String[] propnames)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_attribute_property(propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for a device attribute
	 *	property for this device.
	 *	@param propname list of property name.
	 *	@retun property in DbDatum object.
	 */
	//==========================================================================
	public DbDatum get_attribute_property(String propname)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_attribute_property(propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device attribute
	 *	properties for this device.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		if (db_dev==null)	db_dev = new DbDevice(devname);
		return db_dev.get_attribute_property(properties);
	}
}
