//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/DbServer.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: DbServer.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Revision 1.2  2000/11/10 13:02:13  verdier
// The TangoApi package is now compatible TANGO 2.
//
// Revision 1.1  2000/11/09 09:10:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import TangoDs.*;


/**
 *	Class Description:
 *	This class manage database connection for Tango server.
 *
 * @author  verdier
 * @Revision 
 */


public class DbServer
{
	/**
	 *	Database object used for TANGO databse access.
	 */
	private Database	dbase;

	/**
	 *	Device name used to access database if device not exported.
	 */
	private String servname;

	//===================================================================
	/**
	 *	DbServer constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	servname		Name of the class oject.
	 */
	//===================================================================
	public DbServer(String servname) throws DevFailed
	{
		//	Access the database and get device server info
		//--------------------------------------------------
		dbase = ApiUtil.get_db_obj();
		this.servname = new String(servname);
	}

	//==========================================================================
	/**
	 *	Query the database for server information.
	 *	@return	The information found for this server
	 *				in a DBServInfo object.
	 */
	//==========================================================================
	public DbServInfo get_info() throws DevFailed
	{
		return dbase.get_server_info(servname);
	}

	//==========================================================================
	/**
	 *	Add/update server information in databse.
	 *	@param info	Server information for this server
	 *					in a DbServinfo object.
	 */
	//==========================================================================
	public void put_info(DbServInfo info) throws DevFailed
	{
		dbase.put_server_info(info);
	}

	//===========================================================
	/**
	 *	return the server name.
	 */
	//===========================================================
	public String name()
	{
		return servname;
	}
}
