//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/DbServInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: DbServInfo.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Revision 1.2  2000/11/10 13:02:13  verdier
// The TangoApi package is now compatible TANGO 2.
//
// Revision 1.1  2000/11/09 09:10:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

/**
 *	Class Description:
 *	This class describe server information.
 *
 * @author  verdier
 * @Revision 
 */


public class DbServInfo
{
	/**
	 *	Server name.
	 */
	public String	name;
	/**
	 *	Host where registred.
	 */
	public String	host;
	/**
	 *	True if server is controled by the TANGO manager (Astor).
	 */
	public boolean	controled;
	/**
	 *	Level used for automatic startup.
	 *	No automatic startup if level is null or negative.
	 */
	public int	startup_level;

	//=========================================================
	/**
	 *	Default constructor.
	 *	@param	name	servername (i.e. "Starter/corvus").
	 */
	//=========================================================
	public DbServInfo(String name)
	{
		this.name          = new String(name);
		this.host          = "";
		this.controled     = false;
		this.startup_level = 0;
	}
	//=========================================================
	/**
	 *	Complete constructor.
	 *	@param	name		Server name (i.e. "Starter/corvus").
	 *	@param	host		Host name to register the server.
	 *	@param	controled	True if server must controled by
	 *							the TANGO manager (Astor).
	 *	@param	level		Level used for automatic startup.
	 *			No automatic startup if level is null or negative.
	 */
	//=========================================================
	public DbServInfo(String name, String host, boolean controled, int level)
	{
		this.name          = new String(name);
		this.host          = new String(host);
		this.controled     = controled;
		this.startup_level = level;
	}
	//=========================================================
	/**
	 *	Default constructor.
	 *	@param	info	String array containing object field as String.
	 */
	//=========================================================
	public DbServInfo(String[] info)
	{
		//	Fixe default values
		//---------------------------
		this.name          = new String(info[0]);
		this.host          = "";
		this.controled     = false;
		this.startup_level = 0;

		//	Set fields to array items if exist
		//-------------------------------------------
		if (info.length>1)
			this.host      = new String(info[1]);
		
		if (info.length>2)
		{
			try
			{
				Integer	i = new Integer(info[2]);
				this.controled = (i.intValue()==1)? true : false;
			}
			catch(NumberFormatException e) {}
		}
		
		
		if (info.length>3)
		{
			try
			{
				Integer i = new Integer(info[3]);
				this.startup_level = i.intValue();
			}
			catch(NumberFormatException e) {}
		}
	}
	//=========================================================
	/**
	 *	Dinsplay server info on a single line.
	 */
	//=========================================================
	public String toString()
	{
		StringBuffer	sb = new StringBuffer(name + "  (on " + host + ")  ");
		
		if (controled)
			sb.append("controled");
		else
			sb.append("not controled");
		sb.append("   startup level: " + startup_level);
		return sb.toString();
	}
}
