//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/DbDevImportInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: DbDevImportInfo.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;
 

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import java.io.*;
import java.util.*;

/** 
 *	Class Description:
 *	This class is an object containing the imported device information.
 *
 * @author  verdier
 * @Revision 
 */


public class DbDevImportInfo
{
	/**
	 *	The devivce name.
	 */
	public String	name;
	/**
	 *	ior connection as String.
	 */
	public String	ior;
	/**
	 *	TANGO protocol version number.
	 */
	public String	version;
	/**
	 *	true if device is exported.
	 */
	public boolean	exported;

	//===============================================
	/**
	 *	Default constructor.
	 */
	//===============================================
	public DbDevImportInfo()
	{
	}
	//===============================================
	/**
	 *	Complete constructor.
	 */
	//===============================================
	public DbDevImportInfo(DevVarLongStringArray info)
	{
		name     = new String(info.svalue[0]);
		ior      = new String(info.svalue[1]);
		version  = new String(info.svalue[2]);
		exported = (info.lvalue[0]==1);
	}
	
	//===============================================
	//===============================================
	public String toString()
	{
		StringBuffer	sb = new StringBuffer("");

		sb.append("name     = " + name + "\n");
		sb.append("version  = " + version + "\n");
		sb.append("Exported = " + exported + "\n");
		sb.append("IOR      = " + ior);
		return sb.toString();
	}
}
