//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/DbDevExportInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: DbDevExportInfo.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;
 

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import java.io.*;
import java.util.*;

/** 
 *	Class Description:
 *	This class is an object containing the exported device information.
 *
 * @author  verdier
 * @Revision 
 */


public class DbDevExportInfo
{
	/**
	 *	The devivce name.
	 */
	public String	name;
	/**
	 *	The server name.
	 */
	public String	server;
	/**
	 *	ior connection as String.
	 */
	public String	ior;
	/**
	 *	Host name where device will be exported.
	 */
	public String	host;
	/**
	 *	TANGO protocol version number.
	 */
	public String	version;
	/**
	 *	process pid.
	 */
	private int	pid;

	//===============================================
	/**
	 *	Default constructor.
	 */
	//===============================================
	public DbDevExportInfo()
	{
	}
	//===============================================
	/**
	 *	Complete constructor (pid does not exit in java).
	 */
	//===============================================
	public DbDevExportInfo(String name, String server, String ior,
										String host, String version)
	{
		this.name     = new String(name);
		this.server   = new String(server);
		this.ior      = new String(ior);
		this.host     = new String(host);
		this.version  = new String(version);
		this.pid      = 0;
	}
	//===============================================
	/**
	 *	Serialise object data to a string array data.
	 */
	//===============================================
	public String[] toStringArray()
	{
		String[]	argout;
		argout = new String[6];
		int	i=0;
		argout[i++] = name;
		argout[i++] = server;
		argout[i++] = ior;
		argout[i++] = host;
		argout[i++] = version;
		argout[i++] = "0";
		return argout;
	}
}
