//+======================================================================
// $Source: /segfs/tango/tools/TangoApi/RCS/ApiUtil.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.1 $
//
// $Log: ApiUtil.java,v $
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import TangoDs.*;
import java.io.*;
import java.util.*;


/**
 *	Class Description:
 *	This class manage a static vector of Database object.
 *
 * @author  verdier
 * @Revision 
 */

public class ApiUtil
{
	static private Vector	db_list = null;
	/**
	 * 	ORB object reference for connection.
	 */
	protected static ORB	orb = null;
	

	public ApiUtil() throws DevFailed
	{
	}

	//===================================================================
	/**
	 *	Return the database object created
	 *	with TANGO_HOST environment variable .
	 */
	//===================================================================
	public static Database get_db_obj() throws DevFailed
	{
		if (orb==null)
			create_orb();

		//	If first time, create Database object and put it in vector
		//---------------------------------------------------------------
		if (db_list==null)
		{
			db_list = new Vector();
			db_list.addElement(new Database());
		}
		return (Database) db_list.elementAt(0);
	}
	//===================================================================
	/**
	 *	Create the orb object
	 */
	//===================================================================
	private static void create_orb() throws DevFailed
	{
			try
			{
				//	Modified properties fo ORB usage.
				//	Requiered for JDK 1.2 and later.
				//---------------------------------------
				Properties props = System.getProperties();
				props.put("org.omg.CORBA.ORBClass","com.ooc.CORBA.ORB");
				props.put("org.omg.CORBA.ORBSingletonClass","com.ooc.CORBA.ORBSingleton");
				System.setProperties(props);

				//	Initialize ORB
				//-----------------------------
				String[] args = new String[1];
				args[0] = new String("pascal");
				orb = ORB.init(args, props);
			}
			catch(SystemException ex)
			{
				orb = null;
				TangoUtil.throw_exception("DbGet: ORB failed !",
												"ApiUtilcreate_orb()");
			}
	}
	//===================================================================
	/**
	 *	Return the orb object
	 */
	//===================================================================
	public static ORB get_orb() throws DevFailed
	{
		if (orb==null)
			create_orb();
		return orb;
	}
}
