//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/DeviceData.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: DeviceData.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;

 
/** 
 *	Class Description:
 *	This class manage data object for Tango device access.
 *
 * @author  verdier
 * @Revision 
 */


public class DeviceData
{
	private	 Any	any;

	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@trows DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData() throws DevFailed
	{
		any = ApiUtil.get_orb().create_any();
	}
	
	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@param orb	orb connection id.
	 *	@trows DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData(ORB orb) throws DevFailed
	{
		any = orb.create_any();
	}
	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@param any	CORBA Any reference to be used in DeviceData.
	 *	@trows DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData(Any any) throws DevFailed
	{
		this.any = any;
	}



	//**********	Insert Methods for basic types *********************
	
	
	//===========================================
	/**
	 *	Insert method for argin is void.
	 */
	//===========================================
	public void insert()
	{
	}
	//===========================================
	/**
	 *	Insert method for argin is Any (CORBA).
	 */
	//===========================================
	public void insert(Any any)
	{
		this.any = any;
	}
	//===========================================
	/**
	 *	Insert method for argin is boolean.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(boolean argin)
	{
		DevBooleanHelper.insert(any, argin);
		//System.out.println("inserting "+any.extract_boolean());
	}
	//===========================================
	/**
	 *	Insert method for argin is short.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(short argin)
	{
		DevShortHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is long.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(long argin)
	{
		DevLongHelper.insert(any, (int)argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is int.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(int argin)
	{
		DevLongHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is float.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(float argin)
	{
		DevFloatHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is double.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(double argin)
	{
		DevDoubleHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is String.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(String argin)
	{
		DevStringHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevState.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevState argin)
	{
		DevStateHelper.insert(any, argin);
	}

	//**********	Insert Methods for sequence types	*********************

	//===========================================
	/**
	 *	Insert method for argin is DevVarCharArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(byte[] argin)
	{
		DevVarCharArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarShortArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(short[] argin)
	{
		DevVarShortArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarLongArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(int[] argin)
	{
		DevVarLongArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarFloatArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(float[] argin)
	{
		DevVarFloatArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarDoubleArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(double[] argin)
	{
		DevVarDoubleArrayHelper.insert(any, argin);
	}

	//===========================================
	/**
	 *	Insert method for argin is DevVarStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(String[] argin)
	{
		DevVarStringArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarLongStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevVarLongStringArray argin)
	{
		DevVarLongStringArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarDoubleStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevVarDoubleStringArray argin)
	{
		DevVarDoubleStringArrayHelper.insert(any, argin);
	}






	//**********	Extract Methods for basic types	*********************


	//===========================================
	/**
	 *	extract method for a CORBA Any.
	 */
	//===========================================
	public Any extractAny()
	{
		return any;
	}
	//===========================================
	/**
	 *	extract method for a boolean.
	 */
	//===========================================
	public boolean extractBoolean()
	{
		return DevBooleanHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a short.
	 */
	//===========================================
	public short extractShort()
	{
		return DevShortHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a long.
	 */
	//===========================================
	public long extractLong()
	{
		return DevLongHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a float.
	 */
	//===========================================
	public float extractFloat()
	{
		return DevFloatHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a double.
	 */
	//===========================================
	public double extractDouble()
	{
		return DevDoubleHelper.extract(any);
	}

	//===========================================
	/**
	 *	extract method for a String.
	 */
	//===========================================
	public String extractString()
	{
		return DevStringHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevState.
	 */
	//===========================================
	public DevState extractDevState()
	{
		return DevStateHelper.extract(any);
	}



	//**********	Extract Methods for sequence types	*********************


	//===========================================
	/**
	 *	extract method for a byte Array.
	 */
	//===========================================
	public byte[] extractByteArray()
	{
		return DevVarCharArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a short Array.
	 */
	//===========================================
	public short[] extractShortArray()
	{
		return DevVarShortArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a long Array.
	 */
	//===========================================
	public int[] extractLongArray()
	{
		return DevVarLongArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a float Array.
	 */
	//===========================================
	public float[] extractFloatArray()
	{
		return DevVarFloatArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a double Array.
	 */
	//===========================================
	public double[] extractDoubleArray()
	{
		return DevVarDoubleArrayHelper.extract(any);
	}

	//===========================================
	/**
	 *	extract method for a String Array.
	 */
	//===========================================
	public String[] extractStringArray()
	{
		if (any==null)	System.out.println("any = null !!");
		return DevVarStringArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevVarLongStringArray.
	 */
	//===========================================
	public DevVarLongStringArray extractLongStringArray()
	{
		return DevVarLongStringArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevVarDoubleStringArray.
	 */
	//===========================================
	public DevVarDoubleStringArray extractDoubleStringArray()
	{
		return DevVarDoubleStringArrayHelper.extract(any);
	}
}

