//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/DbServer.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: DbServer.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;


/**
 *	Class Description:
 *	This class manage database connection for Tango server.
 *
 * @author  verdier
 * @Revision 
 */


public class DbServer
{
	/**
	 *	Database object used for TANGO databse access.
	 */
	private Database	dbase;

	/**
	 *	Device name used to access database if device not exported.
	 */
	private String servname;

	//===================================================================
	/**
	 *	DbServer constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	servname		Name of the class oject.
	 */
	//===================================================================
	public DbServer(String servname) throws DevFailed
	{
		//	Access the database
		//----------------------------
		dbase = ApiUtil.get_db_obj();
		this.servname = new String(servname);
	}
	//===================================================================
	/**
	 *	DbServer constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	servname		Name of the class oject.
	 *	@param	host	host where database is running.
	 *	@param	port	port for database connection.
	 */
	//===================================================================
	public DbServer(String servname, String host, String port) throws DevFailed
	{
		//	Access the database 
		//--------------------------
		dbase = ApiUtil.get_db_obj(host, port);
		this.servname = new String(servname);
	}

	//==========================================================================
	/**
	 *	Query the database for server information.
	 *	@return	The information found for this server
	 *				in a DBServInfo object.
	 */
	//==========================================================================
	public DbServInfo get_info() throws DevFailed
	{
		return dbase.get_server_info(servname);
	}

	//==========================================================================
	/**
	 *	Add/update server information in databse.
	 *	@param info	Server information for this server
	 *					in a DbServinfo object.
	 */
	//==========================================================================
	public void put_info(DbServInfo info) throws DevFailed
	{
		dbase.put_server_info(info);
	}

	//==========================================================================
	/**
	 *	Query the database for server devices and classes.
	 *	@return	The devices and classes (e.g. "id11/motor/1", "StepperMotor",
	 *			"id11/motor/2", "StepperMotor",....)
	 */
	//==========================================================================
	public String[] get_device_class_list() throws DevFailed
	{
		return dbase.get_device_class_list(servname);
	}

	//==========================================================================
	/**
	 *	Query the database for a list of devices served by the specified server
	 *	and of the specified class.
	 *	@param servname	The server name.
	 *	@param clasname	The class name
	 *	@return the device names are stored in an array of strings.
	 */
	//==========================================================================
	public String[] get_device_name(String classname)
				throws DevFailed
	{
		return dbase.get_device_name(servname, classname);
	}
	//===========================================================
	/**
	 *	return the server name.
	 */
	//===========================================================
	public String name()
	{
		return servname;
	}
}
