//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/DbDevice.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: DbDevice.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;


/**
 *	Class Description:
 *	This class manage database connection for Tango device.
 *	It is an api between user and IDL Device object.
 *
 * @author  verdier
 * @Revision 
 */


public class DbDevice
{
	/**
	 *	Database object used for TANGO databse access.
	 */
	private Database	dbase;

	/**
	 *	Device name used to access database if device not exported.
	 */
	private String devname;

	//===================================================================
	/**
	 *	DbDevice constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	devname		Name of the device to be imported.
	 */
	//===================================================================
	/*
	public DbDevice(String devname) throws DevFailed
	{
		//	Access the database
		//------------------------
		dbase = ApiUtil.get_db_obj();
		this.devname = new String(devname);
	}
	*/
	//===================================================================
	/**
	 *	DbDevice constructor.
	 *	It will make a connection to the TANGO database.
	 *
	 *	@param	devname		Name of the device to be imported.
	 *	@param	host	host where database is running.
	 *	@param	port	port for database connection.
	 */
	//===================================================================
	public DbDevice(String devname, String host, String port) throws DevFailed
	{
		//	Access the database
		//------------------------
		if (host==null ||port==null)
			dbase = ApiUtil.get_db_obj();
		else
			dbase = ApiUtil.get_db_obj(host, port);
		this.devname = new String(devname);
	}
	//==========================================================================
	/**
	 *	Query the database for the export info of this device.
	 *	@return the information in a DbDevImportInfo.
	 */
	//==========================================================================
	public DbDevImportInfo import_device()
				throws DevFailed
	{
		return dbase.import_device(devname);
	}
	//==========================================================================
	/**
	 *	Update the export info for this device in the database.
	 *	@param devinfo	Device information to export.
	 */
	//==========================================================================
	public void export_device(DbDevExportInfo devinfo)
				throws DevFailed
	{
		dbase.export_device(devinfo);
	}
	//==========================================================================
	/**
	 *	Add/update this device to the database
	 *	@param devinfo The device name, class and server  specified in object.
	 */
	//==========================================================================
	public void add_device(DbDevInfo devinfo) throws DevFailed
	{
		dbase.add_device(devinfo);
	}
	//==========================================================================
	/**
	 *	Delete this device from the database
	 */
	//==========================================================================
	public void delete_device() throws DevFailed
	{
		dbase.delete_device(devname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device
	 *	properties for the pecified object.
	 *	@param wildcard	propertie's wildcard (* matches any charactere).
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public String[] get_property_list(String wildcard)
				throws DevFailed
	{
		return dbase.get_device_property_list(devname, wildcard);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device properties for this device.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(String[] propnames)
				throws DevFailed
	{
		return dbase.get_device_property(devname, propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for a device property for this device.
	 *	@param propname property name.
	 *	@retun property in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum get_property(String propname)
				throws DevFailed
	{
		return dbase.get_device_property(devname, propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device properties for this device.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_property(DbDatum[] properties)
				throws DevFailed
	{
		return dbase.get_device_property(devname, properties);
	}

	//==========================================================================
	/**
	 *	Insert or update a list of properties for this device
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.put_device_property(devname, properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this device.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_property(String[] propnames)
				throws DevFailed
	{
		dbase.delete_device_property(devname, propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this device.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_property(String propname)
				throws DevFailed
	{
		dbase.delete_device_property(devname, propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this device.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.delete_device_property(devname, properties);
	}


	//==========================================================================
	/**
	 *	Insert or update a list of properties for this device attribute.
	 *	The property names and their values are specified by the DbDatum array.
	 *	
	 *	@param properties Properties names and values array.
	 */
	//==========================================================================
	public void put_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.put_device_attribute_property(devname, properties);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param propnames Property names.
	 */
	//==========================================================================
	public void delete_attribute_property(String[] propnames)
				throws DevFailed
	{
		dbase.delete_device_attribute_property(devname, propnames);
	}
	//==========================================================================
	/**
	 *	Delete a property for this object.
	 *	@param propname Property name.
	 */
	//==========================================================================
	public void delete_attribute_property(String propname)
				throws DevFailed
	{
		dbase.delete_device_attribute_property(devname, propname);
	}
	//==========================================================================
	/**
	 *	Delete a list of properties for this object.
	 *	@param properties Property DbDatum objects.
	 */
	//==========================================================================
	public void delete_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		dbase.delete_device_attribute_property(devname, properties);
	}

	//==========================================================================
	/**
	 *	Query the database for a list of device attribute
	 *	properties for this device.
	 *	@param propnames list of property names.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(String[] propnames)
				throws DevFailed
	{
		return dbase.get_device_attribute_property(devname, propnames);
	}
	//==========================================================================
	/**
	 *	Query the database for a device attribute
	 *	property for this device.
	 *	@param propname list of property name.
	 *	@retun property in DbDatum object.
	 */
	//==========================================================================
	public DbDatum get_attribute_property(String propname)
				throws DevFailed
	{
		return dbase.get_device_attribute_property(devname, propname);
	}
	//==========================================================================
	/**
	 *	Query the database for a list of device attribute
	 *	properties for this device.
	 *	The property names are specified by the DbDatum array objects.
	 *	@param properties list of property DbDatum objects.
	 *	@retun properties in DbDatum objects.
	 */
	//==========================================================================
	public DbDatum[] get_attribute_property(DbDatum[] properties)
				throws DevFailed
	{
		return dbase.get_device_attribute_property(devname, properties);
	}
	//===========================================================
	/**
	 *	return the device name.
	 */
	//===========================================================
	public String name()
	{
		return devname;
	}
}
