//+======================================================================
// $Source: /segfs/tango/tools/api/fr/esrf/TangoApi/RCS/DbDevInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: verdier $
//
// $Revision: 1.3 $
//
// $Log: DbDevInfo.java,v $
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;
 

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import java.io.*;
import java.util.*;

/** 
 *	Class Description:
 *	Device information object.
 *
 * @author  verdier
 * @Revision 
 */


public class DbDevInfo
{
	/**
	 *	The device name.
	 */
	public String	name;
	/**
	 *	The class name.
	 */
	public String	_class;
	/**
	 *	The server name.
	 */
	public String	server;

	//===============================================
	/**
	 *	Default constructor.
	 */
	//===============================================
	public DbDevInfo()
	{
	}
	//===============================================
	/**
	 *	Complete information constructor.
	 */
	//===============================================
	public DbDevInfo(String name, String _class, String server)
	{
		this.name = new String(name);
		this._class = new String(_class);
		this.server = new String(server);
	}
	//===============================================
	/**
	 *	Serialize object filed as string array.
	 */
	//===============================================
	public String[] toStringArray()
	{
		String[]	argout;
		argout = new String[3];
		argout[0] = server;
		argout[1] = name;
		argout[2] = _class;
		return argout;
	}
}
